/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.devtools.restart.ClassLoaderFilesResourcePatternResolver;
import org.springframework.boot.devtools.restart.DefaultRestartInitializer;
import org.springframework.boot.devtools.restart.FailureHandler;
import org.springframework.boot.devtools.restart.MainMethod;
import org.springframework.boot.devtools.restart.RestartInitializer;
import org.springframework.boot.devtools.restart.RestartLauncher;
import org.springframework.boot.devtools.restart.SilentExitExceptionHandler;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFiles;
import org.springframework.boot.devtools.restart.classloader.RestartClassLoader;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.cglib.core.ClassNameReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class Restarter {
    private static final Object INSTANCE_MONITOR = new Object();
    private static final String[] NO_ARGS = new String[0];
    private static Restarter instance;
    private final Set<URL> urls = new LinkedHashSet<URL>();
    private final ClassLoaderFiles classLoaderFiles = new ClassLoaderFiles();
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final BlockingDeque<LeakSafeThread> leakSafeThreads = new LinkedBlockingDeque<LeakSafeThread>();
    private final Lock stopLock = new ReentrantLock();
    private final Object monitor = new Object();
    private Log logger = new DeferredLog();
    private final boolean forceReferenceCleanup;
    private boolean enabled = true;
    private final URL[] initialUrls;
    private final String mainClassName;
    private final ClassLoader applicationClassLoader;
    private final String[] args;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private boolean finished = false;
    private final List<ConfigurableApplicationContext> rootContexts = new CopyOnWriteArrayList<ConfigurableApplicationContext>();

    protected Restarter(Thread thread, String[] args, boolean forceReferenceCleanup, RestartInitializer initializer) {
        Assert.notNull((Object)thread, (String)"Thread must not be null");
        Assert.notNull((Object)args, (String)"Args must not be null");
        Assert.notNull((Object)initializer, (String)"Initializer must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new Restarter for thread " + String.valueOf(thread)));
        }
        SilentExitExceptionHandler.setup(thread);
        this.forceReferenceCleanup = forceReferenceCleanup;
        this.initialUrls = initializer.getInitialUrls(thread);
        this.mainClassName = this.getMainClassName(thread);
        this.applicationClassLoader = thread.getContextClassLoader();
        this.args = args;
        this.exceptionHandler = thread.getUncaughtExceptionHandler();
        this.leakSafeThreads.add(new LeakSafeThread());
    }

    private String getMainClassName(Thread thread) {
        try {
            return new MainMethod(thread).getDeclaringClassName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected void initialize(boolean restartOnInitialize) {
        this.preInitializeLeakyClasses();
        if (this.initialUrls != null) {
            this.urls.addAll(Arrays.asList(this.initialUrls));
            if (restartOnInitialize) {
                this.logger.debug((Object)"Immediately restarting application");
                this.immediateRestart();
            }
        }
    }

    private void immediateRestart() {
        try {
            this.getLeakSafeThread().callAndWait(() -> {
                this.start(FailureHandler.NONE);
                this.cleanupCaches();
                return null;
            });
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Unable to initialize restarter", (Throwable)ex);
        }
        SilentExitExceptionHandler.exitCurrentThread();
    }

    private void preInitializeLeakyClasses() {
        try {
            Class<ClassNameReader> readerClass = ClassNameReader.class;
            Field field = readerClass.getDeclaredField("EARLY_EXIT");
            field.setAccessible(true);
            ((Throwable)field.get(null)).fillInStackTrace();
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Unable to pre-initialize classes", (Throwable)ex);
        }
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void addUrls(Collection<URL> urls) {
        Assert.notNull(urls, (String)"Urls must not be null");
        this.urls.addAll(urls);
    }

    public void addClassLoaderFiles(ClassLoaderFiles classLoaderFiles) {
        Assert.notNull((Object)classLoaderFiles, (String)"ClassLoaderFiles must not be null");
        this.classLoaderFiles.addAll(classLoaderFiles);
    }

    public ThreadFactory getThreadFactory() {
        return new LeakSafeThreadFactory();
    }

    public void restart() {
        this.restart(FailureHandler.NONE);
    }

    public void restart(FailureHandler failureHandler) {
        if (!this.enabled) {
            this.logger.debug((Object)"Application restart is disabled");
            return;
        }
        this.logger.debug((Object)"Restarting application");
        this.getLeakSafeThread().call(() -> {
            this.stop();
            this.start(failureHandler);
            return null;
        });
    }

    protected void start(FailureHandler failureHandler) throws Exception {
        Throwable error;
        do {
            if ((error = this.doStart()) != null) continue;
            return;
        } while (failureHandler.handle(error) != FailureHandler.Outcome.ABORT);
    }

    private Throwable doStart() throws Exception {
        Assert.notNull((Object)this.mainClassName, (String)"Unable to find the main class to restart");
        URL[] urls = this.urls.toArray(new URL[0]);
        ClassLoaderFiles updatedFiles = new ClassLoaderFiles(this.classLoaderFiles);
        RestartClassLoader classLoader = new RestartClassLoader(this.applicationClassLoader, urls, updatedFiles);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Starting application " + this.mainClassName + " with URLs " + String.valueOf(Arrays.asList(urls))));
        }
        return this.relaunch(classLoader);
    }

    protected Throwable relaunch(ClassLoader classLoader) throws Exception {
        RestartLauncher launcher = new RestartLauncher(classLoader, this.mainClassName, this.args, this.exceptionHandler);
        launcher.start();
        launcher.join();
        return launcher.getError();
    }

    protected void stop() throws Exception {
        this.logger.debug((Object)"Stopping application");
        this.stopLock.lock();
        try {
            for (ConfigurableApplicationContext context : this.rootContexts) {
                context.close();
                this.rootContexts.remove(context);
            }
            this.cleanupCaches();
            if (this.forceReferenceCleanup) {
                this.forceReferenceCleanup();
            }
        }
        finally {
            this.stopLock.unlock();
        }
        System.gc();
        System.runFinalization();
    }

    private void cleanupCaches() {
        Introspector.flushCaches();
        this.cleanupKnownCaches();
    }

    private void cleanupKnownCaches() {
        ResolvableType.clearCache();
        this.cleanCachedIntrospectionResultsCache();
        ReflectionUtils.clearCache();
        this.clearAnnotationUtilsCache();
    }

    private void cleanCachedIntrospectionResultsCache() {
        this.clear(CachedIntrospectionResults.class, "acceptedClassLoaders");
        this.clear(CachedIntrospectionResults.class, "strongClassCache");
        this.clear(CachedIntrospectionResults.class, "softClassCache");
    }

    private void clearAnnotationUtilsCache() {
        try {
            AnnotationUtils.clearCache();
        }
        catch (Throwable ex) {
            this.clear(AnnotationUtils.class, "findAnnotationCache");
            this.clear(AnnotationUtils.class, "annotatedInterfaceCache");
        }
    }

    private void clear(Class<?> type, String fieldName) {
        block4: {
            try {
                Field field = type.getDeclaredField(fieldName);
                field.setAccessible(true);
                Object instance = field.get(null);
                if (instance instanceof Set) {
                    ((Set)instance).clear();
                }
                if (instance instanceof Map) {
                    ((Map)instance).keySet().removeIf(this::isFromRestartClassLoader);
                }
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug((Object)("Unable to clear field " + String.valueOf(type) + " " + fieldName), (Throwable)ex);
            }
        }
    }

    private boolean isFromRestartClassLoader(Object object) {
        return object instanceof Class && ((Class)object).getClassLoader() instanceof RestartClassLoader;
    }

    private void forceReferenceCleanup() {
        try {
            LinkedList<long[]> memory = new LinkedList<long[]>();
            while (true) {
                memory.add(new long[102400]);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish() {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.isFinished()) {
                this.logger = DeferredLog.replay((Log)this.logger, (Log)LogFactory.getLog(this.getClass()));
                this.finished = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFinished() {
        Object object = this.monitor;
        synchronized (object) {
            return this.finished;
        }
    }

    void prepare(ConfigurableApplicationContext applicationContext) {
        if (!this.enabled || applicationContext != null && applicationContext.getParent() != null) {
            return;
        }
        if (applicationContext instanceof GenericApplicationContext) {
            GenericApplicationContext genericContext = (GenericApplicationContext)applicationContext;
            this.prepare(genericContext);
        }
        this.rootContexts.add(applicationContext);
    }

    void remove(ConfigurableApplicationContext applicationContext) {
        if (applicationContext != null) {
            this.rootContexts.remove(applicationContext);
        }
    }

    private void prepare(GenericApplicationContext applicationContext) {
        ClassLoaderFilesResourcePatternResolver resourceLoader = new ClassLoaderFilesResourcePatternResolver((AbstractApplicationContext)applicationContext, this.classLoaderFiles);
        applicationContext.setResourceLoader((ResourceLoader)resourceLoader);
    }

    private LeakSafeThread getLeakSafeThread() {
        try {
            return this.leakSafeThreads.takeFirst();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
    }

    public Object getOrAddAttribute(String name, ObjectFactory<?> objectFactory) {
        Object value = this.attributes.get(name);
        if (value == null) {
            value = objectFactory.getObject();
            this.attributes.put(name, value);
        }
        return value;
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public URL[] getInitialUrls() {
        return this.initialUrls;
    }

    public static void disable() {
        Restarter.initialize(NO_ARGS, false, RestartInitializer.NONE);
        Restarter.getInstance().setEnabled(false);
    }

    public static void initialize(String[] args) {
        Restarter.initialize(args, false, new DefaultRestartInitializer());
    }

    public static void initialize(String[] args, RestartInitializer initializer) {
        Restarter.initialize(args, false, initializer, true);
    }

    public static void initialize(String[] args, boolean forceReferenceCleanup) {
        Restarter.initialize(args, forceReferenceCleanup, new DefaultRestartInitializer());
    }

    public static void initialize(String[] args, boolean forceReferenceCleanup, RestartInitializer initializer) {
        Restarter.initialize(args, forceReferenceCleanup, initializer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(String[] args, boolean forceReferenceCleanup, RestartInitializer initializer, boolean restartOnInitialize) {
        Restarter localInstance = null;
        Object object = INSTANCE_MONITOR;
        synchronized (object) {
            if (instance == null) {
                instance = localInstance = new Restarter(Thread.currentThread(), args, forceReferenceCleanup, initializer);
            }
        }
        if (localInstance != null) {
            localInstance.initialize(restartOnInitialize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Restarter getInstance() {
        Object object = INSTANCE_MONITOR;
        synchronized (object) {
            Assert.state((instance != null ? 1 : 0) != 0, (String)"Restarter has not been initialized");
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInstance(Restarter instance) {
        Object object = INSTANCE_MONITOR;
        synchronized (object) {
            Restarter.instance = instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInstance() {
        Object object = INSTANCE_MONITOR;
        synchronized (object) {
            instance = null;
        }
    }

    private class LeakSafeThread
    extends Thread {
        private Callable<?> callable;
        private Object result;

        LeakSafeThread() {
            this.setDaemon(false);
        }

        void call(Callable<?> callable) {
            this.callable = callable;
            this.start();
        }

        <V> V callAndWait(Callable<V> callable) {
            this.callable = callable;
            this.start();
            try {
                this.join();
                return (V)this.result;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public void run() {
            try {
                Restarter.this.leakSafeThreads.put(new LeakSafeThread());
                this.result = this.callable.call();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
    }

    private final class LeakSafeThreadFactory
    implements ThreadFactory {
        private LeakSafeThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return Restarter.this.getLeakSafeThread().callAndWait(() -> {
                Thread thread = new Thread(runnable);
                thread.setContextClassLoader(Restarter.this.applicationClassLoader);
                return thread;
            });
        }
    }
}

