/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.couchbase;

import com.couchbase.client.core.env.KeyValueServiceConfig;
import com.couchbase.client.core.env.QueryServiceConfig;
import com.couchbase.client.core.env.ViewServiceConfig;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseBucket;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.util.function.BiFunction;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseProperties;
import org.springframework.boot.autoconfigure.couchbase.OnBootstrapHostsCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnClass(value={CouchbaseBucket.class, Cluster.class})
@Conditional(value={CouchbaseCondition.class})
@EnableConfigurationProperties(value={CouchbaseProperties.class})
public class CouchbaseAutoConfiguration {

    static class CouchbaseCondition
    extends AnyNestedCondition {
        CouchbaseCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(type={"org.springframework.data.couchbase.config.CouchbaseConfigurer"})
        static class CouchbaseConfigurerAvailable {
            CouchbaseConfigurerAvailable() {
            }
        }

        @Conditional(value={OnBootstrapHostsCondition.class})
        static class BootstrapHostsProperty {
            BootstrapHostsProperty() {
            }
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={CouchbaseConfiguration.class}, type={"org.springframework.data.couchbase.config.CouchbaseConfigurer"})
    public static class CouchbaseConfiguration {
        private final CouchbaseProperties properties;

        public CouchbaseConfiguration(CouchbaseProperties properties) {
            this.properties = properties;
        }

        @Bean
        @Primary
        public DefaultCouchbaseEnvironment couchbaseEnvironment() throws Exception {
            return this.initializeEnvironmentBuilder(this.properties).build();
        }

        @Bean
        @Primary
        public Cluster couchbaseCluster() throws Exception {
            return CouchbaseCluster.create((CouchbaseEnvironment)this.couchbaseEnvironment(), this.properties.getBootstrapHosts());
        }

        @Bean
        @Primary
        @DependsOn(value={"couchbaseClient"})
        public ClusterInfo couchbaseClusterInfo() throws Exception {
            return this.couchbaseCluster().clusterManager(this.properties.getBucket().getName(), this.properties.getBucket().getPassword()).info();
        }

        @Bean
        @Primary
        public Bucket couchbaseClient() throws Exception {
            return this.couchbaseCluster().openBucket(this.properties.getBucket().getName(), this.properties.getBucket().getPassword());
        }

        protected DefaultCouchbaseEnvironment.Builder initializeEnvironmentBuilder(CouchbaseProperties properties) {
            CouchbaseProperties.Ssl ssl;
            CouchbaseProperties.Endpoints endpoints = properties.getEnv().getEndpoints();
            CouchbaseProperties.Timeouts timeouts = properties.getEnv().getTimeouts();
            DefaultCouchbaseEnvironment.Builder builder = DefaultCouchbaseEnvironment.builder();
            if (timeouts.getConnect() != null) {
                builder = builder.connectTimeout(timeouts.getConnect().toMillis());
            }
            builder = (DefaultCouchbaseEnvironment.Builder)builder.keyValueServiceConfig(KeyValueServiceConfig.create((int)endpoints.getKeyValue()));
            if (timeouts.getKeyValue() != null) {
                builder = builder.kvTimeout(timeouts.getKeyValue().toMillis());
            }
            if (timeouts.getQuery() != null) {
                builder = builder.queryTimeout(timeouts.getQuery().toMillis());
                builder = (DefaultCouchbaseEnvironment.Builder)builder.queryServiceConfig(this.getQueryServiceConfig(endpoints));
                builder = (DefaultCouchbaseEnvironment.Builder)builder.viewServiceConfig(this.getViewServiceConfig(endpoints));
            }
            if (timeouts.getSocketConnect() != null) {
                builder = (DefaultCouchbaseEnvironment.Builder)builder.socketConnectTimeout((int)timeouts.getSocketConnect().toMillis());
            }
            if (timeouts.getView() != null) {
                builder = builder.viewTimeout(timeouts.getView().toMillis());
            }
            if ((ssl = properties.getEnv().getSsl()).getEnabled().booleanValue()) {
                builder = (DefaultCouchbaseEnvironment.Builder)builder.sslEnabled(true);
                if (ssl.getKeyStore() != null) {
                    builder = (DefaultCouchbaseEnvironment.Builder)builder.sslKeystoreFile(ssl.getKeyStore());
                }
                if (ssl.getKeyStorePassword() != null) {
                    builder = (DefaultCouchbaseEnvironment.Builder)builder.sslKeystorePassword(ssl.getKeyStorePassword());
                }
            }
            return builder;
        }

        private QueryServiceConfig getQueryServiceConfig(CouchbaseProperties.Endpoints endpoints) {
            return this.getServiceConfig(endpoints.getQueryservice(), endpoints.getQuery(), QueryServiceConfig::create);
        }

        private ViewServiceConfig getViewServiceConfig(CouchbaseProperties.Endpoints endpoints) {
            return this.getServiceConfig(endpoints.getViewservice(), endpoints.getView(), ViewServiceConfig::create);
        }

        private <T> T getServiceConfig(CouchbaseProperties.Endpoints.CouchbaseService service, Integer fallback, BiFunction<Integer, Integer, T> factory) {
            if (service.getMinEndpoints() != 1 || service.getMaxEndpoints() != 1) {
                return factory.apply(service.getMinEndpoints(), service.getMaxEndpoints());
            }
            int endpoints = fallback != null ? fallback : 1;
            return factory.apply(endpoints, endpoints);
        }
    }
}

