/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.data.mongo;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.data.mongo.MongoReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.mongo.MongoReactiveDataAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import reactor.core.publisher.Flux;

@AutoConfiguration(after={MongoReactiveDataAutoConfiguration.class})
@ConditionalOnClass(value={ReactiveMongoTemplate.class, Flux.class})
@ConditionalOnBean(value={ReactiveMongoTemplate.class})
@ConditionalOnEnabledHealthIndicator(value="mongo")
public class MongoReactiveHealthContributorAutoConfiguration
extends CompositeReactiveHealthContributorConfiguration<MongoReactiveHealthIndicator, ReactiveMongoTemplate> {
    public MongoReactiveHealthContributorAutoConfiguration() {
        super(MongoReactiveHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"mongoHealthIndicator", "mongoHealthContributor"})
    public ReactiveHealthContributor mongoHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (ReactiveHealthContributor)this.createContributor(beanFactory, ReactiveMongoTemplate.class);
    }
}

