/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.couchbase;

import com.couchbase.client.java.Cluster;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.couchbase.CouchbaseReactiveHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.couchbase.CouchbaseHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={CouchbaseAutoConfiguration.class, CouchbaseReactiveHealthContributorAutoConfiguration.class})
@ConditionalOnClass(value={Cluster.class})
@ConditionalOnBean(value={Cluster.class})
@ConditionalOnEnabledHealthIndicator(value="couchbase")
public class CouchbaseHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<CouchbaseHealthIndicator, Cluster> {
    public CouchbaseHealthContributorAutoConfiguration() {
        super(CouchbaseHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"couchbaseHealthIndicator", "couchbaseHealthContributor"})
    public HealthContributor couchbaseHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, Cluster.class);
    }
}

