/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.client;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.boot.actuate.metrics.web.client.ObservationRestClientCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.observation.ClientRequestObservationConvention;
import org.springframework.http.client.observation.DefaultClientRequestObservationConvention;
import org.springframework.web.client.RestClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RestClient.class})
@ConditionalOnBean(value={RestClient.Builder.class})
class RestClientObservationConfiguration {
    RestClientObservationConfiguration() {
    }

    @Bean
    RestClientCustomizer observationRestClientCustomizer(ObservationRegistry observationRegistry, ObjectProvider<ClientRequestObservationConvention> customConvention, ObservationProperties observationProperties) {
        String name = observationProperties.getHttp().getClient().getRequests().getName();
        ClientRequestObservationConvention observationConvention = (ClientRequestObservationConvention)customConvention.getIfAvailable(() -> new DefaultClientRequestObservationConvention(name));
        return new ObservationRestClientCustomizer(observationRegistry, observationConvention);
    }
}

