/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.redis;

import io.lettuce.core.RedisClient;
import io.lettuce.core.metrics.CommandLatencyRecorder;
import io.lettuce.core.metrics.MicrometerCommandLatencyRecorder;
import io.lettuce.core.metrics.MicrometerOptions;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.ClientResourcesBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={RedisAutoConfiguration.class}, after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={RedisClient.class, MicrometerCommandLatencyRecorder.class})
@ConditionalOnBean(value={MeterRegistry.class})
public class LettuceMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    MicrometerOptions micrometerOptions() {
        return MicrometerOptions.create();
    }

    @Bean
    ClientResourcesBuilderCustomizer lettuceMetrics(MeterRegistry meterRegistry, MicrometerOptions options) {
        return client -> client.commandLatencyRecorder((CommandLatencyRecorder)new MicrometerCommandLatencyRecorder(meterRegistry, options));
    }
}

