/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.AutoConfiguredReactiveHealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.actuate.health.ReactiveHealthContributorRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Flux.class})
@ConditionalOnBean(value={HealthEndpoint.class})
class ReactiveHealthEndpointConfiguration {
    ReactiveHealthEndpointConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    ReactiveHealthContributorRegistry reactiveHealthContributorRegistry(Map<String, HealthContributor> healthContributors, Map<String, ReactiveHealthContributor> reactiveHealthContributors, HealthEndpointGroups groups) {
        LinkedHashMap<String, ReactiveHealthContributor> allContributors = new LinkedHashMap<String, ReactiveHealthContributor>(reactiveHealthContributors);
        healthContributors.forEach((name, contributor) -> allContributors.computeIfAbsent((String)name, key -> ReactiveHealthContributor.adapt((HealthContributor)contributor)));
        return new AutoConfiguredReactiveHealthContributorRegistry(allContributors, groups.getNames());
    }
}

