/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.cache;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonar.runner.cache.DirectoryLock;
import org.sonar.runner.cache.Logger;
import org.sonar.runner.cache.PersistentCache;
import org.sonar.runner.cache.TTLCacheInvalidation;

public class PersistentCacheBuilder {
    private static final long DEFAULT_EXPIRE_DURATION = TimeUnit.MILLISECONDS.convert(9999L, TimeUnit.DAYS);
    private static final String DIR_NAME = "ws_cache";
    private Path cacheBasePath;
    private Path relativePath;
    private final Logger logger;

    public PersistentCacheBuilder(Logger logger) {
        this.logger = logger;
    }

    public PersistentCacheBuilder setAreaForProject(String serverUrl, String serverVersion, String projectKey) {
        this.relativePath = Paths.get(PersistentCacheBuilder.sanitizeFilename(serverUrl), new String[0]).resolve(PersistentCacheBuilder.sanitizeFilename(serverVersion)).resolve("projects").resolve(PersistentCacheBuilder.sanitizeFilename(projectKey));
        return this;
    }

    public PersistentCacheBuilder setAreaForGlobal(String serverUrl) {
        this.relativePath = Paths.get(PersistentCacheBuilder.sanitizeFilename(serverUrl), new String[0]).resolve("global");
        return this;
    }

    public PersistentCacheBuilder setAreaForLocalProject(String serverUrl, String serverVersion) {
        this.relativePath = Paths.get(PersistentCacheBuilder.sanitizeFilename(serverUrl), new String[0]).resolve(PersistentCacheBuilder.sanitizeFilename(serverVersion)).resolve("local");
        return this;
    }

    public PersistentCacheBuilder setSonarHome(@Nullable Path p) {
        if (p != null) {
            this.cacheBasePath = p.resolve(DIR_NAME);
        }
        return this;
    }

    public PersistentCache build() {
        if (this.relativePath == null) {
            throw new IllegalStateException("area must be set before building");
        }
        if (this.cacheBasePath == null) {
            this.setSonarHome(PersistentCacheBuilder.findHome());
        }
        Path cachePath = this.cacheBasePath.resolve(this.relativePath);
        DirectoryLock lock = new DirectoryLock(this.cacheBasePath, this.logger);
        TTLCacheInvalidation criteria = new TTLCacheInvalidation(DEFAULT_EXPIRE_DURATION);
        return new PersistentCache(cachePath, criteria, this.logger, lock);
    }

    private static Path findHome() {
        String home = System.getenv("SONAR_USER_HOME");
        if (home != null) {
            return Paths.get(home, new String[0]);
        }
        home = System.getProperty("user.home");
        return Paths.get(home, ".sonar");
    }

    private static String sanitizeFilename(String name) {
        try {
            return URLEncoder.encode(name, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Couldn't sanitize filename: " + name, e);
        }
    }
}

