/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.browserlaunchers.locators.GoogleChromeLocator;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;

public class GoogleChromeLauncher
extends AbstractBrowserLauncher {
    private static final Logger log = Logger.getLogger(GoogleChromeLauncher.class.getName());
    private BrowserInstallation browserInstallation;
    private File customProfileDir;
    private CommandLine process;

    public GoogleChromeLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        this(browserOptions, configuration, sessionId, ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("googlechrome", browserLaunchLocation, (BrowserLocator)new GoogleChromeLocator()));
    }

    public GoogleChromeLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(sessionId, configuration, browserOptions);
        this.browserInstallation = browserInstallation;
    }

    @Override
    protected void launch(String url) {
        log.info("Launching Google Chrome...");
        this.createProfile(this.sessionId, url);
        String[] cmdArray = this.createCommandArray(url);
        this.process = new CommandLine(cmdArray);
        this.process.executeAsync();
    }

    public void close() {
        log.info("Killing Google Chrome...");
        if (this.process == null) {
            return;
        }
        int exitValue = this.process.destroy();
        if (exitValue == 0) {
            log.warning("Google Chrome seems to have ended on its own.");
        }
        try {
            LauncherUtils.recursivelyDeleteDir((File)this.customProfileDir);
        }
        catch (RuntimeException e) {
            String errorMessage = "Couldn't delete custom profile directory";
            log.log(Level.SEVERE, "Couldn't delete custom profile directory", e);
            throw new RuntimeException("Couldn't delete custom profile directory", e);
        }
    }

    private String getUntrustedCertificatesFlag() {
        if (this.browserConfigurationOptions.is("trustAllSSLCertificates")) {
            return "--ignore-certificate-errors";
        }
        return "";
    }

    private void createProfile(String sessionId, String url) {
        try {
            this.customProfileDir = LauncherUtils.createCustomProfileDir((String)sessionId);
        }
        catch (RuntimeException e) {
            String errorMessage = "Couldn't create custom profile directory";
            log.log(Level.SEVERE, "Couldn't create custom profile directory", e);
            throw new RuntimeException("Couldn't create custom profile directory", e);
        }
        File defaultDir = new File(this.customProfileDir, "Default");
        defaultDir.mkdir();
        PrefNode prefs = new PrefNode();
        prefs.setPref("alternate_error_pages.enabled", "false");
        prefs.setPref("bookmark_bar.show_on_all_tabs", "false");
        prefs.setPref("dns_prefetching.enabled", "false");
        prefs.setPref("profile.password_manager_enabled", "false");
        prefs.setPref("safebrowsing.enabled", "false");
        prefs.setPref("search.suggest_enabled", "false");
        prefs.setPref("security.cookie_behavior", "0");
        prefs.setPref("security.mixed_content_filtering", "0");
        prefs.setPref("webkit.webprefs.javascript_can_open_windows_automatically", "true");
        prefs.setPref("webkit.webprefs.javascript_enabled", "true");
        try {
            File prefsFile = new File(defaultDir, "Preferences");
            PrintStream out = new PrintStream(new FileOutputStream(prefsFile));
            out.println(prefs.toString());
            out.close();
        }
        catch (IOException e) {
            String errorMessage = "Couldn't create preferences file";
            log.log(Level.SEVERE, "Couldn't create preferences file", e);
            throw new RuntimeException("Couldn't create preferences file", e);
        }
    }

    private String[] createCommandArray(String url) {
        String userDir = this.customProfileDir.getAbsolutePath();
        ArrayList array = Lists.newArrayList((Object[])new String[]{this.browserInstallation.launcherFilePath(), "--disable-hang-monitor", "--disable-metrics", "--disable-popup-blocking", "--disable-prompt-on-repost", "--proxy-server=localhost:" + this.getPort(), "--start-maximized", "--no-first-run", "--activate-on-launch", "--no-default-browser-check", "--disable-translate", "--disable-web-security", "--user-data-dir=" + userDir, this.getUntrustedCertificatesFlag()});
        array.addAll(Lists.newArrayList((Object[])this.getCommandLineFlagsAsArray()));
        array.add(url);
        return array.toArray(new String[array.size()]);
    }

    private class PrefLeafNode
    extends PrefNode {
        private String value;

        public PrefLeafNode() {
            super(true);
        }

        @Override
        protected void setPref(String[] prefParts, int index, String value) {
            this.value = value;
        }

        @Override
        protected void buildString(StringBuilder builder) {
            builder.append('\"');
            builder.append(this.name);
            builder.append('\"');
            builder.append(':');
            builder.append(this.value);
        }
    }

    private class PrefNode {
        protected String name;
        private Map<String, PrefNode> prefs;

        public PrefNode() {
            this(false);
        }

        protected PrefNode(boolean isLeaf) {
            if (!isLeaf) {
                this.prefs = new HashMap<String, PrefNode>();
            }
        }

        public void setPref(String pref, String value) {
            String[] prefParts = pref.split("\\.");
            this.setPref(prefParts, 0, value);
        }

        private boolean isLastIndex(String[] array, int index) {
            return index + 1 == array.length;
        }

        protected void setPref(String[] prefParts, int index, String value) {
            String name = prefParts[index];
            if (!this.prefs.containsKey(name)) {
                if (this.isLastIndex(prefParts, index)) {
                    this.prefs.put(name, new PrefLeafNode());
                } else {
                    this.prefs.put(name, new PrefNode());
                }
            }
            PrefNode node = this.prefs.get(name);
            node.name = name;
            node.setPref(prefParts, index + 1, value);
        }

        protected void buildString(StringBuilder builder) {
            if (this.name != null) {
                builder.append('\"');
                builder.append(this.name);
                builder.append('\"');
                builder.append(':');
            }
            builder.append('{');
            int index = 0;
            for (PrefNode pref : this.prefs.values()) {
                pref.buildString(builder);
                if (++index >= this.prefs.size()) continue;
                builder.append(',');
            }
            builder.append('}');
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.buildString(builder);
            return builder.toString();
        }
    }
}

