/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.interactions;

import java.util.Map;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class ClickInSession
extends WebDriverHandler
implements JsonParametersAware {
    volatile boolean leftMouseButton = true;

    public ClickInSession(Session session) {
        super(session);
    }

    @Override
    public ResultType call() throws Exception {
        Mouse mouse = ((HasInputDevices)this.getDriver()).getMouse();
        if (this.leftMouseButton) {
            mouse.click(null);
        } else {
            mouse.contextClick(null);
        }
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[click: %s]", "nothing");
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        if (allParameters.containsKey("button")) {
            int button = ((Long)allParameters.get("button")).intValue();
            switch (button) {
                case 0: {
                    this.leftMouseButton = true;
                    break;
                }
                case 2: {
                    this.leftMouseButton = false;
                }
            }
        }
    }
}

