/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.web.servlet.RegistryBasedServlet;

public class HubStatusServlet
extends RegistryBasedServlet {
    public HubStatusServlet() {
        super(null);
    }

    public HubStatusServlet(Registry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        try {
            JSONObject res = this.getResponse(request);
            response.getWriter().print(res);
            response.getWriter().close();
        }
        catch (JSONException e) {
            throw new GridException(e.getMessage());
        }
    }

    private JSONObject getResponse(HttpServletRequest request) throws IOException, JSONException {
        JSONObject res = new JSONObject();
        res.put("success", true);
        try {
            if (request.getInputStream() != null) {
                Set<String> paramsToReturn;
                JSONObject requestJSON = this.getRequestJSON(request);
                JSONArray keys = requestJSON != null ? requestJSON.getJSONArray("configuration") : null;
                Registry registry = this.getRegistry();
                Map<String, Object> allParams = registry.getConfiguration().getAllParams();
                if (requestJSON == null || keys.length() == 0) {
                    paramsToReturn = allParams.keySet();
                } else {
                    paramsToReturn = new HashSet<String>();
                    for (int i = 0; i < keys.length(); ++i) {
                        paramsToReturn.add(keys.getString(i));
                    }
                }
                if (paramsToReturn.contains("newSessionRequestCount")) {
                    res.put("newSessionRequestCount", registry.getNewSessionRequestCount());
                    paramsToReturn.remove("newSessionRequestCount");
                }
                if (paramsToReturn.contains("slotCounts")) {
                    res.put("slotCounts", (Object)this.getSlotCounts());
                    paramsToReturn.remove("slotCounts");
                }
                for (String key : paramsToReturn) {
                    Object value = allParams.get(key);
                    if (value == null) {
                        res.put(key, JSONObject.NULL);
                        continue;
                    }
                    res.put(key, value);
                }
            }
        }
        catch (Exception e) {
            res.put("success", false);
            res.put("msg", (Object)e.getMessage());
        }
        return res;
    }

    private JSONObject getSlotCounts() throws JSONException {
        int freeSlots = 0;
        int totalSlots = 0;
        for (RemoteProxy proxy : this.getRegistry().getAllProxies()) {
            for (TestSlot slot : proxy.getTestSlots()) {
                if (slot.getSession() == null) {
                    ++freeSlots;
                }
                ++totalSlots;
            }
        }
        JSONObject result = new JSONObject();
        result.put("free", freeSlots);
        result.put("total", totalSlots);
        return result;
    }

    private JSONObject getRequestJSON(HttpServletRequest request) throws IOException, JSONException {
        String line;
        JSONObject requestJSON = null;
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        StringBuilder s = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            s.append(line);
        }
        rd.close();
        String json = s.toString();
        if (!"".equals(json)) {
            requestJSON = new JSONObject(json);
        }
        return requestJSON;
    }
}

