/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureTimeout
extends WebDriverHandler
implements JsonParametersAware {
    private volatile String type;
    private volatile long millis;

    public ConfigureTimeout(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.type = (String)allParameters.get("type");
        this.millis = ((Number)allParameters.get("ms")).longValue();
    }

    @Override
    public ResultType call() throws Exception {
        if ("implicit".equals(this.type)) {
            this.getDriver().manage().timeouts().implicitlyWait(this.millis, TimeUnit.MILLISECONDS);
        } else if ("page load".equals(this.type)) {
            this.getDriver().manage().timeouts().pageLoadTimeout(this.millis, TimeUnit.MILLISECONDS);
        } else if ("script".equals(this.type)) {
            this.getDriver().manage().timeouts().setScriptTimeout(this.millis, TimeUnit.MILLISECONDS);
        } else {
            throw new WebDriverException("Unknown wait type: " + this.type);
        }
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[implicitly wait: %s]", this.millis);
    }
}

