/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.ChunkingInputStream;
import org.openqa.jetty.http.HttpFields;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LineInput;
import org.openqa.jetty.util.StringUtil;

public class HttpInputStream
extends FilterInputStream {
    private static Log log = LogFactory.getLog(HttpInputStream.class);
    private static ClosedStream __closedStream = new ClosedStream();
    private ChunkingInputStream _deChunker;
    private LineInput _realIn;
    private boolean _chunking;
    private OutputStream _expectContinues;

    public HttpInputStream(InputStream in) {
        this(in, 4096);
    }

    public HttpInputStream(InputStream in, int bufferSize) {
        super(null);
        try {
            this._realIn = new LineInput(in, bufferSize, StringUtil.__ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)e);
            System.exit(1);
        }
        this.in = this._realIn;
    }

    public OutputStream getExpectContinues() {
        return this._expectContinues;
    }

    public void setExpectContinues(OutputStream expectContinues) {
        this._expectContinues = expectContinues;
    }

    public int read() throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.read(b);
    }

    public long skip(long n) throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.skip(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expectContinues() throws IOException {
        try {
            if (this.available() <= 0) {
                this._expectContinues.write(HttpResponse.__Continue);
                this._expectContinues.flush();
            }
            Object var2_1 = null;
            this._expectContinues = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._expectContinues = null;
            throw throwable;
        }
    }

    public InputStream getInputStream() {
        return this._realIn;
    }

    public InputStream getFilterStream() {
        return this.in;
    }

    public void setFilterStream(InputStream filter) {
        this.in = filter;
    }

    public boolean isChunking() {
        return this._chunking;
    }

    public void setChunking() throws IllegalStateException {
        if (this._realIn.getByteLimit() >= 0) {
            throw new IllegalStateException("Has Content-Length");
        }
        if (this._deChunker == null) {
            this._deChunker = new ChunkingInputStream(this._realIn);
        }
        this.in = this._deChunker;
        this._chunking = true;
        this._deChunker._trailer = null;
    }

    public void resetStream() throws IllegalStateException {
        if (this._deChunker != null && this._deChunker._chunkSize > 0 || this._realIn.getByteLimit() > 0) {
            throw new IllegalStateException("Unread input");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"resetStream()");
        }
        this.in = this._realIn;
        if (this._deChunker != null) {
            this._deChunker.resetStream();
        }
        this._chunking = false;
        this._realIn.setByteLimit(-1);
    }

    public void close() throws IOException {
        this.in = __closedStream;
    }

    public void setContentLength(int len) {
        if (this._chunking && len >= 0 && this.getExpectContinues() == null) {
            throw new IllegalStateException("Chunking");
        }
        this._realIn.setByteLimit(len);
    }

    void unsafeSetContentLength(int len) {
        this._realIn.setByteLimit(len);
    }

    public int getContentLength() {
        return this._realIn.getByteLimit();
    }

    public HttpFields getTrailer() {
        return this._deChunker._trailer;
    }

    public void destroy() {
        if (this._realIn != null) {
            this._realIn.destroy();
        }
        this._realIn = null;
        this._deChunker = null;
        this._expectContinues = null;
    }

    private static class ClosedStream
    extends InputStream {
        private ClosedStream() {
        }

        public int read() throws IOException {
            return -1;
        }
    }
}

