/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.RemoteCommand;
import org.openqa.selenium.net.Urls;

public class DefaultRemoteCommand
implements RemoteCommand {
    private static final int NUMARGSINCLUDINGBOUNDARIES = 4;
    private static final int FIRSTINDEX = 1;
    private static final int SECONDINDEX = 2;
    private static final int THIRDINDEX = 3;
    private final String command;
    private final String[] args;

    public DefaultRemoteCommand(String command, String[] args) {
        this.command = command;
        this.args = args;
        if ("selectWindow".equals(command) && args[0] == null) {
            args[0] = "null";
        }
    }

    public String getCommandURLString() {
        StringBuffer sb = new StringBuffer("cmd=");
        sb.append(Urls.urlEncode((String)this.command));
        if (this.args == null) {
            return sb.toString();
        }
        for (int i = 0; i < this.args.length; ++i) {
            sb.append('&');
            sb.append(Integer.toString(i + 1));
            sb.append('=');
            sb.append(Urls.urlEncode((String)this.args[i]));
        }
        return sb.toString();
    }

    public String toString() {
        return this.getCommandURLString();
    }

    public static RemoteCommand parse(String inputLine) {
        if (null == inputLine) {
            throw new NullPointerException("inputLine can't be null");
        }
        String[] values = inputLine.split("\\|");
        if (values.length != 4) {
            throw new IllegalStateException("Cannot parse invalid line: " + inputLine + values.length);
        }
        return new DefaultRemoteCommand(values[1], new String[]{values[2], values[3]});
    }
}

