/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.BiDiException;
import org.openqa.selenium.bidi.Connection;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.firefox.AddHasContext;
import org.openqa.selenium.firefox.AddHasExtensions;
import org.openqa.selenium.firefox.AddHasFullPageScreenshot;
import org.openqa.selenium.firefox.FirefoxCommandContext;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.HasContext;
import org.openqa.selenium.firefox.HasExtensions;
import org.openqa.selenium.firefox.HasFullPageScreenshot;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;

public class FirefoxDriver
extends RemoteWebDriver
implements HasExtensions,
HasFullPageScreenshot,
HasContext,
HasBiDi {
    private static final Logger LOG = Logger.getLogger(FirefoxDriver.class.getName());
    private final Capabilities capabilities;
    private final HasExtensions extensions = new AddHasExtensions().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasFullPageScreenshot fullPageScreenshot = new AddHasFullPageScreenshot().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasContext context = new AddHasContext().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final Optional<URI> biDiUri;
    private final Optional<BiDi> biDi;

    public FirefoxDriver() {
        this(new FirefoxOptions());
    }

    public FirefoxDriver(FirefoxOptions options) {
        this(options, ClientConfig.defaultConfig());
    }

    public FirefoxDriver(FirefoxOptions options, ClientConfig clientConfig) {
        this(GeckoDriverService.createDefaultService(), options, clientConfig);
    }

    public FirefoxDriver(FirefoxDriverService service) {
        this(service, new FirefoxOptions());
    }

    public FirefoxDriver(FirefoxDriverService service, FirefoxOptions options) {
        this(service, options, ClientConfig.defaultConfig());
    }

    public FirefoxDriver(FirefoxDriverService service, FirefoxOptions options, ClientConfig clientConfig) {
        this(FirefoxDriver.generateExecutor(service, options, clientConfig), options, clientConfig);
    }

    private static FirefoxDriverCommandExecutor generateExecutor(FirefoxDriverService service, FirefoxOptions options, ClientConfig clientConfig) {
        Require.nonNull((String)"Driver service", (Object)((Object)service));
        Require.nonNull((String)"Driver options", (Object)((Object)options));
        Require.nonNull((String)"Driver clientConfig", (Object)clientConfig);
        DriverFinder finder = new DriverFinder((DriverService)service, (Capabilities)options);
        service.setExecutable(finder.getDriverPath());
        if (finder.hasBrowserPath()) {
            options.setBinary(finder.getBrowserPath());
            options.setCapability("browserVersion", null);
        }
        return new FirefoxDriverCommandExecutor(service, clientConfig);
    }

    private FirefoxDriver(FirefoxDriverCommandExecutor executor, FirefoxOptions options, ClientConfig clientConfig) {
        super((CommandExecutor)executor, FirefoxDriver.checkCapabilitiesAndProxy((Capabilities)options), clientConfig);
        Capabilities capabilities = super.getCapabilities();
        Optional<String> webSocketUrl = Optional.ofNullable((String)capabilities.getCapability("webSocketUrl"));
        this.biDiUri = webSocketUrl.map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                LOG.warning(e.getMessage());
                return null;
            }
        });
        this.biDi = this.createBiDi(clientConfig, this.biDiUri);
        this.capabilities = new ImmutableCapabilities(capabilities);
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return RemoteWebDriver.builder().oneOf((Capabilities)new FirefoxOptions(), new Capabilities[0]);
    }

    private static Capabilities checkCapabilitiesAndProxy(Capabilities capabilities) {
        if (capabilities == null) {
            return new ImmutableCapabilities();
        }
        MutableCapabilities caps = new MutableCapabilities(capabilities);
        Proxy proxy = Proxy.extractFrom((Capabilities)capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", (Object)proxy);
        }
        return caps;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    @Override
    public String installExtension(Path path) {
        Require.nonNull((String)"Path", (Object)path);
        return this.extensions.installExtension(path);
    }

    @Override
    public String installExtension(Path path, Boolean temporary) {
        Require.nonNull((String)"Path", (Object)path);
        Require.nonNull((String)"Temporary", (Object)temporary);
        return this.extensions.installExtension(path, temporary);
    }

    @Override
    public void uninstallExtension(String extensionId) {
        Require.nonNull((String)"Extension ID", (Object)extensionId);
        this.extensions.uninstallExtension(extensionId);
    }

    @Override
    public <X> X getFullPageScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        Require.nonNull((String)"OutputType", outputType);
        return this.fullPageScreenshot.getFullPageScreenshotAs(outputType);
    }

    @Override
    public FirefoxCommandContext getContext() {
        return this.context.getContext();
    }

    @Override
    public void setContext(FirefoxCommandContext commandContext) {
        Require.nonNull((String)"Firefox Command Context", (Object)((Object)commandContext));
        this.context.setContext(commandContext);
    }

    private Optional<BiDi> createBiDi(ClientConfig clientConfig, Optional<URI> biDiUri) {
        return biDiUri.map(wsUri -> {
            HttpClient.Factory clientFactory = HttpClient.Factory.createDefault();
            ClientConfig wsConfig = clientConfig.baseUri(wsUri);
            HttpClient wsClient = clientFactory.createClient(wsConfig);
            Connection biDiConnection = new Connection(wsClient, wsUri.toString());
            return new BiDi(biDiConnection, wsConfig.wsTimeout());
        });
    }

    public Optional<BiDi> maybeGetBiDi() {
        return this.biDi;
    }

    public BiDi getBiDi() {
        if (this.biDiUri.isEmpty()) {
            throw new BiDiException("Check if this browser version supports BiDi and if the 'webSocketUrl: true' capability is set.");
        }
        return this.maybeGetBiDi().orElseThrow(() -> new BiDiException("Unable to initialize Bidi connection"));
    }

    public void quit() {
        super.quit();
    }

    private static class FirefoxDriverCommandExecutor
    extends DriverCommandExecutor {
        @Deprecated
        public FirefoxDriverCommandExecutor(DriverService service) {
            this(service, ClientConfig.defaultConfig());
        }

        public FirefoxDriverCommandExecutor(DriverService service, ClientConfig clientConfig) {
            super(service, FirefoxDriverCommandExecutor.getExtraCommands(), clientConfig);
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return Stream.of(new AddHasContext().getAdditionalCommands(), new AddHasExtensions().getAdditionalCommands(), new AddHasFullPageScreenshot().getAdditionalCommands()).flatMap(m -> m.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public static final class SystemProperty {
        public static final String BROWSER_BINARY = "webdriver.firefox.bin";
        public static final String BROWSER_PROFILE = "webdriver.firefox.profile";
    }
}

