/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.debugger;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v144.debugger.model.BreakLocation;
import org.openqa.selenium.devtools.v144.debugger.model.BreakpointId;
import org.openqa.selenium.devtools.v144.debugger.model.BreakpointResolved;
import org.openqa.selenium.devtools.v144.debugger.model.CallFrame;
import org.openqa.selenium.devtools.v144.debugger.model.CallFrameId;
import org.openqa.selenium.devtools.v144.debugger.model.Location;
import org.openqa.selenium.devtools.v144.debugger.model.LocationRange;
import org.openqa.selenium.devtools.v144.debugger.model.Paused;
import org.openqa.selenium.devtools.v144.debugger.model.ScriptFailedToParse;
import org.openqa.selenium.devtools.v144.debugger.model.ScriptParsed;
import org.openqa.selenium.devtools.v144.debugger.model.ScriptPosition;
import org.openqa.selenium.devtools.v144.debugger.model.SearchMatch;
import org.openqa.selenium.devtools.v144.debugger.model.WasmDisassemblyChunk;
import org.openqa.selenium.devtools.v144.runtime.model.CallArgument;
import org.openqa.selenium.devtools.v144.runtime.model.ExceptionDetails;
import org.openqa.selenium.devtools.v144.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v144.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.v144.runtime.model.ScriptId;
import org.openqa.selenium.devtools.v144.runtime.model.StackTrace;
import org.openqa.selenium.devtools.v144.runtime.model.StackTraceId;
import org.openqa.selenium.devtools.v144.runtime.model.TimeDelta;
import org.openqa.selenium.devtools.v144.runtime.model.UniqueDebuggerId;
import org.openqa.selenium.json.JsonInput;

public class Debugger {
    public static Command<Void> continueToLocation(Location location, Optional<ContinueToLocationTargetCallFrames> targetCallFrames) {
        Objects.requireNonNull(location, "location is required");
        LinkedHashMap<String, Location> params = new LinkedHashMap<String, Location>();
        params.put("location", location);
        targetCallFrames.ifPresent(p -> params.put("targetCallFrames", (Location)p));
        return new Command("Debugger.continueToLocation", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Debugger.disable", Map.copyOf(params));
    }

    public static Command<UniqueDebuggerId> enable(Optional<Number> maxScriptsCacheSize) {
        LinkedHashMap params = new LinkedHashMap();
        maxScriptsCacheSize.ifPresent(p -> params.put("maxScriptsCacheSize", p));
        return new Command("Debugger.enable", Map.copyOf(params), ConverterFunctions.map((String)"debuggerId", UniqueDebuggerId.class));
    }

    public static Command<EvaluateOnCallFrameResponse> evaluateOnCallFrame(CallFrameId callFrameId, String expression, Optional<String> objectGroup, Optional<Boolean> includeCommandLineAPI, Optional<Boolean> silent, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> throwOnSideEffect, Optional<TimeDelta> timeout) {
        Objects.requireNonNull(callFrameId, "callFrameId is required");
        Objects.requireNonNull(expression, "expression is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("callFrameId", callFrameId);
        params.put("expression", expression);
        objectGroup.ifPresent(p -> params.put("objectGroup", p));
        includeCommandLineAPI.ifPresent(p -> params.put("includeCommandLineAPI", p));
        silent.ifPresent(p -> params.put("silent", p));
        returnByValue.ifPresent(p -> params.put("returnByValue", p));
        generatePreview.ifPresent(p -> params.put("generatePreview", p));
        throwOnSideEffect.ifPresent(p -> params.put("throwOnSideEffect", p));
        timeout.ifPresent(p -> params.put("timeout", p));
        return new Command("Debugger.evaluateOnCallFrame", Map.copyOf(params), input -> (EvaluateOnCallFrameResponse)input.read(EvaluateOnCallFrameResponse.class));
    }

    public static Command<List<BreakLocation>> getPossibleBreakpoints(Location start, Optional<Location> end, Optional<Boolean> restrictToFunction) {
        Objects.requireNonNull(start, "start is required");
        LinkedHashMap<String, Location> params = new LinkedHashMap<String, Location>();
        params.put("start", start);
        end.ifPresent(p -> params.put("end", (Location)p));
        restrictToFunction.ifPresent(p -> params.put("restrictToFunction", (Location)p));
        return new Command("Debugger.getPossibleBreakpoints", Map.copyOf(params), ConverterFunctions.map((String)"locations", input -> input.readArray(BreakLocation.class)));
    }

    public static Command<GetScriptSourceResponse> getScriptSource(ScriptId scriptId) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        LinkedHashMap<String, ScriptId> params = new LinkedHashMap<String, ScriptId>();
        params.put("scriptId", scriptId);
        return new Command("Debugger.getScriptSource", Map.copyOf(params), input -> (GetScriptSourceResponse)input.read(GetScriptSourceResponse.class));
    }

    @Beta
    public static Command<DisassembleWasmModuleResponse> disassembleWasmModule(ScriptId scriptId) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        LinkedHashMap<String, ScriptId> params = new LinkedHashMap<String, ScriptId>();
        params.put("scriptId", scriptId);
        return new Command("Debugger.disassembleWasmModule", Map.copyOf(params), input -> (DisassembleWasmModuleResponse)input.read(DisassembleWasmModuleResponse.class));
    }

    @Beta
    public static Command<WasmDisassemblyChunk> nextWasmDisassemblyChunk(String streamId) {
        Objects.requireNonNull(streamId, "streamId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("streamId", streamId);
        return new Command("Debugger.nextWasmDisassemblyChunk", Map.copyOf(params), ConverterFunctions.map((String)"chunk", WasmDisassemblyChunk.class));
    }

    @Deprecated
    public static Command<String> getWasmBytecode(ScriptId scriptId) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        LinkedHashMap<String, ScriptId> params = new LinkedHashMap<String, ScriptId>();
        params.put("scriptId", scriptId);
        return new Command("Debugger.getWasmBytecode", Map.copyOf(params), ConverterFunctions.map((String)"bytecode", String.class));
    }

    @Beta
    public static Command<StackTrace> getStackTrace(StackTraceId stackTraceId) {
        Objects.requireNonNull(stackTraceId, "stackTraceId is required");
        LinkedHashMap<String, StackTraceId> params = new LinkedHashMap<String, StackTraceId>();
        params.put("stackTraceId", stackTraceId);
        return new Command("Debugger.getStackTrace", Map.copyOf(params), ConverterFunctions.map((String)"stackTrace", StackTrace.class));
    }

    public static Command<Void> pause() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Debugger.pause", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> pauseOnAsyncCall(StackTraceId parentStackTraceId) {
        Objects.requireNonNull(parentStackTraceId, "parentStackTraceId is required");
        LinkedHashMap<String, StackTraceId> params = new LinkedHashMap<String, StackTraceId>();
        params.put("parentStackTraceId", parentStackTraceId);
        return new Command("Debugger.pauseOnAsyncCall", Map.copyOf(params));
    }

    public static Command<Void> removeBreakpoint(BreakpointId breakpointId) {
        Objects.requireNonNull(breakpointId, "breakpointId is required");
        LinkedHashMap<String, BreakpointId> params = new LinkedHashMap<String, BreakpointId>();
        params.put("breakpointId", breakpointId);
        return new Command("Debugger.removeBreakpoint", Map.copyOf(params));
    }

    public static Command<RestartFrameResponse> restartFrame(CallFrameId callFrameId, Optional<RestartFrameMode> mode) {
        Objects.requireNonNull(callFrameId, "callFrameId is required");
        LinkedHashMap<String, CallFrameId> params = new LinkedHashMap<String, CallFrameId>();
        params.put("callFrameId", callFrameId);
        mode.ifPresent(p -> params.put("mode", (CallFrameId)p));
        return new Command("Debugger.restartFrame", Map.copyOf(params), input -> (RestartFrameResponse)input.read(RestartFrameResponse.class));
    }

    public static Command<Void> resume(Optional<Boolean> terminateOnResume) {
        LinkedHashMap params = new LinkedHashMap();
        terminateOnResume.ifPresent(p -> params.put("terminateOnResume", p));
        return new Command("Debugger.resume", Map.copyOf(params));
    }

    public static Command<List<SearchMatch>> searchInContent(ScriptId scriptId, String query, Optional<Boolean> caseSensitive, Optional<Boolean> isRegex) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        Objects.requireNonNull(query, "query is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("scriptId", scriptId);
        params.put("query", query);
        caseSensitive.ifPresent(p -> params.put("caseSensitive", p));
        isRegex.ifPresent(p -> params.put("isRegex", p));
        return new Command("Debugger.searchInContent", Map.copyOf(params), ConverterFunctions.map((String)"result", input -> input.readArray(SearchMatch.class)));
    }

    public static Command<Void> setAsyncCallStackDepth(Integer maxDepth) {
        Objects.requireNonNull(maxDepth, "maxDepth is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("maxDepth", maxDepth);
        return new Command("Debugger.setAsyncCallStackDepth", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setBlackboxExecutionContexts(List<String> uniqueIds) {
        Objects.requireNonNull(uniqueIds, "uniqueIds is required");
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("uniqueIds", uniqueIds);
        return new Command("Debugger.setBlackboxExecutionContexts", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setBlackboxPatterns(List<String> patterns, Optional<Boolean> skipAnonymous) {
        Objects.requireNonNull(patterns, "patterns is required");
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("patterns", patterns);
        skipAnonymous.ifPresent(p -> params.put("skipAnonymous", (List<String>)p));
        return new Command("Debugger.setBlackboxPatterns", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setBlackboxedRanges(ScriptId scriptId, List<ScriptPosition> positions) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        Objects.requireNonNull(positions, "positions is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("scriptId", scriptId);
        params.put("positions", positions);
        return new Command("Debugger.setBlackboxedRanges", Map.copyOf(params));
    }

    public static Command<SetBreakpointResponse> setBreakpoint(Location location, Optional<String> condition) {
        Objects.requireNonNull(location, "location is required");
        LinkedHashMap<String, Location> params = new LinkedHashMap<String, Location>();
        params.put("location", location);
        condition.ifPresent(p -> params.put("condition", (Location)p));
        return new Command("Debugger.setBreakpoint", Map.copyOf(params), input -> (SetBreakpointResponse)input.read(SetBreakpointResponse.class));
    }

    public static Command<BreakpointId> setInstrumentationBreakpoint(SetInstrumentationBreakpointInstrumentation instrumentation) {
        Objects.requireNonNull(instrumentation, "instrumentation is required");
        LinkedHashMap<String, SetInstrumentationBreakpointInstrumentation> params = new LinkedHashMap<String, SetInstrumentationBreakpointInstrumentation>();
        params.put("instrumentation", instrumentation);
        return new Command("Debugger.setInstrumentationBreakpoint", Map.copyOf(params), ConverterFunctions.map((String)"breakpointId", BreakpointId.class));
    }

    public static Command<SetBreakpointByUrlResponse> setBreakpointByUrl(Integer lineNumber, Optional<String> url, Optional<String> urlRegex, Optional<String> scriptHash, Optional<Integer> columnNumber, Optional<String> condition) {
        Objects.requireNonNull(lineNumber, "lineNumber is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("lineNumber", lineNumber);
        url.ifPresent(p -> params.put("url", (Integer)p));
        urlRegex.ifPresent(p -> params.put("urlRegex", (Integer)p));
        scriptHash.ifPresent(p -> params.put("scriptHash", (Integer)p));
        columnNumber.ifPresent(p -> params.put("columnNumber", (Integer)p));
        condition.ifPresent(p -> params.put("condition", (Integer)p));
        return new Command("Debugger.setBreakpointByUrl", Map.copyOf(params), input -> (SetBreakpointByUrlResponse)input.read(SetBreakpointByUrlResponse.class));
    }

    @Beta
    public static Command<BreakpointId> setBreakpointOnFunctionCall(RemoteObjectId objectId, Optional<String> condition) {
        Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, RemoteObjectId> params = new LinkedHashMap<String, RemoteObjectId>();
        params.put("objectId", objectId);
        condition.ifPresent(p -> params.put("condition", (RemoteObjectId)p));
        return new Command("Debugger.setBreakpointOnFunctionCall", Map.copyOf(params), ConverterFunctions.map((String)"breakpointId", BreakpointId.class));
    }

    public static Command<Void> setBreakpointsActive(Boolean active) {
        Objects.requireNonNull(active, "active is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("active", active);
        return new Command("Debugger.setBreakpointsActive", Map.copyOf(params));
    }

    public static Command<Void> setPauseOnExceptions(SetPauseOnExceptionsState state) {
        Objects.requireNonNull(state, "state is required");
        LinkedHashMap<String, SetPauseOnExceptionsState> params = new LinkedHashMap<String, SetPauseOnExceptionsState>();
        params.put("state", state);
        return new Command("Debugger.setPauseOnExceptions", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setReturnValue(CallArgument newValue) {
        Objects.requireNonNull(newValue, "newValue is required");
        LinkedHashMap<String, CallArgument> params = new LinkedHashMap<String, CallArgument>();
        params.put("newValue", newValue);
        return new Command("Debugger.setReturnValue", Map.copyOf(params));
    }

    public static Command<SetScriptSourceResponse> setScriptSource(ScriptId scriptId, String scriptSource, Optional<Boolean> dryRun, Optional<Boolean> allowTopFrameEditing) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        Objects.requireNonNull(scriptSource, "scriptSource is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("scriptId", scriptId);
        params.put("scriptSource", scriptSource);
        dryRun.ifPresent(p -> params.put("dryRun", p));
        allowTopFrameEditing.ifPresent(p -> params.put("allowTopFrameEditing", p));
        return new Command("Debugger.setScriptSource", Map.copyOf(params), input -> (SetScriptSourceResponse)input.read(SetScriptSourceResponse.class));
    }

    public static Command<Void> setSkipAllPauses(Boolean skip) {
        Objects.requireNonNull(skip, "skip is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("skip", skip);
        return new Command("Debugger.setSkipAllPauses", Map.copyOf(params));
    }

    public static Command<Void> setVariableValue(Integer scopeNumber, String variableName, CallArgument newValue, CallFrameId callFrameId) {
        Objects.requireNonNull(scopeNumber, "scopeNumber is required");
        Objects.requireNonNull(variableName, "variableName is required");
        Objects.requireNonNull(newValue, "newValue is required");
        Objects.requireNonNull(callFrameId, "callFrameId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("scopeNumber", scopeNumber);
        params.put("variableName", variableName);
        params.put("newValue", newValue);
        params.put("callFrameId", callFrameId);
        return new Command("Debugger.setVariableValue", Map.copyOf(params));
    }

    public static Command<Void> stepInto(Optional<Boolean> breakOnAsyncCall, Optional<List<LocationRange>> skipList) {
        LinkedHashMap params = new LinkedHashMap();
        breakOnAsyncCall.ifPresent(p -> params.put("breakOnAsyncCall", p));
        skipList.ifPresent(p -> params.put("skipList", p));
        return new Command("Debugger.stepInto", Map.copyOf(params));
    }

    public static Command<Void> stepOut() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Debugger.stepOut", Map.copyOf(params));
    }

    public static Command<Void> stepOver(Optional<List<LocationRange>> skipList) {
        LinkedHashMap params = new LinkedHashMap();
        skipList.ifPresent(p -> params.put("skipList", p));
        return new Command("Debugger.stepOver", Map.copyOf(params));
    }

    public static Event<BreakpointResolved> breakpointResolved() {
        return new Event("Debugger.breakpointResolved", input -> (BreakpointResolved)input.read(BreakpointResolved.class));
    }

    public static Event<Paused> paused() {
        return new Event("Debugger.paused", input -> (Paused)input.read(Paused.class));
    }

    public static Event<Void> resumed() {
        return new Event("Debugger.resumed", ConverterFunctions.empty());
    }

    public static Event<ScriptFailedToParse> scriptFailedToParse() {
        return new Event("Debugger.scriptFailedToParse", input -> (ScriptFailedToParse)input.read(ScriptFailedToParse.class));
    }

    public static Event<ScriptParsed> scriptParsed() {
        return new Event("Debugger.scriptParsed", input -> (ScriptParsed)input.read(ScriptParsed.class));
    }

    public static class SetScriptSourceResponse {
        private final Optional<List<CallFrame>> callFrames;
        private final Optional<Boolean> stackChanged;
        private final Optional<StackTrace> asyncStackTrace;
        private final Optional<StackTraceId> asyncStackTraceId;
        private final Status status;
        private final Optional<ExceptionDetails> exceptionDetails;

        public SetScriptSourceResponse(Optional<List<CallFrame>> callFrames, Optional<Boolean> stackChanged, Optional<StackTrace> asyncStackTrace, Optional<StackTraceId> asyncStackTraceId, Status status, Optional<ExceptionDetails> exceptionDetails) {
            this.callFrames = callFrames;
            this.stackChanged = stackChanged;
            this.asyncStackTrace = asyncStackTrace;
            this.asyncStackTraceId = asyncStackTraceId;
            this.status = Objects.requireNonNull(status, "status is required");
            this.exceptionDetails = exceptionDetails;
        }

        public Optional<List<CallFrame>> getCallFrames() {
            return this.callFrames;
        }

        public Optional<Boolean> getStackChanged() {
            return this.stackChanged;
        }

        public Optional<StackTrace> getAsyncStackTrace() {
            return this.asyncStackTrace;
        }

        public Optional<StackTraceId> getAsyncStackTraceId() {
            return this.asyncStackTraceId;
        }

        public Status getStatus() {
            return this.status;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static SetScriptSourceResponse fromJson(JsonInput input) {
            Optional<List<CallFrame>> callFrames = Optional.empty();
            Optional<Boolean> stackChanged = Optional.empty();
            Optional<StackTrace> asyncStackTrace = Optional.empty();
            Optional<StackTraceId> asyncStackTraceId = Optional.empty();
            Status status = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block16: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "callFrames": {
                        callFrames = Optional.ofNullable(input.readArray(CallFrame.class));
                        continue block16;
                    }
                    case "stackChanged": {
                        stackChanged = Optional.ofNullable(input.nextBoolean());
                        continue block16;
                    }
                    case "asyncStackTrace": {
                        asyncStackTrace = Optional.ofNullable((StackTrace)input.read(StackTrace.class));
                        continue block16;
                    }
                    case "asyncStackTraceId": {
                        asyncStackTraceId = Optional.ofNullable((StackTraceId)input.read(StackTraceId.class));
                        continue block16;
                    }
                    case "status": {
                        status = Status.fromString(input.nextString());
                        continue block16;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block16;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new SetScriptSourceResponse(callFrames, stackChanged, asyncStackTrace, asyncStackTraceId, status, exceptionDetails);
        }

        public static enum Status {
            OK("Ok"),
            COMPILEERROR("CompileError"),
            BLOCKEDBYACTIVEGENERATOR("BlockedByActiveGenerator"),
            BLOCKEDBYACTIVEFUNCTION("BlockedByActiveFunction"),
            BLOCKEDBYTOPLEVELESMODULECHANGE("BlockedByTopLevelEsModuleChange");

            private String value;

            private Status(String value) {
                this.value = value;
            }

            public static Status fromString(String s) {
                return Arrays.stream(Status.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Status "));
            }

            public String toString() {
                return this.value;
            }

            public String toJson() {
                return this.value;
            }

            private static Status fromJson(JsonInput input) {
                return Status.fromString(input.nextString());
            }
        }
    }

    public static class SetBreakpointByUrlResponse {
        private final BreakpointId breakpointId;
        private final List<Location> locations;

        public SetBreakpointByUrlResponse(BreakpointId breakpointId, List<Location> locations) {
            this.breakpointId = Objects.requireNonNull(breakpointId, "breakpointId is required");
            this.locations = Objects.requireNonNull(locations, "locations is required");
        }

        public BreakpointId getBreakpointId() {
            return this.breakpointId;
        }

        public List<Location> getLocations() {
            return this.locations;
        }

        private static SetBreakpointByUrlResponse fromJson(JsonInput input) {
            BreakpointId breakpointId = null;
            List locations = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "breakpointId": {
                        breakpointId = (BreakpointId)input.read(BreakpointId.class);
                        continue block8;
                    }
                    case "locations": {
                        locations = input.readArray(Location.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new SetBreakpointByUrlResponse(breakpointId, locations);
        }
    }

    public static class SetBreakpointResponse {
        private final BreakpointId breakpointId;
        private final Location actualLocation;

        public SetBreakpointResponse(BreakpointId breakpointId, Location actualLocation) {
            this.breakpointId = Objects.requireNonNull(breakpointId, "breakpointId is required");
            this.actualLocation = Objects.requireNonNull(actualLocation, "actualLocation is required");
        }

        public BreakpointId getBreakpointId() {
            return this.breakpointId;
        }

        public Location getActualLocation() {
            return this.actualLocation;
        }

        private static SetBreakpointResponse fromJson(JsonInput input) {
            BreakpointId breakpointId = null;
            Location actualLocation = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "breakpointId": {
                        breakpointId = (BreakpointId)input.read(BreakpointId.class);
                        continue block8;
                    }
                    case "actualLocation": {
                        actualLocation = (Location)input.read(Location.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new SetBreakpointResponse(breakpointId, actualLocation);
        }
    }

    public static class RestartFrameResponse {
        private final List<CallFrame> callFrames;
        private final Optional<StackTrace> asyncStackTrace;
        private final Optional<StackTraceId> asyncStackTraceId;

        public RestartFrameResponse(List<CallFrame> callFrames, Optional<StackTrace> asyncStackTrace, Optional<StackTraceId> asyncStackTraceId) {
            this.callFrames = Objects.requireNonNull(callFrames, "callFrames is required");
            this.asyncStackTrace = asyncStackTrace;
            this.asyncStackTraceId = asyncStackTraceId;
        }

        public List<CallFrame> getCallFrames() {
            return this.callFrames;
        }

        public Optional<StackTrace> getAsyncStackTrace() {
            return this.asyncStackTrace;
        }

        public Optional<StackTraceId> getAsyncStackTraceId() {
            return this.asyncStackTraceId;
        }

        private static RestartFrameResponse fromJson(JsonInput input) {
            List callFrames = null;
            Optional<StackTrace> asyncStackTrace = Optional.empty();
            Optional<StackTraceId> asyncStackTraceId = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "callFrames": {
                        callFrames = input.readArray(CallFrame.class);
                        continue block10;
                    }
                    case "asyncStackTrace": {
                        asyncStackTrace = Optional.ofNullable((StackTrace)input.read(StackTrace.class));
                        continue block10;
                    }
                    case "asyncStackTraceId": {
                        asyncStackTraceId = Optional.ofNullable((StackTraceId)input.read(StackTraceId.class));
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RestartFrameResponse(callFrames, asyncStackTrace, asyncStackTraceId);
        }
    }

    public static class DisassembleWasmModuleResponse {
        private final Optional<String> streamId;
        private final Integer totalNumberOfLines;
        private final List<Integer> functionBodyOffsets;
        private final WasmDisassemblyChunk chunk;

        public DisassembleWasmModuleResponse(Optional<String> streamId, Integer totalNumberOfLines, List<Integer> functionBodyOffsets, WasmDisassemblyChunk chunk) {
            this.streamId = streamId;
            this.totalNumberOfLines = Objects.requireNonNull(totalNumberOfLines, "totalNumberOfLines is required");
            this.functionBodyOffsets = Objects.requireNonNull(functionBodyOffsets, "functionBodyOffsets is required");
            this.chunk = Objects.requireNonNull(chunk, "chunk is required");
        }

        public Optional<String> getStreamId() {
            return this.streamId;
        }

        public Integer getTotalNumberOfLines() {
            return this.totalNumberOfLines;
        }

        public List<Integer> getFunctionBodyOffsets() {
            return this.functionBodyOffsets;
        }

        public WasmDisassemblyChunk getChunk() {
            return this.chunk;
        }

        private static DisassembleWasmModuleResponse fromJson(JsonInput input) {
            Optional<String> streamId = Optional.empty();
            Integer totalNumberOfLines = 0;
            List functionBodyOffsets = null;
            WasmDisassemblyChunk chunk = null;
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "streamId": {
                        streamId = Optional.ofNullable(input.nextString());
                        continue block12;
                    }
                    case "totalNumberOfLines": {
                        totalNumberOfLines = input.nextNumber().intValue();
                        continue block12;
                    }
                    case "functionBodyOffsets": {
                        functionBodyOffsets = input.readArray(Integer.class);
                        continue block12;
                    }
                    case "chunk": {
                        chunk = (WasmDisassemblyChunk)input.read(WasmDisassemblyChunk.class);
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new DisassembleWasmModuleResponse(streamId, totalNumberOfLines, functionBodyOffsets, chunk);
        }
    }

    public static class GetScriptSourceResponse {
        private final String scriptSource;
        private final Optional<String> bytecode;

        public GetScriptSourceResponse(String scriptSource, Optional<String> bytecode) {
            this.scriptSource = Objects.requireNonNull(scriptSource, "scriptSource is required");
            this.bytecode = bytecode;
        }

        public String getScriptSource() {
            return this.scriptSource;
        }

        public Optional<String> getBytecode() {
            return this.bytecode;
        }

        private static GetScriptSourceResponse fromJson(JsonInput input) {
            String scriptSource = null;
            Optional<String> bytecode = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "scriptSource": {
                        scriptSource = input.nextString();
                        continue block8;
                    }
                    case "bytecode": {
                        bytecode = Optional.ofNullable(input.nextString());
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetScriptSourceResponse(scriptSource, bytecode);
        }
    }

    public static class EvaluateOnCallFrameResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public EvaluateOnCallFrameResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static EvaluateOnCallFrameResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new EvaluateOnCallFrameResponse(result, exceptionDetails);
        }
    }

    public static enum SetPauseOnExceptionsState {
        NONE("none"),
        CAUGHT("caught"),
        UNCAUGHT("uncaught"),
        ALL("all");

        private String value;

        private SetPauseOnExceptionsState(String value) {
            this.value = value;
        }

        public static SetPauseOnExceptionsState fromString(String s) {
            return Arrays.stream(SetPauseOnExceptionsState.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetPauseOnExceptionsState "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetPauseOnExceptionsState fromJson(JsonInput input) {
            return SetPauseOnExceptionsState.fromString(input.nextString());
        }
    }

    public static enum SetInstrumentationBreakpointInstrumentation {
        BEFORESCRIPTEXECUTION("beforeScriptExecution"),
        BEFORESCRIPTWITHSOURCEMAPEXECUTION("beforeScriptWithSourceMapExecution");

        private String value;

        private SetInstrumentationBreakpointInstrumentation(String value) {
            this.value = value;
        }

        public static SetInstrumentationBreakpointInstrumentation fromString(String s) {
            return Arrays.stream(SetInstrumentationBreakpointInstrumentation.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetInstrumentationBreakpointInstrumentation "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetInstrumentationBreakpointInstrumentation fromJson(JsonInput input) {
            return SetInstrumentationBreakpointInstrumentation.fromString(input.nextString());
        }
    }

    public static enum RestartFrameMode {
        STEPINTO("StepInto");

        private String value;

        private RestartFrameMode(String value) {
            this.value = value;
        }

        public static RestartFrameMode fromString(String s) {
            return Arrays.stream(RestartFrameMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within RestartFrameMode "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static RestartFrameMode fromJson(JsonInput input) {
            return RestartFrameMode.fromString(input.nextString());
        }
    }

    public static enum ContinueToLocationTargetCallFrames {
        ANY("any"),
        CURRENT("current");

        private String value;

        private ContinueToLocationTargetCallFrames(String value) {
            this.value = value;
        }

        public static ContinueToLocationTargetCallFrames fromString(String s) {
            return Arrays.stream(ContinueToLocationTargetCallFrames.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ContinueToLocationTargetCallFrames "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static ContinueToLocationTargetCallFrames fromJson(JsonInput input) {
            return ContinueToLocationTargetCallFrames.fromString(input.nextString());
        }
    }
}

