/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets.html;

import java.io.Serializable;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.richfaces.cdk.annotations.Event;
import org.richfaces.cdk.annotations.Tag;
import org.richfaces.cdk.annotations.TagType;
import org.richfaces.view.facelets.html.TagHandlerUtils;

@Event(listener=ActionListener.class, source="org.richfaces.event.DummyActionListenerSource", tag={@Tag(name="actionListener", handler="org.richfaces.view.facelets.html.ActionListenerHandler", generate=false, type=TagType.Facelets)})
class LazyActionListener
implements ActionListener,
Serializable {
    private static final long serialVersionUID = 6303879250524609909L;
    private final String type;
    private final ValueExpression binding;

    public LazyActionListener(String type, ValueExpression binding) {
        this.type = type;
        this.binding = binding;
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        ActionListener instance = null;
        FacesContext faces = FacesContext.getCurrentInstance();
        if (faces == null) {
            return;
        }
        if (this.binding != null) {
            instance = (ActionListener)this.binding.getValue(faces.getELContext());
        }
        if (instance == null && this.type != null) {
            try {
                instance = TagHandlerUtils.loadClass(this.type, ActionListener.class).newInstance();
            }
            catch (Exception e) {
                throw new AbortProcessingException("Couldn't lazily instantiate ActionListener", (Throwable)e);
            }
            if (this.binding != null) {
                this.binding.setValue(faces.getELContext(), (Object)instance);
            }
        }
        if (instance != null) {
            instance.processAction(event);
        }
    }
}

