/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.ecosystem;

import io.github.jeremylong.openvulnerability.client.nvd.Config;
import io.github.jeremylong.openvulnerability.client.nvd.CpeMatch;
import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import io.github.jeremylong.openvulnerability.client.nvd.Node;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.data.nvd.ecosystem.DescriptionEcosystemMapper;
import org.owasp.dependencycheck.data.nvd.ecosystem.UrlEcosystemMapper;

@NotThreadSafe
public class CveEcosystemMapper {
    private final DescriptionEcosystemMapper descriptionEcosystemMapper = new DescriptionEcosystemMapper();
    private final UrlEcosystemMapper urlEcosystemMapper = new UrlEcosystemMapper();

    public String getEcosystem(DefCveItem cve) {
        if (this.hasMultipleVendorProductConfigurations(cve)) {
            return null;
        }
        String ecosystem = this.descriptionEcosystemMapper.getEcosystem(cve);
        if (ecosystem != null) {
            return ecosystem;
        }
        return this.urlEcosystemMapper.getEcosystem(cve);
    }

    private boolean hasMultipleVendorProductConfigurations(DefCveItem cve) {
        List cpeEntries;
        if (cve.getCve().getConfigurations() != null && !cve.getCve().getConfigurations().isEmpty() && !(cpeEntries = cve.getCve().getConfigurations().stream().map(Config::getNodes).flatMap(Collection::stream).filter(cpe -> cpe.getCpeMatch() != null).map(Node::getCpeMatch).flatMap(Collection::stream).filter(match -> match.getCriteria() != null).collect(Collectors.toList())).isEmpty() && cpeEntries.size() > 1) {
            CpeMatch firstMatch = (CpeMatch)cpeEntries.get(0);
            String uri = firstMatch.getCriteria();
            int pos = uri.indexOf(":", uri.indexOf(":", 10) + 1);
            String match2 = uri.substring(0, pos + 1);
            return !cpeEntries.stream().allMatch(e -> e.getCriteria().startsWith(match2));
        }
        return false;
    }
}

