/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.rbc.client.intern;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import org.ops4j.pax.exam.ExceptionHelper;
import org.ops4j.pax.exam.RelativeTimeout;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.rbc.client.RemoteBundleContextClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryRemoteBundleContextClient
implements RemoteBundleContextClient {
    private static final Logger LOG = LoggerFactory.getLogger(RetryRemoteBundleContextClient.class);
    private static final int RETRY_WAIT = 500;
    private final RemoteBundleContextClient m_proxy;
    private final int m_maxRetry;

    public RetryRemoteBundleContextClient(final RemoteBundleContextClient client, int maxRetries) {
        this.m_maxRetry = maxRetries;
        this.m_proxy = (RemoteBundleContextClient)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{RemoteBundleContextClient.class}, new InvocationHandler(){

            public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                Object ret = null;
                Exception lastError = null;
                boolean retry = false;
                int triedTimes = 0;
                do {
                    try {
                        LOG.debug("Call RBC." + method.getName() + " (retries: " + triedTimes + ")");
                        ++triedTimes;
                        if (retry) {
                            Thread.sleep(500L);
                        }
                        ret = method.invoke((Object)client, objects);
                        retry = false;
                    }
                    catch (Exception ex) {
                        lastError = ex;
                        Throwable cause = ExceptionHelper.unwind((Throwable)ex);
                        boolean contain = ExceptionHelper.hasThrowable((Throwable)ex, NoSuchObjectException.class);
                        if (contain) {
                            LOG.warn("Catched (rooted) " + cause.getClass().getName() + " in RBC." + method.getName());
                            retry = true;
                            continue;
                        }
                        LOG.debug("Exception that does not cause Retry : (rooted) " + cause.getClass().getName() + " in RBC." + method.getName(), cause);
                        throw lastError;
                    }
                } while (retry && RetryRemoteBundleContextClient.this.m_maxRetry > triedTimes);
                if (retry && lastError != null) {
                    throw new Exception(lastError);
                }
                LOG.debug("Return RBC." + method.getName() + " with: " + ret);
                return ret;
            }
        });
    }

    public long install(String location, InputStream stream) {
        return this.m_proxy.install(location, stream);
    }

    public void cleanup() {
        this.m_proxy.cleanup();
    }

    public void setBundleStartLevel(long bundleId, int startLevel) {
        this.m_proxy.setBundleStartLevel(bundleId, startLevel);
    }

    public void start() {
        this.m_proxy.start();
    }

    public void stop() {
        this.m_proxy.stop();
    }

    public void waitForState(long bundleId, int state, RelativeTimeout timeout) {
        this.m_proxy.waitForState(bundleId, state, timeout);
    }

    public void call(TestAddress address) {
        this.m_proxy.call(address);
    }
}

