/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openscience.cdk.atomtype.EStateAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.AtomicProperties;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class ALOGPDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ALOGPDescriptor.class);
    IAtomContainer atomContainer;
    IRingSet rs;
    String[] fragment;
    AtomicProperties ap;
    public int[] frags = new int[121];
    public int[] alogpfrag;
    static final double[] FRAGVAL = new double[121];
    static final double[] REFRACVAL;
    String unassignedAtoms = "";
    double alogp = 0.0;
    double amr = 0.0;
    double alogp2 = 0.0;
    private static final String[] STRINGS;

    public ALOGPDescriptor() throws CDKException {
        try {
            this.ap = AtomicProperties.getInstance();
        }
        catch (Exception e) {
            logger.debug((Object)"Problem in accessing atomic properties. Can't calculate");
            throw new CDKException("Problem in accessing atomic properties. Can't calculate\n" + e.getMessage(), (Throwable)e);
        }
    }

    private void findUnassignedAtoms() {
        this.unassignedAtoms = "";
        for (int i = 0; i <= this.atomContainer.getAtomCount() - 1; ++i) {
            if (this.alogpfrag[i] != 0) continue;
            this.unassignedAtoms = this.unassignedAtoms + (i + 1) + "(" + this.fragment[i] + "),";
        }
    }

    private double[] calculate(IAtomContainer atomContainer, String[] fragment, IRingSet rs) throws CDKException {
        int i;
        this.atomContainer = atomContainer;
        this.fragment = fragment;
        this.rs = rs;
        this.alogp = 0.0;
        this.amr = 0.0;
        this.alogp2 = 0.0;
        this.alogpfrag = new int[atomContainer.getAtomCount()];
        for (i = 1; i <= 120; ++i) {
            this.frags[i] = 0;
        }
        for (i = 0; i < atomContainer.getAtomCount(); ++i) {
            try {
                if (fragment[i] == null) continue;
                this.calcGroup001_005(i);
                this.calcGroup002_006_007(i);
                this.calcGroup003_008_009_010(i);
                this.calcGroup004_011_to_014(i);
                this.calcGroup015(i);
                this.calcGroup016_018_036_037(i);
                this.calcGroup017_019_020_038_to_041(i);
                this.calcGroup021_to_023_040(i);
                this.calcGroup024_027_030_033_042(i);
                this.calcGroup025_026_028_029_031_032_034_035_043_044(i);
                this.calcGroup056_57(i);
                this.calcGroup058_61(i);
                this.calcGroup059_060_063(i);
                this.calcGroup066_to_079(i);
                this.calcGroup081_to_085(i);
                this.calcGroup086_to_090(i);
                this.calcGroup091_to_095(i);
                this.calcGroup096_to_100(i);
                this.calcGroup101_to_104(i);
                this.calcGroup106(i);
                this.calcGroup107(i);
                this.calcGroup108(i);
                this.calcGroup109(i);
                this.calcGroup110(i);
                this.calcGroup111(i);
                this.calcGroup112(i);
                this.calcGroup115(i);
                this.calcGroup116_117_120(i);
                this.calcGroup118_119(i);
                continue;
            }
            catch (Exception e) {
                throw new CDKException(e.toString(), (Throwable)e);
            }
        }
        logger.debug((Object)"\nFound fragments and frequencies ");
        for (i = 1; i <= 120; ++i) {
            this.alogp += FRAGVAL[i] * (double)this.frags[i];
            this.amr += REFRACVAL[i] * (double)this.frags[i];
            if (this.frags[i] <= 0) continue;
            logger.debug((Object)("frag " + i + "  --> " + this.frags[i]));
        }
        this.alogp2 = this.alogp * this.alogp;
        this.findUnassignedAtoms();
        return new double[]{this.alogp, this.alogp2, this.amr};
    }

    private static boolean isHetero(IAtom atom) {
        switch (atom.getAtomicNumber()) {
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 34: 
            case 35: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    private void calcGroup001_005(int i) {
        if (this.fragment[i].equals("SsCH3")) {
            int htype;
            List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
            IAtom atom = this.atomContainer.getAtom(i);
            int n = htype = this.getHAtomType(atom, ca);
            this.frags[n] = this.frags[n] + atom.getImplicitHydrogenCount();
            for (int j = 0; j < ca.size(); ++j) {
                if (((IAtom)ca.get(j)).getAtomicNumber() == 6) {
                    this.frags[1] = this.frags[1] + 1;
                    this.alogpfrag[i] = 1;
                    continue;
                }
                if (((IAtom)ca.get(j)).getAtomicNumber() == 1) {
                    int n2 = htype;
                    this.frags[n2] = this.frags[n2] + 1;
                    this.alogpfrag[this.atomContainer.indexOf((IAtom)((IAtom)ca.get((int)j)))] = htype;
                    continue;
                }
                this.frags[5] = this.frags[5] + 1;
                this.alogpfrag[i] = 5;
            }
        }
    }

    private void calcGroup002_006_007(int i) {
        if (this.fragment[i].equals("SssCH2")) {
            int htype;
            IAtom atom = this.atomContainer.getAtom(i);
            List nbors = this.atomContainer.getConnectedAtomsList(atom);
            int n = htype = this.getHAtomType(atom, nbors);
            this.frags[n] = this.frags[n] + atom.getImplicitHydrogenCount();
            int carbonCount = 0;
            int heteroCount = 0;
            for (int j = 0; j < nbors.size(); ++j) {
                if (((IAtom)nbors.get(j)).getAtomicNumber() == 6) {
                    ++carbonCount;
                    continue;
                }
                if (((IAtom)nbors.get(j)).getAtomicNumber() == 1) {
                    int n2 = htype;
                    this.frags[n2] = this.frags[n2] + 1;
                    this.alogpfrag[this.atomContainer.indexOf((IAtom)((IAtom)nbors.get((int)j)))] = htype;
                    continue;
                }
                ++heteroCount;
            }
            if (carbonCount == 2 && heteroCount == 0) {
                this.frags[2] = this.frags[2] + 1;
                this.alogpfrag[i] = 2;
            } else if (carbonCount == 1 && heteroCount == 1) {
                this.frags[6] = this.frags[6] + 1;
                this.alogpfrag[i] = 6;
            } else if (carbonCount == 0 && heteroCount == 2) {
                this.frags[7] = this.frags[7] + 1;
                this.alogpfrag[i] = 7;
            }
        }
    }

    private void calcGroup003_008_009_010(int i) {
        if (this.fragment[i].equals("SsssCH")) {
            int htype;
            IAtom atom = this.atomContainer.getAtom(i);
            List ca = this.atomContainer.getConnectedAtomsList(atom);
            int n = htype = this.getHAtomType(atom, ca);
            this.frags[n] = this.frags[n] + atom.getImplicitHydrogenCount();
            int carbonCount = 0;
            int heteroCount = 0;
            for (int j = 0; j <= ca.size() - 1; ++j) {
                if (((IAtom)ca.get(j)).getAtomicNumber() == 6) {
                    ++carbonCount;
                    continue;
                }
                if (((IAtom)ca.get(j)).getAtomicNumber() == 1) {
                    int n2 = htype;
                    this.frags[n2] = this.frags[n2] + 1;
                    this.alogpfrag[((IAtom)ca.get((int)j)).getIndex()] = htype;
                    continue;
                }
                ++heteroCount;
            }
            if (carbonCount == 3 && heteroCount == 0) {
                this.frags[3] = this.frags[3] + 1;
                this.alogpfrag[i] = 3;
            } else if (carbonCount == 2 && heteroCount == 1) {
                this.frags[8] = this.frags[8] + 1;
                this.alogpfrag[i] = 8;
            } else if (carbonCount == 1 && heteroCount == 2) {
                this.frags[9] = this.frags[9] + 1;
                this.alogpfrag[i] = 9;
            } else if (carbonCount == 0 && heteroCount == 3) {
                this.frags[10] = this.frags[10] + 1;
                this.alogpfrag[i] = 10;
            }
        }
    }

    private void calcGroup004_011_to_014(int i) {
        if (this.fragment[i].equals("SssssC")) {
            List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
            int carbonCount = 0;
            int heteroCount = 0;
            for (int j = 0; j <= ca.size() - 1; ++j) {
                if (((IAtom)ca.get(j)).getAtomicNumber() == 6) {
                    ++carbonCount;
                    continue;
                }
                ++heteroCount;
            }
            if (carbonCount == 4 && heteroCount == 0) {
                this.frags[4] = this.frags[4] + 1;
                this.alogpfrag[i] = 4;
            } else if (carbonCount == 3 && heteroCount == 1) {
                this.frags[11] = this.frags[11] + 1;
                this.alogpfrag[i] = 11;
            } else if (carbonCount == 2 && heteroCount == 2) {
                this.frags[12] = this.frags[12] + 1;
                this.alogpfrag[i] = 12;
            } else if (carbonCount == 1 && heteroCount == 3) {
                this.frags[13] = this.frags[13] + 1;
                this.alogpfrag[i] = 13;
            } else if (carbonCount == 0 && heteroCount == 4) {
                this.frags[14] = this.frags[14] + 1;
                this.alogpfrag[i] = 14;
            }
        }
    }

    private void calcGroup015(int i) {
        if (this.fragment[i].equals("SdCH2")) {
            int htype;
            this.frags[15] = this.frags[15] + 1;
            this.alogpfrag[i] = 15;
            IAtom atom = this.atomContainer.getAtom(i);
            int n = htype = this.getHAtomType(atom, null);
            this.frags[n] = this.frags[n] + 2;
            for (IBond bond : atom.bonds()) {
                IAtom nbr = bond.getOther(atom);
                if (nbr.getAtomicNumber() != 1) continue;
                this.alogpfrag[nbr.getIndex()] = htype;
            }
        }
    }

    private void calcGroup016_018_036_037(int i) {
        int htype;
        IAtom ai = this.atomContainer.getAtom(i);
        if (!this.fragment[i].equals("SdsCH")) {
            return;
        }
        List ca = this.atomContainer.getConnectedAtomsList(ai);
        int n = htype = this.getHAtomType(this.atomContainer.getAtom(i), ca);
        this.frags[n] = this.frags[n] + 1;
        boolean haveCdX = false;
        boolean haveCsX = false;
        boolean haveCsAr = false;
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (((IAtom)ca.get(j)).getAtomicNumber() == 1) {
                this.alogpfrag[this.atomContainer.indexOf((IAtom)((IAtom)ca.get((int)j)))] = htype;
                continue;
            }
            if (this.atomContainer.getBond(ai, (IAtom)ca.get(j)).getOrder() == IBond.Order.SINGLE) {
                if (((IAtom)ca.get(j)).getAtomicNumber() != 6) {
                    haveCsX = true;
                }
                if (!((IAtom)ca.get(j)).getFlag(32)) continue;
                haveCsAr = true;
                continue;
            }
            if (this.atomContainer.getBond(ai, (IAtom)ca.get(j)).getOrder() != IBond.Order.DOUBLE || ((IAtom)ca.get(j)).getAtomicNumber() == 6) continue;
            haveCdX = true;
        }
        if (haveCdX) {
            if (haveCsAr) {
                this.frags[37] = this.frags[37] + 1;
                this.alogpfrag[i] = 37;
            } else {
                this.frags[36] = this.frags[36] + 1;
                this.alogpfrag[i] = 36;
            }
        } else if (haveCsX) {
            this.frags[18] = this.frags[18] + 1;
            this.alogpfrag[i] = 18;
        } else {
            this.frags[16] = this.frags[16] + 1;
            this.alogpfrag[i] = 16;
        }
    }

    private void calcGroup017_019_020_038_to_041(int i) {
        IAtom ai = this.atomContainer.getAtom(i);
        if (!this.fragment[i].equals("SdssC") && !this.fragment[i].equals("SdaaC")) {
            return;
        }
        List ca = this.atomContainer.getConnectedAtomsList(ai);
        int rCount = 0;
        int xCount = 0;
        boolean haveCdX = false;
        int aromaticCount = 0;
        for (IBond bond : ai.bonds()) {
            IAtom nbor = bond.getOther(ai);
            if (bond.getOrder() == IBond.Order.SINGLE) {
                if (nbor.getAtomicNumber() == 6) {
                    ++rCount;
                    if (!nbor.isAromatic()) continue;
                    ++aromaticCount;
                    continue;
                }
                ++xCount;
                continue;
            }
            if (bond.getOrder() != IBond.Order.DOUBLE || !ALOGPDescriptor.isHetero(nbor)) continue;
            haveCdX = true;
        }
        if (haveCdX) {
            if (aromaticCount >= 1) {
                if (xCount == 1) {
                    this.frags[40] = this.frags[40] + 1;
                    this.alogpfrag[i] = 40;
                } else {
                    this.frags[39] = this.frags[39] + 1;
                    this.alogpfrag[i] = 39;
                }
            } else if (aromaticCount == 0) {
                if (rCount == 1 && xCount == 1) {
                    this.frags[40] = this.frags[40] + 1;
                    this.alogpfrag[i] = 40;
                } else if (rCount == 0 && xCount == 2) {
                    this.frags[41] = this.frags[41] + 1;
                    this.alogpfrag[i] = 41;
                } else {
                    this.frags[38] = this.frags[38] + 1;
                    this.alogpfrag[i] = 38;
                }
            }
        } else if (rCount == 2 && xCount == 0) {
            this.frags[17] = this.frags[17] + 1;
            this.alogpfrag[i] = 17;
        } else if (rCount == 1 && xCount == 1) {
            this.frags[19] = this.frags[19] + 1;
            this.alogpfrag[i] = 19;
        } else if (rCount == 0 && xCount == 2) {
            this.frags[20] = this.frags[20] + 1;
            this.alogpfrag[i] = 20;
        }
    }

    private void calcGroup021_to_023_040(int i) {
        List nbors = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ai = this.atomContainer.getAtom(i);
        if (this.fragment[i].equals("StCH")) {
            int htype;
            this.frags[21] = this.frags[21] + 1;
            this.alogpfrag[i] = 21;
            int n = htype = this.getHAtomType(this.atomContainer.getAtom(i), nbors);
            this.frags[n] = this.frags[n] + 1;
            for (IAtom nbor : nbors) {
                if (nbor.getAtomicNumber() != 1) continue;
                this.alogpfrag[nbor.getIndex()] = htype;
            }
        } else if (this.fragment[i].equals("SddC")) {
            if (((IAtom)nbors.get(0)).getAtomicNumber() == 6 && ((IAtom)nbors.get(1)).getAtomicNumber() == 6) {
                this.frags[22] = this.frags[22] + 1;
                this.alogpfrag[i] = 22;
            } else if (((IAtom)nbors.get(0)).getAtomicNumber() != 6 && ((IAtom)nbors.get(1)).getAtomicNumber() != 6) {
                this.frags[40] = this.frags[40] + 1;
                this.alogpfrag[i] = 40;
            }
        } else if (this.fragment[i].equals("StsC")) {
            boolean haveCtX = false;
            boolean haveCsX = false;
            for (int j = 0; j <= nbors.size() - 1; ++j) {
                if (this.atomContainer.getBond(ai, (IAtom)nbors.get(j)).getOrder() == IBond.Order.SINGLE) {
                    if (((IAtom)nbors.get(j)).getAtomicNumber() == 6) continue;
                    haveCsX = true;
                    continue;
                }
                if (this.atomContainer.getBond(ai, (IAtom)nbors.get(j)).getOrder() != IBond.Order.TRIPLE || ((IAtom)nbors.get(j)).getAtomicNumber() == 6) continue;
                haveCtX = true;
            }
            if (haveCtX && !haveCsX) {
                this.frags[40] = this.frags[40] + 1;
                this.alogpfrag[i] = 40;
            } else if (haveCsX) {
                this.frags[23] = this.frags[23] + 1;
                this.alogpfrag[i] = 23;
            } else if (!haveCsX) {
                this.frags[22] = this.frags[22] + 1;
                this.alogpfrag[i] = 22;
            }
        }
    }

    private void calcGroup024_027_030_033_042(int i) {
        IAtom ca1;
        IAtom ca0;
        int htype;
        if (!this.fragment[i].equals("SaaCH")) {
            return;
        }
        IAtom atom = this.atomContainer.getAtom(i);
        List nbors = this.atomContainer.getConnectedAtomsList(atom);
        int n = htype = this.getHAtomType(atom, nbors);
        this.frags[n] = this.frags[n] + 1;
        if (atom.getImplicitHydrogenCount() == 1) {
            ca0 = (IAtom)nbors.get(0);
            ca1 = (IAtom)nbors.get(1);
        } else if (((IAtom)nbors.get(0)).getAtomicNumber() == 1) {
            this.alogpfrag[this.atomContainer.indexOf((IAtom)((IAtom)nbors.get((int)0)))] = htype;
            ca0 = (IAtom)nbors.get(1);
            ca1 = (IAtom)nbors.get(2);
        } else if (((IAtom)nbors.get(1)).getAtomicNumber() == 1) {
            ca0 = (IAtom)nbors.get(0);
            this.alogpfrag[this.atomContainer.indexOf((IAtom)((IAtom)nbors.get((int)1)))] = htype;
            ca1 = (IAtom)nbors.get(2);
        } else if (((IAtom)nbors.get(2)).getAtomicNumber() == 1) {
            ca0 = (IAtom)nbors.get(0);
            ca1 = (IAtom)nbors.get(1);
            this.alogpfrag[this.atomContainer.indexOf((IAtom)((IAtom)nbors.get((int)2)))] = htype;
        } else {
            throw new IllegalStateException();
        }
        if (ca0.getAtomicNumber() == 6 && ca1.getAtomicNumber() == 6) {
            this.frags[24] = this.frags[24] + 1;
            this.alogpfrag[i] = 24;
            return;
        }
        List bonds = this.atomContainer.getConnectedBondsList(ca0);
        boolean haveDouble1 = false;
        for (int k = 0; k <= bonds.size() - 1; ++k) {
            if (((IBond)bonds.get(k)).getOrder() != IBond.Order.DOUBLE) continue;
            haveDouble1 = true;
            break;
        }
        bonds = this.atomContainer.getConnectedBondsList(ca1);
        boolean haveDouble2 = false;
        for (int k = 0; k <= bonds.size() - 1; ++k) {
            if (((IBond)bonds.get(k)).getOrder() != IBond.Order.DOUBLE) continue;
            haveDouble2 = true;
            break;
        }
        if (ca0.getAtomicNumber() != 6 && ((IAtom)nbors.get(1)).getAtomicNumber() != 6) {
            if (haveDouble1 && haveDouble2) {
                this.frags[30] = this.frags[30] + 1;
                this.alogpfrag[i] = 30;
            } else {
                this.frags[42] = this.frags[42] + 1;
                this.alogpfrag[i] = 42;
            }
        } else if (ca0.getAtomicNumber() == 6 && ca1.getAtomicNumber() != 6 || ca0.getAtomicNumber() != 6 && ca1.getAtomicNumber() == 6) {
            if (haveDouble1 && haveDouble2) {
                this.frags[27] = this.frags[27] + 1;
                this.alogpfrag[i] = 27;
            } else {
                this.frags[33] = this.frags[33] + 1;
                this.alogpfrag[i] = 33;
            }
        }
    }

    private void calcGroup025_026_028_029_031_032_034_035_043_044(int i) {
        if (!this.fragment[i].equals("SsaaC") && !this.fragment[i].equals("SaaaC")) {
            return;
        }
        IAtom atm = this.atomContainer.getAtom(i);
        List nbors = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom[] sameringatoms = new IAtom[2];
        IAtom nonringatom = (IAtom)this.atomContainer.getBuilder().newInstance(IAtom.class, new Object[0]);
        int sameringatomscount = 0;
        for (int j = 0; j <= nbors.size() - 1; ++j) {
            if (!this.inSameAromaticRing(this.atomContainer, atm, (IAtom)nbors.get(j), this.rs)) continue;
            ++sameringatomscount;
        }
        if (sameringatomscount == 2) {
            int count = 0;
            for (int j = 0; j <= nbors.size() - 1; ++j) {
                if (this.inSameAromaticRing(this.atomContainer, atm, (IAtom)nbors.get(j), this.rs)) {
                    sameringatoms[count] = (IAtom)nbors.get(j);
                    ++count;
                    continue;
                }
                nonringatom = (IAtom)nbors.get(j);
            }
        } else {
            Collections.sort(nbors, new Comparator<IAtom>(){

                @Override
                public int compare(IAtom a, IAtom b) {
                    return -Boolean.compare(ALOGPDescriptor.isHetero(a), ALOGPDescriptor.isHetero(b));
                }
            });
            sameringatoms[0] = (IAtom)nbors.get(0);
            sameringatoms[1] = (IAtom)nbors.get(1);
            nonringatom = (IAtom)nbors.get(2);
        }
        List bonds = this.atomContainer.getConnectedBondsList(sameringatoms[0]);
        boolean haveDouble1 = false;
        for (int k = 0; k <= bonds.size() - 1; ++k) {
            if (((IBond)bonds.get(k)).getOrder() != IBond.Order.DOUBLE) continue;
            haveDouble1 = true;
            break;
        }
        bonds = this.atomContainer.getConnectedBondsList(sameringatoms[1]);
        boolean haveDouble2 = false;
        for (int k = 0; k <= bonds.size() - 1; ++k) {
            if (((IBond)bonds.get(k)).getOrder() != IBond.Order.DOUBLE) continue;
            haveDouble2 = true;
            break;
        }
        if (sameringatoms[0].getAtomicNumber() != 6 && sameringatoms[1].getAtomicNumber() != 6) {
            if (haveDouble1 && haveDouble2) {
                if (nonringatom.getAtomicNumber() == 6) {
                    this.frags[31] = this.frags[31] + 1;
                    this.alogpfrag[i] = 31;
                } else {
                    this.frags[32] = this.frags[32] + 1;
                    this.alogpfrag[i] = 32;
                }
            } else if (nonringatom.getAtomicNumber() == 6) {
                this.frags[43] = this.frags[43] + 1;
                this.alogpfrag[i] = 43;
            } else {
                this.frags[44] = this.frags[44] + 1;
                this.alogpfrag[i] = 44;
            }
        } else if (sameringatoms[0].getAtomicNumber() == 6 && sameringatoms[1].getAtomicNumber() == 6) {
            if (nonringatom.getAtomicNumber() == 6) {
                this.frags[25] = this.frags[25] + 1;
                this.alogpfrag[i] = 25;
            } else {
                this.frags[26] = this.frags[26] + 1;
                this.alogpfrag[i] = 26;
            }
        } else if (sameringatoms[0].getAtomicNumber() == 6 && sameringatoms[1].getAtomicNumber() != 6 || sameringatoms[0].getAtomicNumber() != 6 && sameringatoms[1].getAtomicNumber() == 6) {
            if (haveDouble1 && haveDouble2) {
                if (nonringatom.getAtomicNumber() == 6) {
                    this.frags[28] = this.frags[28] + 1;
                    this.alogpfrag[i] = 28;
                } else {
                    this.frags[29] = this.frags[29] + 1;
                    this.alogpfrag[i] = 29;
                }
            } else if (nonringatom.getAtomicNumber() == 6) {
                this.frags[34] = this.frags[34] + 1;
                this.alogpfrag[i] = 34;
            } else {
                this.frags[35] = this.frags[35] + 1;
                this.alogpfrag[i] = 35;
            }
        }
    }

    private boolean isPyrroleLikeHetero(IAtom atom) {
        if (!atom.isAromatic()) {
            return false;
        }
        switch (atom.getAtomicNumber()) {
            case 7: 
            case 15: {
                if (atom.getBondCount() == 3 && atom.getFormalCharge() == 0) {
                    return true;
                }
                if (atom.getBondCount() == 2 && atom.getImplicitHydrogenCount() == 1) {
                    return true;
                }
                return atom.getBondCount() == 2 && atom.getFormalCharge() == -1;
            }
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private int getHAtomType(IAtom atom, List connectedAtoms) {
        IAtomType.Hybridization hyb;
        List ca = connectedAtoms == null ? this.atomContainer.getConnectedAtomsList(atom) : connectedAtoms;
        int ndoub = 0;
        int ntrip = 0;
        int oxNum = 0;
        int xCount = 0;
        boolean hasConjHetereo = false;
        for (IBond bond : atom.bonds()) {
            if (bond.getOrder() == IBond.Order.DOUBLE) {
                ++ndoub;
            } else if (bond.getOrder() == IBond.Order.TRIPLE) {
                ++ntrip;
            }
            IAtom nbor = bond.getOther(atom);
            if (ALOGPDescriptor.isHetero(nbor)) {
                if (bond.isAromatic()) {
                    if (bond.getOrder() == IBond.Order.SINGLE) {
                        if (!this.isPyrroleLikeHetero(nbor) && !hasConjHetereo) {
                            oxNum += 2;
                            hasConjHetereo = true;
                            continue;
                        }
                        ++oxNum;
                        continue;
                    }
                    if (!hasConjHetereo) {
                        hasConjHetereo = true;
                        oxNum += 2;
                        continue;
                    }
                    ++oxNum;
                    continue;
                }
                oxNum += bond.getOrder().numeric().intValue();
                continue;
            }
            if (nbor.getAtomicNumber() != 6) continue;
            for (IBond bond2 : nbor.bonds()) {
                IAtom nbor2 = bond2.getOther(nbor);
                if (!ALOGPDescriptor.isHetero(nbor2)) continue;
                ++xCount;
            }
        }
        if (ndoub == 0 && ntrip == 0) {
            hyb = IAtomType.Hybridization.SP3;
        } else if (ndoub == 1 && ntrip == 0) {
            hyb = IAtomType.Hybridization.SP2;
        } else if (ndoub == 2 || ntrip == 1) {
            hyb = IAtomType.Hybridization.SP1;
        } else {
            return 0;
        }
        boolean isAlphaC = false;
        if (atom.getAtomicNumber() == 6 && hyb == IAtomType.Hybridization.SP3) {
            for (IBond bond : atom.bonds()) {
                IAtom nbor = bond.getOther(atom);
                if (ALOGPDescriptor.isHetero(nbor)) {
                    isAlphaC = false;
                    break;
                }
                if (nbor.getAtomicNumber() != 6) continue;
                int numDoubX = 0;
                int numTripX = 0;
                int numAromX = 0;
                for (IBond bond2 : nbor.bonds()) {
                    IAtom nbor2 = bond2.getOther(nbor);
                    if (!ALOGPDescriptor.isHetero(nbor2)) continue;
                    switch (bond2.getOrder()) {
                        case SINGLE: {
                            if (!bond2.isAromatic()) break;
                            ++numAromX;
                            break;
                        }
                        case DOUBLE: {
                            if (bond2.isAromatic()) {
                                ++numAromX;
                                break;
                            }
                            ++numDoubX;
                            break;
                        }
                        case TRIPLE: {
                            ++numTripX;
                        }
                    }
                }
                if (numDoubX + numTripX + numAromX != 1) continue;
                isAlphaC = true;
            }
        }
        if (isAlphaC) {
            return 51;
        }
        switch (hyb) {
            case SP1: {
                if (oxNum == 0) {
                    return 48;
                }
                if (oxNum != 1) break;
                return 49;
            }
            case SP2: {
                if (oxNum == 0) {
                    return 47;
                }
                if (oxNum == 1) {
                    return 48;
                }
                if (oxNum != 2 && oxNum != 3) break;
                return 49;
            }
            case SP3: {
                if (oxNum == 0) {
                    if (xCount == 0) {
                        return 46;
                    }
                    if (xCount == 1) {
                        return 52;
                    }
                    if (xCount == 2) {
                        return 53;
                    }
                    if (xCount == 3) {
                        return 54;
                    }
                    if (xCount == 4) {
                        return 55;
                    }
                }
                if (oxNum == 1) {
                    return 47;
                }
                if (oxNum == 2) {
                    return 48;
                }
                if (oxNum != 3) break;
                return 49;
            }
        }
        return 0;
    }

    private void calcGroup056_57(int i) {
        int htype;
        if (!this.fragment[i].equals("SsOH")) {
            return;
        }
        IAtom atm = this.atomContainer.getAtom(i);
        int n = htype = 50;
        this.frags[n] = this.frags[n] + 1;
        IAtom ca0 = null;
        for (IBond bond : atm.bonds()) {
            IAtom nbor = bond.getOther(atm);
            if (nbor.getAtomicNumber() == 6) {
                ca0 = nbor;
                continue;
            }
            if (nbor.getAtomicNumber() != 1) continue;
            this.alogpfrag[nbor.getIndex()] = htype;
        }
        if (ca0 != null) {
            if (ca0.isAromatic()) {
                this.frags[57] = this.frags[57] + 1;
                this.alogpfrag[i] = 57;
                return;
            }
            for (IBond bond : ca0.bonds()) {
                IAtom nbor2 = bond.getOther(ca0);
                if (nbor2 == atm || bond.getOrder() != IBond.Order.DOUBLE || nbor2.getAtomicNumber() != 6 && nbor2.getAtomicNumber() != 8) continue;
                this.frags[57] = this.frags[57] + 1;
                this.alogpfrag[i] = 57;
                return;
            }
        }
        this.frags[56] = this.frags[56] + 1;
        this.alogpfrag[i] = 56;
    }

    private void calcGroup058_61(int i) {
        List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        if (this.fragment[i].equals("SsOm")) {
            IAtom ca0 = (IAtom)ca.get(0);
            if (ca0.getAtomicNumber() == 7 && ca0.getFormalCharge() == 1) {
                this.frags[61] = this.frags[61] + 1;
                this.alogpfrag[i] = 61;
            } else {
                this.frags[62] = this.frags[62] + 1;
                this.alogpfrag[i] = 62;
            }
        } else if (this.fragment[i].equals("SdO")) {
            IAtom ca0 = (IAtom)ca.get(0);
            if (ca0.getAtomicNumber() == 7 && ca0.getFormalCharge() == 1) {
                this.frags[61] = this.frags[61] + 1;
                this.alogpfrag[i] = 61;
            } else {
                this.frags[58] = this.frags[58] + 1;
                this.alogpfrag[i] = 58;
            }
        }
    }

    private void calcGroup059_060_063(int i) {
        if (!this.fragment[i].equals("SssO") && !this.fragment[i].equals("SaaO")) {
            return;
        }
        List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ca0 = (IAtom)ca.get(0);
        IAtom ca1 = (IAtom)ca.get(1);
        if (this.fragment[i].equals("SssO")) {
            if (ca0.getFlag(32) || ca1.getFlag(32)) {
                this.frags[60] = this.frags[60] + 1;
                this.alogpfrag[i] = 60;
            } else {
                for (int j = 0; j <= ca.size() - 1; ++j) {
                    if (((IAtom)ca.get(j)).getAtomicNumber() != 6) continue;
                    List ca2 = this.atomContainer.getConnectedAtomsList((IAtom)ca.get(j));
                    for (int k = 0; k <= ca2.size() - 1; ++k) {
                        if (this.atomContainer.getBond((IAtom)ca.get(j), (IAtom)ca2.get(k)).getOrder() != IBond.Order.DOUBLE || ((IAtom)ca2.get(k)).getAtomicNumber() == 6) continue;
                        this.frags[60] = this.frags[60] + 1;
                        this.alogpfrag[i] = 60;
                        return;
                    }
                }
                if (ca0.getAtomicNumber() == 8 || ca1.getAtomicNumber() == 8) {
                    this.frags[63] = this.frags[63] + 1;
                    this.alogpfrag[i] = 63;
                } else {
                    this.frags[59] = this.frags[59] + 1;
                    this.alogpfrag[i] = 59;
                }
            }
        } else if (this.fragment[i].equals("SaaO")) {
            this.frags[60] = this.frags[60] + 1;
            this.alogpfrag[i] = 60;
        }
    }

    private void calcGroup066_to_079(int i) {
        int j;
        int nAr = 0;
        int nAl = 0;
        IAtom atom = this.atomContainer.getAtom(i);
        IAtom ai = atom;
        if (ai.getAtomicNumber() != 7) {
            return;
        }
        List nbors = this.atomContainer.getConnectedAtomsList(atom);
        int htype = 50;
        for (IAtom nbor : nbors) {
            if (nbor.getAtomicNumber() != 1) continue;
            this.alogpfrag[nbor.getIndex()] = htype;
            int n = htype;
            this.frags[n] = this.frags[n] + 1;
        }
        int n = htype;
        this.frags[n] = this.frags[n] + atom.getImplicitHydrogenCount();
        for (j = 0; j <= nbors.size() - 1; ++j) {
            if (((IAtom)nbors.get(j)).getAtomicNumber() == 1) continue;
            if (((IAtom)nbors.get(j)).getFlag(32)) {
                ++nAr;
                continue;
            }
            ++nAl;
        }
        if (this.fragment[i].equals("SsssN") || this.fragment[i].equals("SssNH") || this.fragment[i].equals("SsNH2")) {
            for (j = 0; j <= nbors.size() - 1; ++j) {
                if (((IAtom)nbors.get(j)).getAtomicNumber() == 1) continue;
                List ca2 = this.atomContainer.getConnectedAtomsList((IAtom)nbors.get(j));
                for (int k = 0; k <= ca2.size() - 1; ++k) {
                    IAtom ca2k = (IAtom)ca2.get(k);
                    if (this.atomContainer.indexOf(ca2k) == i || ca2k.getAtomicNumber() == 6 || ca2k.getFlag(32) || ((IAtom)nbors.get(j)).getFlag(32) || ai.getFlag(32) || this.atomContainer.getBond((IAtom)nbors.get(j), ca2k).getOrder() != IBond.Order.DOUBLE) continue;
                    this.frags[72] = this.frags[72] + 1;
                    this.alogpfrag[i] = 72;
                    return;
                }
            }
        }
        if (this.fragment[i].equals("SsNH2")) {
            IAtom ca0 = null;
            for (IAtom nbor : nbors) {
                if (nbor.getAtomicNumber() == 1) continue;
                ca0 = nbor;
                break;
            }
            if (ca0.getFlag(32) || ca0.getAtomicNumber() != 6) {
                this.frags[69] = this.frags[69] + 1;
                this.alogpfrag[i] = 69;
            } else {
                this.frags[66] = this.frags[66] + 1;
                this.alogpfrag[i] = 66;
            }
        } else if (this.fragment[i].equals("SaaNH") || this.fragment[i].equals("SsaaN") || this.fragment[i].equals("SaaaN") || this.fragment[i].equals("SaaNm")) {
            this.frags[73] = this.frags[73] + 1;
            this.alogpfrag[i] = 73;
        } else if (this.fragment[i].equals("SssNH")) {
            if (nAr == 2 && nAl == 0) {
                this.frags[73] = this.frags[73] + 1;
                this.alogpfrag[i] = 73;
            } else if (nAr == 1 && nAl == 1) {
                this.frags[70] = this.frags[70] + 1;
                this.alogpfrag[i] = 70;
            } else if (nAr == 0 && nAl == 2) {
                this.frags[67] = this.frags[67] + 1;
                this.alogpfrag[i] = 67;
            }
        } else if (this.fragment[i].equals("SsssN")) {
            if (nAr == 3 && nAl == 0 || nAr == 2 && nAl == 1) {
                this.frags[73] = this.frags[73] + 1;
                this.alogpfrag[i] = 73;
            } else if (nAr == 1 && nAl == 2) {
                this.frags[71] = this.frags[71] + 1;
                this.alogpfrag[i] = 71;
            } else if (nAr == 0 && nAl == 3) {
                this.frags[68] = this.frags[68] + 1;
                this.alogpfrag[i] = 68;
            }
        } else if (this.fragment[i].equals("SaaN")) {
            this.frags[75] = this.frags[75] + 1;
            this.alogpfrag[i] = 75;
        } else if (this.fragment[i].equals("SdssNp") || this.fragment[i].equals("SddsN")) {
            boolean isNitro;
            int haveSsOm = 0;
            int haveSdO = 0;
            boolean ar = false;
            for (int j2 = 0; j2 <= nbors.size() - 1; ++j2) {
                if (this.fragment[this.atomContainer.indexOf((IAtom)nbors.get(j2))].equals("SsOm")) {
                    ++haveSsOm;
                    continue;
                }
                if (this.fragment[this.atomContainer.indexOf((IAtom)nbors.get(j2))].equals("SdO")) {
                    ++haveSdO;
                    continue;
                }
                if (!((IAtom)nbors.get(j2)).getFlag(32)) continue;
                ar = true;
            }
            boolean bl = isNitro = haveSdO == 2 || haveSsOm >= 1 && haveSdO >= 1;
            if (isNitro && ar) {
                this.frags[76] = this.frags[76] + 1;
                this.alogpfrag[i] = 76;
            } else if (isNitro && !ar) {
                this.frags[77] = this.frags[77] + 1;
                this.alogpfrag[i] = 77;
            } else {
                this.frags[79] = this.frags[79] + 1;
                this.alogpfrag[i] = 79;
            }
        } else if (this.fragment[i].equals("StN")) {
            IAtom ca0 = (IAtom)nbors.get(0);
            if (ca0.getAtomicNumber() == 6) {
                this.frags[74] = this.frags[74] + 1;
                this.alogpfrag[i] = 74;
            }
        } else if (this.fragment[i].equals("SdNH") || this.fragment[i].equals("SdsN")) {
            if (this.fragment[i].equals("SdsN")) {
                IAtom ca0 = (IAtom)nbors.get(0);
                IAtom ca1 = (IAtom)nbors.get(1);
                if (ca0.getAtomicNumber() == 8 && ca1.getAtomicNumber() == 8) {
                    this.frags[76] = this.frags[76] + 1;
                    this.alogpfrag[i] = 76;
                    return;
                }
            }
            boolean flag1 = false;
            boolean flag2 = false;
            for (int j3 = 0; j3 <= nbors.size() - 1; ++j3) {
                if (((IAtom)nbors.get(j3)).getAtomicNumber() == 1) continue;
                if (this.atomContainer.getBond(ai, (IAtom)nbors.get(j3)).getOrder() == IBond.Order.DOUBLE) {
                    if (((IAtom)nbors.get(j3)).getAtomicNumber() == 6) {
                        this.frags[74] = this.frags[74] + 1;
                        this.alogpfrag[i] = 74;
                        return;
                    }
                    flag1 = true;
                } else if (((IAtom)nbors.get(j3)).getAtomicNumber() != 6 || ((IAtom)nbors.get(j3)).getFlag(32)) {
                    flag2 = true;
                }
                if (!flag1 || !flag2) continue;
                this.frags[78] = this.frags[78] + 1;
                this.alogpfrag[i] = 78;
                return;
            }
        } else if (this.fragment[i].indexOf(112) > -1) {
            this.frags[79] = this.frags[79] + 1;
            this.alogpfrag[i] = 79;
        }
    }

    private void calcGroup081_to_085(int i) {
        if (!this.fragment[i].equals("SsF")) {
            return;
        }
        List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ca0 = (IAtom)ca.get(0);
        List bonds = this.atomContainer.getConnectedBondsList(ca0);
        int doublebondcount = 0;
        int triplebondcount = 0;
        String hybrid = "";
        for (int j = 0; j <= bonds.size() - 1; ++j) {
            IBond bj = (IBond)bonds.get(j);
            if (bj.getOrder() == IBond.Order.DOUBLE) {
                ++doublebondcount;
                continue;
            }
            if (bj.getOrder() != IBond.Order.TRIPLE) continue;
            ++triplebondcount;
        }
        if (doublebondcount == 0 && triplebondcount == 0) {
            hybrid = "sp3";
        } else if (doublebondcount == 1) {
            hybrid = "sp2";
        } else if (doublebondcount == 2 || triplebondcount == 1) {
            hybrid = "sp";
        }
        List ca2 = this.atomContainer.getConnectedAtomsList(ca0);
        int oxNum = 0;
        for (int j = 0; j <= ca2.size() - 1; ++j) {
            IAtom ca2j = (IAtom)ca2.get(j);
            if (!ALOGPDescriptor.isHetero(ca2j)) continue;
            oxNum += this.atomContainer.getBond(ca0, ca2j).getOrder().numeric().intValue();
        }
        if (ca0.getAtomicNumber() == 6) {
            if (hybrid.equals("sp3") && oxNum == 1) {
                this.frags[81] = this.frags[81] + 1;
                this.alogpfrag[i] = 81;
            } else if (hybrid.equals("sp3") && oxNum == 2) {
                this.frags[82] = this.frags[82] + 1;
                this.alogpfrag[i] = 82;
            } else if (hybrid.equals("sp3") && oxNum == 3) {
                this.frags[83] = this.frags[83] + 1;
                this.alogpfrag[i] = 83;
            } else if (hybrid.equals("sp2") && oxNum == 1) {
                this.frags[84] = this.frags[84] + 1;
                this.alogpfrag[i] = 84;
            } else if (hybrid.equals("sp2") && oxNum > 1 || hybrid.equals("sp") && oxNum >= 1 || hybrid.equals("sp3") && oxNum == 4) {
                this.frags[85] = this.frags[85] + 1;
                this.alogpfrag[i] = 85;
            }
        } else {
            this.frags[85] = this.frags[85] + 1;
            this.alogpfrag[i] = 85;
        }
    }

    private void calcGroup086_to_090(int i) {
        if (!this.fragment[i].equals("SsCl")) {
            return;
        }
        List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ca0 = (IAtom)ca.get(0);
        List bonds = this.atomContainer.getConnectedBondsList(ca0);
        int doublebondcount = 0;
        int triplebondcount = 0;
        String hybrid = "";
        for (int j = 0; j <= bonds.size() - 1; ++j) {
            IBond bj = (IBond)bonds.get(j);
            if (bj.getOrder() == IBond.Order.DOUBLE) {
                ++doublebondcount;
                continue;
            }
            if (bj.getOrder() != IBond.Order.TRIPLE) continue;
            ++triplebondcount;
        }
        if (doublebondcount == 0 && triplebondcount == 0) {
            hybrid = "sp3";
        } else if (doublebondcount == 1) {
            hybrid = "sp2";
        } else if (doublebondcount == 2 || triplebondcount == 1) {
            hybrid = "sp";
        }
        List ca2 = this.atomContainer.getConnectedAtomsList(ca0);
        int oxNum = 0;
        for (int j = 0; j <= ca2.size() - 1; ++j) {
            IAtom ca2j = (IAtom)ca2.get(j);
            String s = ca2j.getSymbol();
            if (!(this.ap.getNormalizedElectronegativity(s) > 1.0)) continue;
            oxNum = (int)((double)oxNum + BondManipulator.destroyBondOrder((IBond.Order)this.atomContainer.getBond(ca0, ca2j).getOrder()));
        }
        if (ca0.getAtomicNumber() == 6) {
            if (hybrid.equals("sp3") && oxNum == 1) {
                this.frags[86] = this.frags[86] + 1;
                this.alogpfrag[i] = 86;
            } else if (hybrid.equals("sp3") && oxNum == 2) {
                this.frags[87] = this.frags[87] + 1;
                this.alogpfrag[i] = 87;
            } else if (hybrid.equals("sp3") && oxNum == 3) {
                this.frags[88] = this.frags[88] + 1;
                this.alogpfrag[i] = 88;
            } else if (hybrid.equals("sp2") && oxNum == 1) {
                this.frags[89] = this.frags[89] + 1;
                this.alogpfrag[i] = 89;
            } else if (hybrid.equals("sp2") && oxNum > 1 || hybrid.equals("sp") && oxNum >= 1 || hybrid.equals("sp3") && oxNum == 4) {
                this.frags[90] = this.frags[90] + 1;
                this.alogpfrag[i] = 90;
            }
        } else {
            this.frags[90] = this.frags[90] + 1;
            this.alogpfrag[i] = 90;
        }
    }

    private void calcGroup091_to_095(int i) {
        if (!this.fragment[i].equals("SsBr")) {
            return;
        }
        List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ca0 = (IAtom)ca.get(0);
        List bonds = this.atomContainer.getConnectedBondsList(ca0);
        int doublebondcount = 0;
        int triplebondcount = 0;
        String hybrid = "";
        for (int j = 0; j <= bonds.size() - 1; ++j) {
            IBond bj = (IBond)bonds.get(j);
            if (bj.getOrder() == IBond.Order.DOUBLE) {
                ++doublebondcount;
            }
            if (bj.getOrder() != IBond.Order.TRIPLE) continue;
            ++triplebondcount;
        }
        if (doublebondcount == 0 && triplebondcount == 0) {
            hybrid = "sp3";
        } else if (doublebondcount == 1) {
            hybrid = "sp2";
        } else if (doublebondcount == 2 || triplebondcount == 1) {
            hybrid = "sp";
        }
        List ca2 = this.atomContainer.getConnectedAtomsList(ca0);
        int oxNum = 0;
        for (int j = 0; j <= ca2.size() - 1; ++j) {
            IAtom ca2j = (IAtom)ca2.get(j);
            if (!(this.ap.getNormalizedElectronegativity(ca2j.getSymbol()) > 1.0)) continue;
            oxNum = (int)((double)oxNum + BondManipulator.destroyBondOrder((IBond.Order)this.atomContainer.getBond(ca0, ca2j).getOrder()));
        }
        if (ca0.getAtomicNumber() == 6) {
            if (hybrid.equals("sp3") && oxNum == 1) {
                this.frags[91] = this.frags[91] + 1;
                this.alogpfrag[i] = 91;
            } else if (hybrid.equals("sp3") && oxNum == 2) {
                this.frags[92] = this.frags[92] + 1;
                this.alogpfrag[i] = 92;
            } else if (hybrid.equals("sp3") && oxNum == 3) {
                this.frags[93] = this.frags[93] + 1;
                this.alogpfrag[i] = 93;
            } else if (hybrid.equals("sp2") && oxNum == 1) {
                this.frags[94] = this.frags[94] + 1;
                this.alogpfrag[i] = 94;
            } else if (hybrid.equals("sp2") && oxNum > 1 || hybrid.equals("sp") && oxNum >= 1 || hybrid.equals("sp3") && oxNum == 4) {
                this.frags[95] = this.frags[95] + 1;
                this.alogpfrag[i] = 95;
            }
        } else {
            this.frags[95] = this.frags[95] + 1;
            this.alogpfrag[i] = 95;
        }
    }

    private void calcGroup096_to_100(int i) {
        if (!this.fragment[i].equals("SsI")) {
            return;
        }
        List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ca0 = (IAtom)ca.get(0);
        List bonds = this.atomContainer.getConnectedBondsList(ca0);
        int doublebondcount = 0;
        int triplebondcount = 0;
        String hybrid = "";
        for (int j = 0; j <= bonds.size() - 1; ++j) {
            IBond bj = (IBond)bonds.get(j);
            if (bj.getOrder() == IBond.Order.DOUBLE) {
                ++doublebondcount;
                continue;
            }
            if (bj.getOrder() != IBond.Order.TRIPLE) continue;
            ++triplebondcount;
        }
        if (doublebondcount == 0 && triplebondcount == 0) {
            hybrid = "sp3";
        } else if (doublebondcount == 1) {
            hybrid = "sp2";
        } else if (doublebondcount == 2 || triplebondcount == 1) {
            hybrid = "sp";
        }
        List ca2 = this.atomContainer.getConnectedAtomsList(ca0);
        int oxNum = 0;
        for (int j = 0; j <= ca2.size() - 1; ++j) {
            IAtom ca2j = (IAtom)ca2.get(j);
            if (!(this.ap.getNormalizedElectronegativity(ca2j.getSymbol()) > 1.0)) continue;
            oxNum = (int)((double)oxNum + BondManipulator.destroyBondOrder((IBond.Order)this.atomContainer.getBond(ca0, ca2j).getOrder()));
        }
        if (ca0.getAtomicNumber() == 6) {
            if (hybrid.equals("sp3") && oxNum == 1) {
                this.frags[96] = this.frags[96] + 1;
                this.alogpfrag[i] = 96;
            } else if (hybrid.equals("sp3") && oxNum == 2) {
                this.frags[97] = this.frags[97] + 1;
                this.alogpfrag[i] = 97;
            } else if (hybrid.equals("sp3") && oxNum == 3) {
                this.frags[98] = this.frags[98] + 1;
                this.alogpfrag[i] = 98;
            } else if (hybrid.equals("sp2") && oxNum == 1) {
                this.frags[99] = this.frags[99] + 1;
                this.alogpfrag[i] = 99;
            } else if (hybrid.equals("sp2") && oxNum > 1 || hybrid.equals("sp") && oxNum >= 1 || hybrid.equals("sp3") && oxNum == 4) {
                this.frags[100] = this.frags[100] + 1;
                this.alogpfrag[i] = 100;
            }
        } else {
            this.frags[100] = this.frags[100] + 1;
            this.alogpfrag[i] = 100;
        }
    }

    private void calcGroup101_to_104(int i) {
        IAtom ai = this.atomContainer.getAtom(i);
        String s = ai.getSymbol();
        if (ai.getFormalCharge() == -1 || ai.getFormalCharge() == 0 && this.isBondedToHydrogenOnly(ai)) {
            if (s.equals("F")) {
                this.frags[101] = this.frags[101] + 1;
                this.alogpfrag[i] = 101;
            } else if (s.equals("Cl")) {
                this.frags[102] = this.frags[102] + 1;
                this.alogpfrag[i] = 102;
            } else if (s.equals("Br")) {
                this.frags[103] = this.frags[103] + 1;
                this.alogpfrag[i] = 103;
            } else if (s.equals("I")) {
                this.frags[104] = this.frags[104] + 1;
                this.alogpfrag[i] = 104;
            }
        }
    }

    private boolean isBondedToHydrogenOnly(IAtom ai) {
        return ai.getBondCount() == 0 && ai.getImplicitHydrogenCount() == 1 || ai.getBondCount() == 1 && ((IBond)ai.bonds().iterator().next()).getOther(ai).getAtomicNumber() == 1;
    }

    private void calcGroup106(int i) {
        if (this.fragment[i].equals("SsSH")) {
            int htype;
            this.frags[106] = this.frags[106] + 1;
            this.alogpfrag[i] = 106;
            int n = htype = 50;
            this.frags[n] = this.frags[n] + 1;
            IAtom atom = this.atomContainer.getAtom(i);
            for (IBond bond : atom.bonds()) {
                IAtom nbor = bond.getOther(atom);
                if (nbor.getAtomicNumber() != 1) continue;
                this.alogpfrag[nbor.getIndex()] = htype;
            }
        }
    }

    private void calcGroup107(int i) {
        if (this.fragment[i].equals("SssS") || this.fragment[i].equals("SaaS")) {
            this.frags[107] = this.frags[107] + 1;
            this.alogpfrag[i] = 107;
        }
    }

    private void calcGroup108(int i) {
        if (this.fragment[i].equals("SdS")) {
            this.frags[108] = this.frags[108] + 1;
            this.alogpfrag[i] = 108;
        }
    }

    private void calcGroup109(int i) {
        if (!this.fragment[i].equals("SdssS")) {
            return;
        }
        List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ai = this.atomContainer.getAtom(i);
        int sdOCount = 0;
        int ssCCount = 0;
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (this.atomContainer.getBond(ai, (IAtom)ca.get(j)).getOrder() == IBond.Order.SINGLE) {
                if (((IAtom)ca.get(j)).getAtomicNumber() != 6) continue;
                ++ssCCount;
                continue;
            }
            if (this.atomContainer.getBond(ai, (IAtom)ca.get(j)).getOrder() != IBond.Order.DOUBLE || ((IAtom)ca.get(j)).getAtomicNumber() != 8) continue;
            ++sdOCount;
        }
        if (sdOCount == 1) {
            this.frags[109] = this.frags[109] + 1;
            this.alogpfrag[i] = 109;
        }
    }

    private void calcGroup110(int i) {
        if (!this.fragment[i].equals("SddssS")) {
            return;
        }
        List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ai = this.atomContainer.getAtom(i);
        int sdOCount = 0;
        int ssCCount = 0;
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (this.atomContainer.getBond(ai, (IAtom)ca.get(j)).getOrder() == IBond.Order.SINGLE) {
                if (((IAtom)ca.get(j)).getAtomicNumber() != 6) continue;
                ++ssCCount;
                continue;
            }
            if (this.atomContainer.getBond(ai, (IAtom)ca.get(j)).getOrder() != IBond.Order.DOUBLE || ((IAtom)ca.get(j)).getAtomicNumber() != 8) continue;
            ++sdOCount;
        }
        if (sdOCount == 2) {
            this.frags[110] = this.frags[110] + 1;
            this.alogpfrag[i] = 110;
        }
    }

    private void calcGroup111(int i) {
        if (this.fragment[i].equals("SssssSi")) {
            this.frags[111] = this.frags[111] + 1;
            this.alogpfrag[i] = 111;
        }
    }

    private void calcGroup112(int i) {
        if (this.fragment[i].equals("SsssB") || this.fragment[i].equals("SssBm")) {
            this.frags[112] = this.frags[112] + 1;
            this.alogpfrag[i] = 112;
        }
    }

    private void calcGroup115(int i) {
        if (this.fragment[i].equals("SssssPp")) {
            this.frags[115] = this.frags[115] + 1;
            this.alogpfrag[i] = 115;
        }
    }

    private void calcGroup116_117_120(int i) {
        List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ai = this.atomContainer.getAtom(i);
        int xCount = 0;
        int rCount = 0;
        boolean pdX = false;
        if (!this.fragment[i].equals("SdsssP")) {
            return;
        }
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (this.atomContainer.getBond(ai, (IAtom)ca.get(j)).getOrder() == IBond.Order.SINGLE) {
                if (((IAtom)ca.get(j)).getAtomicNumber() == 6) {
                    ++rCount;
                    continue;
                }
                ++xCount;
                continue;
            }
            if (this.atomContainer.getBond(ai, (IAtom)ca.get(j)).getOrder() != IBond.Order.DOUBLE || ((IAtom)ca.get(j)).getAtomicNumber() == 6) continue;
            pdX = true;
        }
        if (pdX) {
            if (rCount == 3) {
                this.frags[116] = this.frags[116] + 1;
                this.alogpfrag[i] = 116;
            } else if (xCount == 3) {
                this.frags[117] = this.frags[117] + 1;
                this.alogpfrag[i] = 117;
            } else if (xCount == 2 && rCount == 1) {
                this.frags[120] = this.frags[120] + 1;
                this.alogpfrag[i] = 120;
            }
        }
    }

    private void calcGroup118_119(int i) {
        if (!this.fragment[i].equals("SsssP")) {
            return;
        }
        List ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ai = this.atomContainer.getAtom(i);
        int xCount = 0;
        int rCount = 0;
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (this.atomContainer.getBond(ai, (IAtom)ca.get(j)).getOrder() != IBond.Order.SINGLE) continue;
            if (((IAtom)ca.get(j)).getAtomicNumber() == 6) {
                ++rCount;
                continue;
            }
            ++xCount;
        }
        if (xCount == 3) {
            this.frags[118] = this.frags[118] + 1;
            this.alogpfrag[i] = 118;
        } else if (rCount == 3) {
            this.frags[119] = this.frags[119] + 1;
            this.alogpfrag[i] = 119;
        }
    }

    private boolean inSameAromaticRing(IAtomContainer atomContainer, IAtom atom1, IAtom atom2, IRingSet rs) {
        boolean sameRing = false;
        for (int i = 0; i <= rs.getAtomContainerCount() - 1; ++i) {
            IRing r = (IRing)rs.getAtomContainer(i);
            if (!r.getFlag(32)) continue;
            boolean haveOne = false;
            boolean haveTwo = false;
            for (int j = 0; j <= r.getAtomCount() - 1; ++j) {
                if (atomContainer.indexOf(r.getAtom(j)) == atomContainer.indexOf(atom1)) {
                    haveOne = true;
                }
                if (atomContainer.indexOf(r.getAtom(j)) != atomContainer.indexOf(atom2)) continue;
                haveTwo = true;
            }
            if (!haveOne || !haveTwo) continue;
            sameRing = true;
            return sameRing;
        }
        return sameRing;
    }

    public DescriptorValue calculate(IAtomContainer container) {
        IRingSet rs;
        try {
            AllRingsFinder arf = new AllRingsFinder();
            rs = arf.findAllRings(container);
        }
        catch (Exception e) {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Could not find all rings: " + e.getMessage())));
        }
        String[] fragment = new String[container.getAtomCount()];
        EStateAtomTypeMatcher eStateMatcher = new EStateAtomTypeMatcher();
        eStateMatcher.setRingSet(rs);
        for (IAtomContainer ring : rs.atomContainers()) {
            boolean arom = true;
            for (IBond bond : ring.bonds()) {
                if (bond.isAromatic()) continue;
                arom = false;
                break;
            }
            ring.setFlag(32, arom);
        }
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtomType atomType = eStateMatcher.findMatchingAtomType(container, container.getAtom(i));
            fragment[i] = atomType == null ? null : atomType.getAtomTypeName();
        }
        double[] ret = new double[]{};
        try {
            ret = this.calculate(container, fragment, rs);
        }
        catch (CDKException e) {
            e.printStackTrace();
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException(e.getMessage())));
        }
        DoubleArrayResult results = new DoubleArrayResult();
        results.add(ret[0]);
        results.add(ret[1]);
        results.add(ret[2]);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)results, this.getDescriptorNames());
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        DoubleArrayResult results = new DoubleArrayResult();
        results.add(Double.NaN);
        results.add(Double.NaN);
        results.add(Double.NaN);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)results, this.getDescriptorNames(), e);
    }

    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(3);
    }

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#ALOGP", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public String[] getParameterNames() {
        return new String[0];
    }

    public Object getParameterType(String name) {
        return null;
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return STRINGS;
    }

    static {
        ALOGPDescriptor.FRAGVAL[1] = -1.5603;
        ALOGPDescriptor.FRAGVAL[2] = -1.012;
        ALOGPDescriptor.FRAGVAL[3] = -0.6681;
        ALOGPDescriptor.FRAGVAL[4] = -0.3698;
        ALOGPDescriptor.FRAGVAL[5] = -1.788;
        ALOGPDescriptor.FRAGVAL[6] = -1.2486;
        ALOGPDescriptor.FRAGVAL[7] = -1.0305;
        ALOGPDescriptor.FRAGVAL[8] = -0.6805;
        ALOGPDescriptor.FRAGVAL[9] = -0.3858;
        ALOGPDescriptor.FRAGVAL[10] = 0.7555;
        ALOGPDescriptor.FRAGVAL[11] = -0.2849;
        ALOGPDescriptor.FRAGVAL[12] = 0.02;
        ALOGPDescriptor.FRAGVAL[13] = 0.7894;
        ALOGPDescriptor.FRAGVAL[14] = 1.6422;
        ALOGPDescriptor.FRAGVAL[15] = -0.7866;
        ALOGPDescriptor.FRAGVAL[16] = -0.3962;
        ALOGPDescriptor.FRAGVAL[17] = 0.0383;
        ALOGPDescriptor.FRAGVAL[18] = -0.8051;
        ALOGPDescriptor.FRAGVAL[19] = -0.2129;
        ALOGPDescriptor.FRAGVAL[20] = 0.2432;
        ALOGPDescriptor.FRAGVAL[21] = 0.4697;
        ALOGPDescriptor.FRAGVAL[22] = 0.2952;
        ALOGPDescriptor.FRAGVAL[23] = 0.0;
        ALOGPDescriptor.FRAGVAL[24] = -0.3251;
        ALOGPDescriptor.FRAGVAL[25] = 0.1492;
        ALOGPDescriptor.FRAGVAL[26] = 0.1539;
        ALOGPDescriptor.FRAGVAL[27] = 5.0E-4;
        ALOGPDescriptor.FRAGVAL[28] = 0.2361;
        ALOGPDescriptor.FRAGVAL[29] = 0.3514;
        ALOGPDescriptor.FRAGVAL[30] = 0.1814;
        ALOGPDescriptor.FRAGVAL[31] = 0.0901;
        ALOGPDescriptor.FRAGVAL[32] = 0.5142;
        ALOGPDescriptor.FRAGVAL[33] = -0.3723;
        ALOGPDescriptor.FRAGVAL[34] = 0.2813;
        ALOGPDescriptor.FRAGVAL[35] = 0.1191;
        ALOGPDescriptor.FRAGVAL[36] = -0.132;
        ALOGPDescriptor.FRAGVAL[37] = -0.0244;
        ALOGPDescriptor.FRAGVAL[38] = -0.2405;
        ALOGPDescriptor.FRAGVAL[39] = -0.0909;
        ALOGPDescriptor.FRAGVAL[40] = -0.1002;
        ALOGPDescriptor.FRAGVAL[41] = 0.4182;
        ALOGPDescriptor.FRAGVAL[42] = -0.2147;
        ALOGPDescriptor.FRAGVAL[43] = -9.0E-4;
        ALOGPDescriptor.FRAGVAL[44] = 0.1388;
        ALOGPDescriptor.FRAGVAL[45] = 0.0;
        ALOGPDescriptor.FRAGVAL[46] = 0.7341;
        ALOGPDescriptor.FRAGVAL[47] = 0.6301;
        ALOGPDescriptor.FRAGVAL[48] = 0.518;
        ALOGPDescriptor.FRAGVAL[49] = -0.0371;
        ALOGPDescriptor.FRAGVAL[50] = -0.1036;
        ALOGPDescriptor.FRAGVAL[51] = 0.5234;
        ALOGPDescriptor.FRAGVAL[52] = 0.6666;
        ALOGPDescriptor.FRAGVAL[53] = 0.5372;
        ALOGPDescriptor.FRAGVAL[54] = 0.6338;
        ALOGPDescriptor.FRAGVAL[55] = 0.362;
        ALOGPDescriptor.FRAGVAL[56] = -0.3567;
        ALOGPDescriptor.FRAGVAL[57] = -0.0127;
        ALOGPDescriptor.FRAGVAL[58] = -0.0233;
        ALOGPDescriptor.FRAGVAL[59] = -0.1541;
        ALOGPDescriptor.FRAGVAL[60] = 0.0324;
        ALOGPDescriptor.FRAGVAL[61] = 1.052;
        ALOGPDescriptor.FRAGVAL[62] = -0.7941;
        ALOGPDescriptor.FRAGVAL[63] = 0.4165;
        ALOGPDescriptor.FRAGVAL[64] = 0.6601;
        ALOGPDescriptor.FRAGVAL[65] = 0.0;
        ALOGPDescriptor.FRAGVAL[66] = -0.5427;
        ALOGPDescriptor.FRAGVAL[67] = -0.3168;
        ALOGPDescriptor.FRAGVAL[68] = 0.0132;
        ALOGPDescriptor.FRAGVAL[69] = -0.3883;
        ALOGPDescriptor.FRAGVAL[70] = -0.0389;
        ALOGPDescriptor.FRAGVAL[71] = 0.1087;
        ALOGPDescriptor.FRAGVAL[72] = -0.5113;
        ALOGPDescriptor.FRAGVAL[73] = 0.1259;
        ALOGPDescriptor.FRAGVAL[74] = 0.1349;
        ALOGPDescriptor.FRAGVAL[75] = -0.1624;
        ALOGPDescriptor.FRAGVAL[76] = -2.0585;
        ALOGPDescriptor.FRAGVAL[77] = -1.915;
        ALOGPDescriptor.FRAGVAL[78] = 0.4208;
        ALOGPDescriptor.FRAGVAL[79] = -1.4439;
        ALOGPDescriptor.FRAGVAL[80] = 0.0;
        ALOGPDescriptor.FRAGVAL[81] = 0.4797;
        ALOGPDescriptor.FRAGVAL[82] = 0.2358;
        ALOGPDescriptor.FRAGVAL[83] = 0.1029;
        ALOGPDescriptor.FRAGVAL[84] = 0.3566;
        ALOGPDescriptor.FRAGVAL[85] = 0.1988;
        ALOGPDescriptor.FRAGVAL[86] = 0.7443;
        ALOGPDescriptor.FRAGVAL[87] = 0.5337;
        ALOGPDescriptor.FRAGVAL[88] = 0.2996;
        ALOGPDescriptor.FRAGVAL[89] = 0.8155;
        ALOGPDescriptor.FRAGVAL[90] = 0.4856;
        ALOGPDescriptor.FRAGVAL[91] = 0.8888;
        ALOGPDescriptor.FRAGVAL[92] = 0.7452;
        ALOGPDescriptor.FRAGVAL[93] = 0.5034;
        ALOGPDescriptor.FRAGVAL[94] = 0.8995;
        ALOGPDescriptor.FRAGVAL[95] = 0.5946;
        ALOGPDescriptor.FRAGVAL[96] = 1.4201;
        ALOGPDescriptor.FRAGVAL[97] = 1.1472;
        ALOGPDescriptor.FRAGVAL[98] = 0.0;
        ALOGPDescriptor.FRAGVAL[99] = 0.7293;
        ALOGPDescriptor.FRAGVAL[100] = 0.7173;
        ALOGPDescriptor.FRAGVAL[101] = 0.0;
        ALOGPDescriptor.FRAGVAL[102] = -2.6737;
        ALOGPDescriptor.FRAGVAL[103] = -2.4178;
        ALOGPDescriptor.FRAGVAL[104] = -3.1121;
        ALOGPDescriptor.FRAGVAL[105] = 0.0;
        ALOGPDescriptor.FRAGVAL[106] = 0.6146;
        ALOGPDescriptor.FRAGVAL[107] = 0.5906;
        ALOGPDescriptor.FRAGVAL[108] = 0.8758;
        ALOGPDescriptor.FRAGVAL[109] = -0.4979;
        ALOGPDescriptor.FRAGVAL[110] = -0.3786;
        ALOGPDescriptor.FRAGVAL[111] = 1.5188;
        ALOGPDescriptor.FRAGVAL[112] = 1.0255;
        ALOGPDescriptor.FRAGVAL[113] = 0.0;
        ALOGPDescriptor.FRAGVAL[114] = 0.0;
        ALOGPDescriptor.FRAGVAL[115] = 0.0;
        ALOGPDescriptor.FRAGVAL[116] = -0.9359;
        ALOGPDescriptor.FRAGVAL[117] = -0.1726;
        ALOGPDescriptor.FRAGVAL[118] = -0.7966;
        ALOGPDescriptor.FRAGVAL[119] = 0.6705;
        ALOGPDescriptor.FRAGVAL[120] = -0.4801;
        REFRACVAL = new double[121];
        ALOGPDescriptor.REFRACVAL[1] = 2.968;
        ALOGPDescriptor.REFRACVAL[2] = 2.9116;
        ALOGPDescriptor.REFRACVAL[3] = 2.8028;
        ALOGPDescriptor.REFRACVAL[4] = 2.6205;
        ALOGPDescriptor.REFRACVAL[5] = 3.015;
        ALOGPDescriptor.REFRACVAL[6] = 2.9244;
        ALOGPDescriptor.REFRACVAL[7] = 2.6329;
        ALOGPDescriptor.REFRACVAL[8] = 2.504;
        ALOGPDescriptor.REFRACVAL[9] = 2.377;
        ALOGPDescriptor.REFRACVAL[10] = 2.5559;
        ALOGPDescriptor.REFRACVAL[11] = 2.303;
        ALOGPDescriptor.REFRACVAL[12] = 2.3006;
        ALOGPDescriptor.REFRACVAL[13] = 2.9627;
        ALOGPDescriptor.REFRACVAL[14] = 2.3038;
        ALOGPDescriptor.REFRACVAL[15] = 3.2001;
        ALOGPDescriptor.REFRACVAL[16] = 4.2654;
        ALOGPDescriptor.REFRACVAL[17] = 3.9392;
        ALOGPDescriptor.REFRACVAL[18] = 3.6005;
        ALOGPDescriptor.REFRACVAL[19] = 4.487;
        ALOGPDescriptor.REFRACVAL[20] = 3.2001;
        ALOGPDescriptor.REFRACVAL[21] = 3.4825;
        ALOGPDescriptor.REFRACVAL[22] = 4.2817;
        ALOGPDescriptor.REFRACVAL[23] = 3.9556;
        ALOGPDescriptor.REFRACVAL[24] = 3.4491;
        ALOGPDescriptor.REFRACVAL[25] = 3.8821;
        ALOGPDescriptor.REFRACVAL[26] = 3.7593;
        ALOGPDescriptor.REFRACVAL[27] = 2.5009;
        ALOGPDescriptor.REFRACVAL[28] = 2.5;
        ALOGPDescriptor.REFRACVAL[29] = 3.0627;
        ALOGPDescriptor.REFRACVAL[30] = 2.5009;
        ALOGPDescriptor.REFRACVAL[31] = 0.0;
        ALOGPDescriptor.REFRACVAL[32] = 2.6632;
        ALOGPDescriptor.REFRACVAL[33] = 3.4671;
        ALOGPDescriptor.REFRACVAL[34] = 3.6842;
        ALOGPDescriptor.REFRACVAL[35] = 2.9372;
        ALOGPDescriptor.REFRACVAL[36] = 4.019;
        ALOGPDescriptor.REFRACVAL[37] = 4.777;
        ALOGPDescriptor.REFRACVAL[38] = 3.9031;
        ALOGPDescriptor.REFRACVAL[39] = 3.9964;
        ALOGPDescriptor.REFRACVAL[40] = 3.4986;
        ALOGPDescriptor.REFRACVAL[41] = 3.4997;
        ALOGPDescriptor.REFRACVAL[42] = 2.7784;
        ALOGPDescriptor.REFRACVAL[43] = 2.6267;
        ALOGPDescriptor.REFRACVAL[44] = 2.5;
        ALOGPDescriptor.REFRACVAL[45] = 0.0;
        ALOGPDescriptor.REFRACVAL[46] = 0.8447;
        ALOGPDescriptor.REFRACVAL[47] = 0.8939;
        ALOGPDescriptor.REFRACVAL[48] = 0.8005;
        ALOGPDescriptor.REFRACVAL[49] = 0.832;
        ALOGPDescriptor.REFRACVAL[50] = 0.8;
        ALOGPDescriptor.REFRACVAL[51] = 0.8188;
        ALOGPDescriptor.REFRACVAL[52] = 0.9215;
        ALOGPDescriptor.REFRACVAL[53] = 0.9769;
        ALOGPDescriptor.REFRACVAL[54] = 0.7701;
        ALOGPDescriptor.REFRACVAL[55] = 0.0;
        ALOGPDescriptor.REFRACVAL[56] = 1.7646;
        ALOGPDescriptor.REFRACVAL[57] = 1.4778;
        ALOGPDescriptor.REFRACVAL[58] = 1.4429;
        ALOGPDescriptor.REFRACVAL[59] = 1.6191;
        ALOGPDescriptor.REFRACVAL[60] = 1.3502;
        ALOGPDescriptor.REFRACVAL[61] = 1.945;
        ALOGPDescriptor.REFRACVAL[62] = 0.0;
        ALOGPDescriptor.REFRACVAL[63] = 0.0;
        ALOGPDescriptor.REFRACVAL[64] = 11.1366;
        ALOGPDescriptor.REFRACVAL[65] = 13.1149;
        ALOGPDescriptor.REFRACVAL[66] = 2.6221;
        ALOGPDescriptor.REFRACVAL[67] = 2.5;
        ALOGPDescriptor.REFRACVAL[68] = 2.898;
        ALOGPDescriptor.REFRACVAL[69] = 3.6841;
        ALOGPDescriptor.REFRACVAL[70] = 4.2808;
        ALOGPDescriptor.REFRACVAL[71] = 3.6189;
        ALOGPDescriptor.REFRACVAL[72] = 2.5;
        ALOGPDescriptor.REFRACVAL[73] = 2.7956;
        ALOGPDescriptor.REFRACVAL[74] = 2.7;
        ALOGPDescriptor.REFRACVAL[75] = 4.2063;
        ALOGPDescriptor.REFRACVAL[76] = 4.0184;
        ALOGPDescriptor.REFRACVAL[77] = 3.0009;
        ALOGPDescriptor.REFRACVAL[78] = 4.7142;
        ALOGPDescriptor.REFRACVAL[79] = 0.0;
        ALOGPDescriptor.REFRACVAL[80] = 0.0;
        ALOGPDescriptor.REFRACVAL[81] = 0.8725;
        ALOGPDescriptor.REFRACVAL[82] = 1.1837;
        ALOGPDescriptor.REFRACVAL[83] = 1.1573;
        ALOGPDescriptor.REFRACVAL[84] = 0.8001;
        ALOGPDescriptor.REFRACVAL[85] = 1.5013;
        ALOGPDescriptor.REFRACVAL[86] = 5.6156;
        ALOGPDescriptor.REFRACVAL[87] = 6.1022;
        ALOGPDescriptor.REFRACVAL[88] = 5.9921;
        ALOGPDescriptor.REFRACVAL[89] = 5.3885;
        ALOGPDescriptor.REFRACVAL[90] = 6.1363;
        ALOGPDescriptor.REFRACVAL[91] = 8.5991;
        ALOGPDescriptor.REFRACVAL[92] = 8.9188;
        ALOGPDescriptor.REFRACVAL[93] = 8.8006;
        ALOGPDescriptor.REFRACVAL[94] = 8.2065;
        ALOGPDescriptor.REFRACVAL[95] = 8.7352;
        ALOGPDescriptor.REFRACVAL[96] = 13.9462;
        ALOGPDescriptor.REFRACVAL[97] = 14.0792;
        ALOGPDescriptor.REFRACVAL[98] = 14.073;
        ALOGPDescriptor.REFRACVAL[99] = 12.9918;
        ALOGPDescriptor.REFRACVAL[100] = 13.3408;
        ALOGPDescriptor.REFRACVAL[101] = 0.0;
        ALOGPDescriptor.REFRACVAL[102] = 0.0;
        ALOGPDescriptor.REFRACVAL[103] = 0.0;
        ALOGPDescriptor.REFRACVAL[104] = 0.0;
        ALOGPDescriptor.REFRACVAL[105] = 0.0;
        ALOGPDescriptor.REFRACVAL[106] = 7.8916;
        ALOGPDescriptor.REFRACVAL[107] = 7.7935;
        ALOGPDescriptor.REFRACVAL[108] = 9.4338;
        ALOGPDescriptor.REFRACVAL[109] = 7.7223;
        ALOGPDescriptor.REFRACVAL[110] = 5.7558;
        ALOGPDescriptor.REFRACVAL[111] = 0.0;
        ALOGPDescriptor.REFRACVAL[112] = 0.0;
        ALOGPDescriptor.REFRACVAL[113] = 0.0;
        ALOGPDescriptor.REFRACVAL[114] = 0.0;
        ALOGPDescriptor.REFRACVAL[115] = 0.0;
        ALOGPDescriptor.REFRACVAL[116] = 5.5306;
        ALOGPDescriptor.REFRACVAL[117] = 5.5152;
        ALOGPDescriptor.REFRACVAL[118] = 6.836;
        ALOGPDescriptor.REFRACVAL[119] = 10.0101;
        ALOGPDescriptor.REFRACVAL[120] = 5.2806;
        STRINGS = new String[]{"ALogP", "ALogp2", "AMR"};
    }
}

