/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.surface;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.surface.NeighborList;
import org.openscience.cdk.geometry.surface.Tessellate;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class NumericalSurface {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(NumericalSurface.class);
    double solventRadius = 1.4;
    int tesslevel = 4;
    IAtom[] atoms;
    List<Point3d>[] surfPoints;
    double[] areas;
    double[] volumes;

    public NumericalSurface(IAtomContainer atomContainer) {
        this.atoms = AtomContainerManipulator.getAtomArray((IAtomContainer)atomContainer);
        this.init();
    }

    public NumericalSurface(IAtomContainer atomContainer, double solventRadius, int tesslevel) {
        this.solventRadius = solventRadius;
        this.atoms = AtomContainerManipulator.getAtomArray((IAtomContainer)atomContainer);
        this.tesslevel = tesslevel;
        this.init();
    }

    @Deprecated
    public void calculateSurface() {
    }

    private void init() {
        for (IAtom iAtom : this.atoms) {
            if (iAtom.getPoint3d() != null) continue;
            throw new IllegalArgumentException("One or more atoms had no 3D coordinate set");
        }
        Point3d cp = new Point3d(0.0, 0.0, 0.0);
        double maxRadius = 0.0;
        for (IAtom atom : this.atoms) {
            double vdwr = PeriodicTable.getVdwRadius((String)atom.getSymbol());
            if (vdwr + this.solventRadius > maxRadius) {
                maxRadius = PeriodicTable.getVdwRadius((String)atom.getSymbol()) + this.solventRadius;
            }
            cp.x += atom.getPoint3d().x;
            cp.y += atom.getPoint3d().y;
            cp.z += atom.getPoint3d().z;
        }
        cp.x /= (double)this.atoms.length;
        cp.y /= (double)this.atoms.length;
        cp.z /= (double)this.atoms.length;
        Tessellate tessellate = new Tessellate("ico", this.tesslevel);
        tessellate.doTessellate();
        logger.info((Object)("Got tesselation, number of triangles = " + tessellate.getNumberOfTriangles()));
        NeighborList nbrlist = new NeighborList(this.atoms, maxRadius + this.solventRadius);
        logger.info((Object)"Got neighbor list");
        this.surfPoints = new List[this.atoms.length];
        this.areas = new double[this.atoms.length];
        this.volumes = new double[this.atoms.length];
        for (int i = 0; i < this.atoms.length; ++i) {
            int pointDensity = tessellate.getNumberOfTriangles() * 3;
            Point3d[][] points = this.atomicSurfacePoints(nbrlist, i, this.atoms[i], tessellate);
            this.translatePoints(i, points, pointDensity, this.atoms[i], cp);
        }
        logger.info((Object)"Obtained points, areas and volumes");
    }

    public Point3d[] getAllSurfacePoints() {
        int npt = 0;
        for (List<Point3d> surfPoint : this.surfPoints) {
            npt += surfPoint.size();
        }
        Point3d[] ret = new Point3d[npt];
        int j = 0;
        for (List<Point3d> points : this.surfPoints) {
            for (Point3d p : points) {
                ret[j++] = p;
            }
        }
        return ret;
    }

    public Map<IAtom, List<Point3d>> getAtomSurfaceMap() {
        HashMap<IAtom, List<Point3d>> map = new HashMap<IAtom, List<Point3d>>();
        for (int i = 0; i < this.surfPoints.length; ++i) {
            if (this.surfPoints[i].isEmpty()) continue;
            map.put(this.atoms[i], Collections.unmodifiableList(this.surfPoints[i]));
        }
        return map;
    }

    public Point3d[] getSurfacePoints(int atomIdx) throws CDKException {
        if (atomIdx >= this.surfPoints.length) {
            throw new CDKException("Atom index was out of bounds");
        }
        return this.surfPoints[atomIdx].toArray(new Point3d[0]);
    }

    public double getSurfaceArea(int atomIdx) throws CDKException {
        if (atomIdx >= this.surfPoints.length) {
            throw new CDKException("Atom index was out of bounds");
        }
        return this.areas[atomIdx];
    }

    public double[] getAllSurfaceAreas() {
        return this.areas;
    }

    public double getTotalSurfaceArea() {
        double ta = 0.0;
        for (double area : this.areas) {
            ta += area;
        }
        return ta;
    }

    private void translatePoints(int atmIdx, Point3d[][] points, int pointDensity, IAtom atom, Point3d cp) {
        double totalRadius = PeriodicTable.getVdwRadius((String)atom.getSymbol()) + this.solventRadius;
        double area = Math.PI * 4 * (totalRadius * totalRadius) * (double)points.length / (double)pointDensity;
        double sumx = 0.0;
        double sumy = 0.0;
        double sumz = 0.0;
        for (Point3d[] point : points) {
            Point3d p = point[1];
            sumx += p.x;
            sumy += p.y;
            sumz += p.z;
        }
        double vconst = 4.1887902047863905 / (double)pointDensity;
        double dotp1 = (atom.getPoint3d().x - cp.x) * sumx + (atom.getPoint3d().y - cp.y) * sumy + (atom.getPoint3d().z - cp.z) * sumz;
        double volume = vconst * (totalRadius * totalRadius) * dotp1 + totalRadius * totalRadius * totalRadius * (double)points.length;
        this.areas[atmIdx] = area;
        this.volumes[atmIdx] = volume;
        ArrayList<Point3d> tmp = new ArrayList<Point3d>();
        for (Point3d[] point : points) {
            tmp.add(point[0]);
        }
        this.surfPoints[atmIdx] = tmp;
    }

    private Point3d[][] atomicSurfacePoints(NeighborList nbrlist, int currAtomIdx, IAtom atom, Tessellate tess) {
        double totalRadius = PeriodicTable.getVdwRadius((String)atom.getSymbol()) + this.solventRadius;
        double totalRadius2 = totalRadius * totalRadius;
        double twiceTotalRadius = 2.0 * totalRadius;
        int[] nlist = nbrlist.getNeighbors(currAtomIdx);
        double[][] data = new double[nlist.length][4];
        for (int i = 0; i < nlist.length; ++i) {
            double x12 = this.atoms[nlist[i]].getPoint3d().x - atom.getPoint3d().x;
            double y12 = this.atoms[nlist[i]].getPoint3d().y - atom.getPoint3d().y;
            double z12 = this.atoms[nlist[i]].getPoint3d().z - atom.getPoint3d().z;
            double d2 = x12 * x12 + y12 * y12 + z12 * z12;
            double tmp = PeriodicTable.getVdwRadius((String)this.atoms[nlist[i]].getSymbol()) + this.solventRadius;
            tmp *= tmp;
            double thresh = (d2 + totalRadius2 - tmp) / twiceTotalRadius;
            data[i][0] = x12;
            data[i][1] = y12;
            data[i][2] = z12;
            data[i][3] = thresh;
        }
        Point3d[] tessPoints = tess.getTessAsPoint3ds();
        ArrayList<Point3d[]> points = new ArrayList<Point3d[]>();
        for (Point3d pt : tessPoints) {
            boolean buried = false;
            for (double[] datum : data) {
                if (!(datum[0] * pt.x + datum[1] * pt.y + datum[2] * pt.z > datum[3])) continue;
                buried = true;
                break;
            }
            if (buried) continue;
            Point3d[] tmp = new Point3d[]{new Point3d(totalRadius * pt.x + atom.getPoint3d().x, totalRadius * pt.y + atom.getPoint3d().y, totalRadius * pt.z + atom.getPoint3d().z), pt};
            points.add(tmp);
        }
        Point3d[][] ret = new Point3d[points.size()][2];
        for (int i = 0; i < points.size(); ++i) {
            Point3d[] tmp = (Point3d[])points.get(i);
            ret[i][0] = tmp[0];
            ret[i][1] = tmp[1];
        }
        return ret;
    }
}

