/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.text.PlainTextVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class RemoveUnusedProperties
extends ScanningRecipe<Accumulator> {
    @Option(displayName="Property pattern", description="A pattern to filter properties to remove. Defaults to `.+?` to match anything", required=false, example=".+\\.version")
    private final @Nullable String propertyPattern;

    public String getDisplayName() {
        return "Remove unused properties";
    }

    public String getDescription() {
        return "Detect and remove Maven property declarations which do not have any usage within the project.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    private String getPropertyPattern() {
        return this.propertyPattern != null ? this.propertyPattern : ".+?";
    }

    public TreeVisitor<?, ExecutionContext> getScanner(Accumulator acc) {
        String patternOrDefault = this.getPropertyPattern();
        final FindPomUsagesVisitor findPomUsagesVisitor = new FindPomUsagesVisitor(RemoveUnusedProperties.dollarPropertyMatcher(patternOrDefault), acc);
        final FindFilteredResourcePathsVisitor findFilteredResourcePathsVisitor = new FindFilteredResourcePathsVisitor(acc);
        final FindResourceUsagesVisitor findResourceUsagesVisitor = new FindResourceUsagesVisitor(patternOrDefault, acc);
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof Quark || tree instanceof Remote || tree instanceof Binary) {
                    return tree;
                }
                if (tree instanceof SourceFile) {
                    SourceFile sf = (SourceFile)tree;
                    if (findPomUsagesVisitor.isAcceptable(sf, ctx)) {
                        findPomUsagesVisitor.visit((Tree)sf, ctx);
                        findFilteredResourcePathsVisitor.visit((Tree)sf, ctx);
                    } else if (!(tree instanceof JavaSourceFile)) {
                        findResourceUsagesVisitor.visit((Tree)PlainTextParser.convert((SourceFile)sf), (Object)ctx);
                    }
                }
                return tree;
            }
        };
    }

    private static Pattern dollarPropertyMatcher(String patternOrDefault) {
        return Pattern.compile("[^$]*\\$\\{(" + patternOrDefault + ")}[^$]*");
    }

    private static Pattern atPropertyMatcher(String patternOrDefault) {
        return Pattern.compile("@(" + patternOrDefault + ")@");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        final Pattern propertyMatcher = Pattern.compile(this.getPropertyPattern());
        final Map<String, Set<MavenResolutionResult>> filteredResourceUsages = acc.getFilteredResourceUsages();
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                String propertyName = t.getName();
                if (this.isPropertyTag() && propertyMatcher.matcher(propertyName).matches()) {
                    if (this.isMavenBuiltinProperty(propertyName)) {
                        return t;
                    }
                    if (this.parentHasProperty(this.getResolutionResult(), propertyName, ctx)) {
                        return t;
                    }
                    if (acc.propertiesToUsingPoms.containsKey(propertyName)) {
                        for (MavenResolutionResult pomWhereUsed : acc.propertiesToUsingPoms.get(propertyName)) {
                            if (!this.isAncestor(pomWhereUsed, this.getResolutionResult().getPom().getGav())) continue;
                            return t;
                        }
                    }
                    if (filteredResourceUsages.containsKey(propertyName)) {
                        for (MavenResolutionResult pomWhereUsed : (Set)filteredResourceUsages.get(propertyName)) {
                            if (!this.isAncestor(pomWhereUsed, this.getResolutionResult().getPom().getGav())) continue;
                            return t;
                        }
                    }
                    this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)tag, true, true));
                    this.maybeUpdateModel();
                }
                return t;
            }

            private boolean isMavenBuiltinProperty(String propertyName) {
                return propertyName.startsWith("project.") || propertyName.startsWith("maven.");
            }

            private boolean isAncestor(MavenResolutionResult project, ResolvedGroupArtifactVersion possibleAncestorGav) {
                for (MavenResolutionResult projectAncestor = project; projectAncestor != null; projectAncestor = projectAncestor.getParent()) {
                    if (!projectAncestor.getPom().getGav().equals(possibleAncestorGav)) continue;
                    return true;
                }
                return false;
            }

            private boolean parentHasProperty(MavenResolutionResult resolutionResult, String propertyName, ExecutionContext ctx) {
                MavenPomDownloader downloader = new MavenPomDownloader(resolutionResult.getProjectPoms(), ctx, resolutionResult.getMavenSettings(), resolutionResult.getActiveProfiles());
                try {
                    ResolvedPom resolvedBarePom = resolutionResult.getPom().getRequested().withProperties(Collections.emptyMap()).withDependencies(Collections.emptyList()).withDependencyManagement(Collections.emptyList()).withPlugins(Collections.emptyList()).withPluginManagement(Collections.emptyList()).resolve(resolutionResult.getActiveProfiles(), downloader, ctx);
                    return resolvedBarePom.getProperties().containsKey(propertyName);
                }
                catch (MavenDownloadingException e) {
                    return true;
                }
            }
        };
    }

    @Generated
    public RemoveUnusedProperties(@Nullable String propertyPattern) {
        this.propertyPattern = propertyPattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveUnusedProperties(propertyPattern=" + this.getPropertyPattern() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveUnusedProperties)) {
            return false;
        }
        RemoveUnusedProperties other = (RemoveUnusedProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$propertyPattern = this.getPropertyPattern();
        String other$propertyPattern = other.getPropertyPattern();
        return !(this$propertyPattern == null ? other$propertyPattern != null : !this$propertyPattern.equals(other$propertyPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveUnusedProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $propertyPattern = this.getPropertyPattern();
        result = result * 59 + ($propertyPattern == null ? 43 : $propertyPattern.hashCode());
        return result;
    }

    public static class Accumulator {
        public Map<String, Set<MavenResolutionResult>> propertiesToUsingPoms = new HashMap<String, Set<MavenResolutionResult>>();
        public Map<Path, MavenResolutionResult> filteredResourcePathsToDeclaringPoms = new HashMap<Path, MavenResolutionResult>();
        public Map<Path, Set<String>> nonPomPathsToUsages = new HashMap<Path, Set<String>>();

        public Map<String, Set<MavenResolutionResult>> getFilteredResourceUsages() {
            HashMap<String, Set<MavenResolutionResult>> result = new HashMap<String, Set<MavenResolutionResult>>();
            this.filteredResourcePathsToDeclaringPoms.forEach((filteredResourcePath, mrr) -> this.nonPomPathsToUsages.forEach((usagePath, properties) -> {
                if (usagePath.startsWith((Path)filteredResourcePath)) {
                    properties.forEach(property -> {
                        result.putIfAbsent((String)property, new HashSet());
                        ((Set)result.get(property)).add(mrr);
                    });
                }
            }));
            return result;
        }
    }

    private static class FindPomUsagesVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private final Pattern propertyUsageMatcher;
        private final Accumulator acc;

        public FindPomUsagesVisitor(Pattern propertyUsageMatcher, Accumulator acc) {
            this.propertyUsageMatcher = propertyUsageMatcher;
            this.acc = acc;
        }

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag t = super.visitTag(tag, ctx);
            Optional value = t.getValue();
            if (value.isPresent()) {
                Matcher matcher = this.propertyUsageMatcher.matcher((CharSequence)value.get());
                while (matcher.find()) {
                    this.acc.propertiesToUsingPoms.putIfAbsent(matcher.group(1), new HashSet());
                    this.acc.propertiesToUsingPoms.get(matcher.group(1)).add(this.getResolutionResult());
                }
            }
            return t;
        }
    }

    private static class FindFilteredResourcePathsVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private final XPathMatcher resourceMatcher = new XPathMatcher("/project/build/resources/resource");
        private final Accumulator acc;

        public FindFilteredResourcePathsVisitor(Accumulator acc) {
            this.acc = acc;
        }

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.resourceMatcher.matches(this.getCursor())) {
                String directory = tag.getChildValue("directory").orElse(null);
                if (tag.getChildValue("filtering").map(Boolean::valueOf).orElse(false).booleanValue() && directory != null) {
                    Path path = ((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath();
                    try {
                        this.acc.filteredResourcePathsToDeclaringPoms.put(path.getParent().resolve(directory), this.getResolutionResult());
                    }
                    catch (InvalidPathException invalidPathException) {
                        // empty catch block
                    }
                }
                return tag;
            }
            return super.visitTag(tag, ctx);
        }
    }

    private static class FindResourceUsagesVisitor
    extends PlainTextVisitor<ExecutionContext> {
        private final Pattern dollarMatcher;
        private final Pattern atMatcher;
        private final Accumulator acc;

        public FindResourceUsagesVisitor(String pattern, Accumulator acc) {
            this.dollarMatcher = RemoveUnusedProperties.dollarPropertyMatcher(pattern);
            this.atMatcher = RemoveUnusedProperties.atPropertyMatcher(pattern);
            this.acc = acc;
        }

        public PlainText visitText(PlainText text, ExecutionContext ctx) {
            Matcher matcher = this.dollarMatcher.matcher(text.getText());
            while (matcher.find()) {
                this.acc.nonPomPathsToUsages.putIfAbsent(text.getSourcePath(), new HashSet());
                this.acc.nonPomPathsToUsages.get(text.getSourcePath()).add(matcher.group(1));
            }
            matcher = this.atMatcher.matcher(text.getText());
            while (matcher.find()) {
                this.acc.nonPomPathsToUsages.putIfAbsent(text.getSourcePath(), new HashSet());
                this.acc.nonPomPathsToUsages.get(text.getSourcePath()).add(matcher.group(1));
            }
            return text;
        }
    }
}

