/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.internal.grammar.TemplateParameterLexer;
import org.openrewrite.java.internal.grammar.TemplateParameterParser;
import org.openrewrite.java.internal.template.TemplateParameter;
import org.openrewrite.java.internal.template.TypeParameter;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

class JavaTemplateSemanticallyEqual
extends SemanticallyEqual {
    JavaTemplateSemanticallyEqual() {
    }

    static TemplateMatchResult matchesTemplate(JavaTemplate template, Cursor input) {
        JavaCoordinates coordinates;
        if (input.getValue() instanceof Expression) {
            coordinates = ((Expression)input.getValue()).getCoordinates().replace();
        } else if (input.getValue() instanceof Statement) {
            coordinates = ((Statement)input.getValue()).getCoordinates().replace();
        } else {
            throw new IllegalArgumentException("Only expressions and statements can be matched against a template: " + input.getClass());
        }
        J[] parameters = JavaTemplateSemanticallyEqual.createTemplateParameters(template.getCode());
        try {
            Object templateTree = template.apply(input, coordinates, (Object[])parameters);
            return JavaTemplateSemanticallyEqual.matchTemplate(templateTree, input);
        }
        catch (RuntimeException e) {
            return new TemplateMatchResult(false, Collections.emptyList());
        }
    }

    private static J[] createTemplateParameters(String code) {
        String previous;
        PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("#{", "}", null);
        ArrayList parameters = new ArrayList();
        String substituted = code;
        HashMap typedPatternByName = new HashMap();
        while (!(previous = substituted).equals(substituted = propertyPlaceholderHelper.replacePlaceholders(substituted, key -> {
            String s;
            if (!key.isEmpty()) {
                BaseErrorListener errorListener = new BaseErrorListener(){

                    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                        throw new IllegalArgumentException(String.format("Syntax error at line %d:%d %s.", line, charPositionInLine, msg), e);
                    }
                };
                TemplateParameterLexer lexer = new TemplateParameterLexer((CharStream)CharStreams.fromString((String)key));
                lexer.removeErrorListeners();
                lexer.addErrorListener((ANTLRErrorListener)errorListener);
                TemplateParameterParser parser = new TemplateParameterParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)errorListener);
                TemplateParameterParser.MatcherPatternContext ctx = parser.matcherPattern();
                if (ctx.typedPattern() == null) {
                    String paramName = ctx.parameterName().Identifier().getText();
                    s = (String)typedPatternByName.get(paramName);
                    if (s == null) {
                        throw new IllegalArgumentException("The parameter " + paramName + " must be defined before it is referenced.");
                    }
                } else {
                    TemplateParameterParser.TypedPatternContext typedPattern = ctx.typedPattern();
                    JavaType type = JavaTemplateSemanticallyEqual.typedParameter(key, typedPattern);
                    s = TypeUtils.toString(type);
                    String name = null;
                    if (typedPattern.parameterName() != null) {
                        name = typedPattern.parameterName().Identifier().getText();
                        typedPatternByName.put(name, s);
                    }
                    Markers markers = Markers.build(Collections.singleton(new TemplateParameter(Tree.randomId(), type, name)));
                    parameters.add(new J.Empty(Tree.randomId(), Space.EMPTY, markers));
                }
            } else {
                throw new IllegalArgumentException("Only typed placeholders are allowed.");
            }
            return s;
        }))) {
        }
        return parameters.toArray(new J[0]);
    }

    private static JavaType typedParameter(String key, TemplateParameterParser.TypedPatternContext typedPattern) {
        String matcherName = typedPattern.patternType().matcherName().Identifier().getText();
        if ("any".equals(matcherName)) {
            return TypeParameter.toFullyQualifiedName(typedPattern.patternType().type());
        }
        if ("anyArray".equals(matcherName)) {
            return new JavaType.Array(null, TypeParameter.toFullyQualifiedName(typedPattern.patternType().type()), null);
        }
        throw new IllegalArgumentException("Unsupported template matcher '" + key + "'");
    }

    private static TemplateMatchResult matchTemplate(J templateTree, Cursor cursor) {
        if (templateTree == cursor.getValue()) {
            return new TemplateMatchResult(false, Collections.emptyList());
        }
        JavaTemplateSemanticallyEqualVisitor semanticallyEqualVisitor = new JavaTemplateSemanticallyEqualVisitor();
        semanticallyEqualVisitor.visit(templateTree, (J)cursor.getValue(), cursor.getParentOrThrow());
        return new TemplateMatchResult(semanticallyEqualVisitor.isEqual(), new ArrayList<J>(semanticallyEqualVisitor.matchedParameters.keySet()));
    }

    static final class TemplateMatchResult {
        private final boolean match;
        private final List<J> matchedParameters;

        @Generated
        public TemplateMatchResult(boolean match, List<J> matchedParameters) {
            this.match = match;
            this.matchedParameters = matchedParameters;
        }

        @Generated
        public boolean isMatch() {
            return this.match;
        }

        @Generated
        public List<J> getMatchedParameters() {
            return this.matchedParameters;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateMatchResult)) {
                return false;
            }
            TemplateMatchResult other = (TemplateMatchResult)o;
            if (this.isMatch() != other.isMatch()) {
                return false;
            }
            List<J> this$matchedParameters = this.getMatchedParameters();
            List<J> other$matchedParameters = other.getMatchedParameters();
            return !(this$matchedParameters == null ? other$matchedParameters != null : !((Object)this$matchedParameters).equals(other$matchedParameters));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMatch() ? 79 : 97);
            List<J> $matchedParameters = this.getMatchedParameters();
            result = result * 59 + ($matchedParameters == null ? 43 : ((Object)$matchedParameters).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JavaTemplateSemanticallyEqual.TemplateMatchResult(match=" + this.isMatch() + ", matchedParameters=" + this.getMatchedParameters() + ")";
        }
    }

    private static class JavaTemplateSemanticallyEqualVisitor
    extends SemanticallyEqual.SemanticallyEqualVisitor {
        final Map<J, String> matchedParameters = new LinkedHashMap<J, String>();

        public JavaTemplateSemanticallyEqualVisitor() {
            super(true);
        }

        private boolean matchTemplateParameterPlaceholder(J.Empty empty, J j) {
            if (j instanceof TypedTree) {
                if (j instanceof J.Primitive || j instanceof J.Identifier && ((J.Identifier)j).getFieldType() == null) {
                    return false;
                }
                TemplateParameter marker = (TemplateParameter)empty.getMarkers().getMarkers().get(0);
                if (marker.getName() != null) {
                    for (Map.Entry<J, String> matchedParameter : this.matchedParameters.entrySet()) {
                        if (!matchedParameter.getValue().equals(marker.getName())) continue;
                        return SemanticallyEqual.areEqual(matchedParameter.getKey(), j);
                    }
                }
                if (TypeUtils.isObject(marker.getType()) || TypeUtils.isAssignableTo(marker.getType(), ((TypedTree)j).getType())) {
                    this.registerMatch(j, marker.getName());
                    return true;
                }
            }
            return false;
        }

        private void registerMatch(J j, @Nullable String name) {
            this.matchedParameters.put(j, name);
        }

        @Override
        public J.Empty visitEmpty(J.Empty empty, J j) {
            if (this.isEqual.get()) {
                if (JavaTemplateSemanticallyEqualVisitor.isTemplateParameterPlaceholder(empty)) {
                    this.isEqual.set(this.matchTemplateParameterPlaceholder(empty, j));
                    return empty;
                }
                if (!(j instanceof J.Empty)) {
                    this.isEqual.set(false);
                    return empty;
                }
                J.Empty compareTo = (J.Empty)j;
                if (this.nullMissMatch(empty.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return empty;
                }
            }
            return empty;
        }

        private static boolean isTemplateParameterPlaceholder(J.Empty empty) {
            Markers markers = empty.getMarkers();
            return markers.getMarkers().size() == 1 && markers.getMarkers().get(0) instanceof TemplateParameter;
        }
    }
}

