/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication.synchro;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.FileUtil;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyLabelHelper;
import org.nuiton.wikitty.publication.PropertiesExtended;
import org.nuiton.wikitty.publication.WikittyFileUtil;
import org.nuiton.wikitty.publication.synchro.WikittyPublicationFileSystem;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;

public class WikittyPublicationSynchronize {
    private static final Log log = LogFactory.getLog(WikittyPublicationSynchronize.class);
    public static String WIKITTY_SERVICE_INTERLOCUTEUR = "wikitty.service.interlocuteur";
    protected static ApplicationConfig applicationConfig;
    public static String IS_RECURSION_OPTION;
    public static String IS_DELETE_OPTION;
    public static String IS_EXISTING_OPTION;
    public static String LABEL_KEY;
    public static String LABEL_DELIM;
    public static String LABEL_REGEX;
    public static String FILE_URI_PREFIX;
    public static String CAJO_URI_PREFIX;
    public static String HESSIAN_URI_PREFIX;
    public static String WIKITTY_FILE_SERVICE;
    protected static boolean MAIN_ENABLE;
    protected static boolean FLAG_COMMIT_UPDATE;

    private WikittyPublicationSynchronize() {
    }

    public static void main(String[] args) throws Exception {
        MAIN_ENABLE = true;
        applicationConfig.parse(args);
        applicationConfig.doAction(0);
    }

    public static void synchronisation(String origin, String target) throws URISyntaxException {
        boolean isRecur = applicationConfig.getOptionAsBoolean(IS_RECURSION_OPTION);
        boolean isDelete = applicationConfig.getOptionAsBoolean(IS_DELETE_OPTION);
        boolean isExisting = applicationConfig.getOptionAsBoolean(IS_EXISTING_OPTION);
        WikittyPublicationSynchronize.synchronisationServices(origin, target, isRecur, isDelete, isExisting);
    }

    public static void synchronisationServices(String origin, String target, boolean isRecur, boolean isDelete, boolean isExisting) throws URISyntaxException {
        boolean isUpdate = !isDelete && !isExisting;
        log.info((Object)("Sync uri origin: " + origin + " uri target: " + target + " isRecur:" + isRecur + " isUpdate:" + isUpdate + " isDelete:" + isDelete + "isExisting:" + isExisting));
        URI uriOrigin = new URI(origin);
        URI uriTarget = new URI(target);
        applicationConfig.setOption(WIKITTY_SERVICE_INTERLOCUTEUR, new String(target.replaceAll(LABEL_REGEX, "")));
        ApplicationConfig temp1 = WikittyPublicationSynchronize.setUpApplicationConfigServerConnector(uriOrigin);
        WikittyProxy proxyOrigin = new WikittyProxy(WikittyServiceFactory.buildWikittyService((ApplicationConfig)temp1));
        applicationConfig.setOption(WIKITTY_SERVICE_INTERLOCUTEUR, new String(origin.replaceAll(LABEL_REGEX, "")));
        ApplicationConfig temp2 = WikittyPublicationSynchronize.setUpApplicationConfigServerConnector(uriTarget);
        WikittyProxy proxyTarget = new WikittyProxy(WikittyServiceFactory.buildWikittyService((ApplicationConfig)temp2));
        String labelOrigin = uriOrigin.getFragment();
        String labelTarget = uriTarget.getFragment();
        Criteria critOrigin = WikittyPublicationSynchronize.constructCriteriaLabelRecur(labelOrigin, isRecur);
        Criteria critTarget = WikittyPublicationSynchronize.constructCriteriaLabelRecur(labelTarget, isRecur);
        List listOrigin = proxyOrigin.findAllIdByCriteria(critOrigin).getAll();
        List listTarget = proxyTarget.findAllIdByCriteria(critTarget).getAll();
        ArrayList existInBoth = new ArrayList();
        existInBoth.addAll(listOrigin);
        existInBoth.retainAll(listTarget);
        ArrayList existOnlyOnOrigin = new ArrayList();
        existOnlyOnOrigin.addAll(listOrigin);
        existOnlyOnOrigin.removeAll(listTarget);
        ArrayList existOnlyOnTarget = new ArrayList();
        existOnlyOnTarget.addAll(listTarget);
        existOnlyOnTarget.removeAll(listOrigin);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wikitty exist on both: " + existInBoth.size()));
            for (String ex : existInBoth) {
                log.debug((Object)ex);
            }
            log.debug((Object)("Wikitty exist only on origin: " + existOnlyOnOrigin.size()));
            for (String ex : existOnlyOnOrigin) {
                log.debug((Object)ex);
            }
            log.debug((Object)("Wikitty exist only on target: " + existOnlyOnTarget.size()));
            for (String ex : existOnlyOnTarget) {
                log.debug((Object)ex);
            }
        }
        if (isUpdate) {
            log.info((Object)"Store on target new wikitty");
            List newWikitties = proxyOrigin.restore(existOnlyOnOrigin);
            for (Wikitty wikittyNew : newWikitties) {
                Set saveLabelOrigin = WikittyLabelHelper.getLabels((Wikitty)wikittyNew);
                HashSet<String> targetLabels = new HashSet<String>();
                for (String labels : saveLabelOrigin) {
                    if (isRecur && labels.startsWith(labelOrigin)) {
                        String finalLabelTarge = new String(labels.replace(labelOrigin, labelTarget));
                        targetLabels.add(finalLabelTarge);
                        continue;
                    }
                    if (!isRecur && labels.equals(labelOrigin)) {
                        targetLabels.add(labelTarget);
                        continue;
                    }
                    targetLabels.add(labels);
                }
                String wikittyVersionLocal = wikittyNew.getVersion();
                WikittyLabelHelper.setLabels((Wikitty)wikittyNew, targetLabels);
                wikittyNew.setVersion(wikittyVersionLocal);
                proxyTarget.store(wikittyNew);
                String versionSaveTarget = wikittyNew.getVersion();
                WikittyLabelHelper.setLabels((Wikitty)wikittyNew, (Set)saveLabelOrigin);
                wikittyNew.setVersion(versionSaveTarget);
                try {
                    proxyOrigin.store(wikittyNew);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (isDelete) {
            log.info((Object)"Remove from target deleted wikitty");
            for (String id : existOnlyOnTarget) {
                Wikitty w = proxyTarget.restore(id);
                WikittyLabelHelper.removeLabels((Wikitty)w, (String)labelTarget);
                proxyTarget.store(w);
            }
        } else {
            log.info((Object)"Update existing wikitty");
            for (String id : existInBoth) {
                Wikitty fromTarget = proxyTarget.restore(id);
                Wikitty fromOrigin = proxyOrigin.restore(id);
                String versionTarget = fromTarget.getVersion();
                String versionOrigin = fromOrigin.getVersion();
                if (!WikittyUtil.versionGreaterThan((String)versionOrigin, (String)versionTarget)) continue;
                Set setLabelTarget = WikittyLabelHelper.getLabels((Wikitty)fromTarget);
                Set setLabelOrigin = WikittyLabelHelper.getLabels((Wikitty)fromOrigin);
                String versionLocalSave = fromOrigin.getVersion();
                WikittyLabelHelper.setLabels((Wikitty)fromOrigin, (Set)setLabelTarget);
                fromOrigin.setVersion(versionLocalSave);
                proxyTarget.store(fromOrigin);
                String saveVersion = fromOrigin.getVersion();
                WikittyLabelHelper.setLabels((Wikitty)fromOrigin, (Set)setLabelOrigin);
                fromOrigin.setVersion(saveVersion);
                proxyOrigin.store(fromOrigin);
            }
        }
    }

    protected static Criteria constructCriteriaLabelRecur(String label, boolean isRecur) {
        log.info((Object)("Construct criteria with label: " + label + " isRecur:" + isRecur));
        Search mainRequest = Search.query();
        Search subRoqu = mainRequest.or();
        subRoqu.exteq("WikittyPubText").exteq("WikittyPubData");
        Criteria criteriaOnLabels = isRecur ? mainRequest.exteq("WikittyLabel").sw("WikittyLabel.labels", label).criteria() : mainRequest.exteq("WikittyLabel").eq("WikittyLabel.labels", label).criteria();
        log.debug((Object)criteriaOnLabels);
        return criteriaOnLabels;
    }

    protected static ApplicationConfig setUpApplicationConfigServerConnector(URI uri) {
        log.info((Object)("Construct application config for uri: " + uri));
        ApplicationConfig result = new ApplicationConfig();
        result.setOptions(applicationConfig.getFlatOptions());
        String url = uri.toASCIIString();
        if (uri.getScheme().equals(FILE_URI_PREFIX)) {
            result.setOption(WikittyConfigOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.getKey(), WikittyPublicationFileSystem.class.getName());
            WikittyPublicationSynchronize.writeProperty(url);
        } else if (uri.getScheme().equals(CAJO_URI_PREFIX)) {
            result.setOption(WikittyConfigOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.getKey(), "org.nuiton.wikitty.services.WikittyServiceCajoClient");
            url = new String(url.replaceAll(LABEL_REGEX, ""));
        } else if (uri.getScheme().equals(HESSIAN_URI_PREFIX)) {
            result.setOption(WikittyConfigOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.getKey(), "org.nuiton.wikitty.services.WikittyServiceHessianClient");
            url = new String(url.replaceAll(LABEL_REGEX, ""));
        }
        log.info((Object)("set url " + url + " with component :" + result.getOption(WikittyConfigOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.getKey())));
        result.setOption(WikittyConfigOption.WIKITTY_SERVER_URL.getKey(), url);
        log.debug((Object)("Application config: " + result.getFlatOptions()));
        return result;
    }

    public static void update(String label, String ... uriFileSystem) throws Exception {
        WikittyPublicationSynchronize.commitUpdateDelegate(label, false, uriFileSystem);
    }

    public static void commit(String label, String ... uriFileSystem) throws Exception {
        WikittyPublicationSynchronize.commitUpdateDelegate(label, true, uriFileSystem);
    }

    protected static void commitUpdateDelegate(String label, boolean isCommit, String ... uriFileSystem) throws Exception {
        FLAG_COMMIT_UPDATE = true;
        File currentDir = new File(FileUtil.getCurrentDirectory().getAbsolutePath());
        if (isCommit) {
            log.info((Object)("Commit args.length:+" + uriFileSystem.length));
        } else {
            log.info((Object)("Update args.length:+" + uriFileSystem.length));
        }
        if (log.isDebugEnabled()) {
            for (String args : uriFileSystem) {
                log.debug((Object)args);
            }
            log.debug((Object)("Current dir:" + currentDir));
        }
        String wikittyServiceInter = "";
        String wikittyServiceFileSystem = "";
        PropertiesExtended homeProperty = null;
        switch (uriFileSystem.length) {
            case 0: {
                File homePropertyDir = WikittyPublicationSynchronize.searchWikittyPublicationHomePropertie(currentDir);
                homeProperty = WikittyPublicationFileSystem.getWikittyPublicationProperties(homePropertyDir, WIKITTY_FILE_SERVICE);
                wikittyServiceInter = homeProperty.getProperty(WIKITTY_SERVICE_INTERLOCUTEUR);
                PropertiesExtended metaPropertiesExtended = WikittyPublicationFileSystem.getWikittyPublicationProperties(currentDir, WikittyFileUtil.WIKITTY_FILE_META_PROPERTIES_FILE);
                String labelCurrent = metaPropertiesExtended.getProperty(WikittyPublicationFileSystem.META_CURRENT_LABEL);
                wikittyServiceFileSystem = "file://" + homePropertyDir.getAbsolutePath() + LABEL_DELIM + labelCurrent;
                String labelInitial = homeProperty.getProperty(LABEL_KEY);
                wikittyServiceInter = wikittyServiceInter + LABEL_DELIM + label + labelCurrent.replaceFirst(labelInitial, "");
                break;
            }
            case 1: {
                wikittyServiceFileSystem = uriFileSystem[0];
                URI originUri = new URI(wikittyServiceFileSystem);
                if (!originUri.getScheme().equals(FILE_URI_PREFIX)) {
                    // empty if block
                }
                File workingDir = new File(originUri.getPath());
                homeProperty = WikittyPublicationFileSystem.getWikittyPublicationProperties(workingDir, WIKITTY_FILE_SERVICE);
                wikittyServiceInter = (String)homeProperty.get(WIKITTY_SERVICE_INTERLOCUTEUR);
                String labelInitial = homeProperty.getProperty(LABEL_KEY);
                wikittyServiceInter = wikittyServiceInter + LABEL_DELIM + label + originUri.getFragment().replaceFirst(labelInitial, "");
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("homeProperty :" + homeProperty.getOrigin()));
            for (Map.Entry<Object, Object> ee : homeProperty.entrySet()) {
                log.debug((Object)(ee.getKey() + "=" + ee.getValue()));
            }
            log.debug((Object)("wikitty Inter:" + wikittyServiceInter + " wikittyFileSystem" + wikittyServiceFileSystem));
        }
        if (isCommit) {
            WikittyPublicationSynchronize.synchronisation(wikittyServiceFileSystem, wikittyServiceInter);
        } else {
            WikittyPublicationSynchronize.synchronisation(wikittyServiceInter, wikittyServiceFileSystem);
        }
    }

    public static void usage() {
        System.out.println("");
        String usage = "Usage\n''wp sync [--norecursion] [--delete|--existing] [URI origin] [URI target]''\n \nwith URI :\nfile:///truc/machin/#label\nhessian://www.adresse.com:8827/etc/etc#label\ncajo://www.adresse.com:8827/etc/etc#label \n\n or: \n''wp [update|commit] [--norecursion] [--delete|--existing] [URI file]''";
        System.out.println(usage);
    }

    protected static void writeProperty(String ur) {
        block6: {
            if (!FLAG_COMMIT_UPDATE && MAIN_ENABLE) {
                try {
                    String uriService;
                    PropertiesExtended propertyWikittyService;
                    URI uri = new URI(ur);
                    String label = uri.getFragment();
                    File homeFile = new File(uri.getPath());
                    File homeProperty = new File(homeFile.getAbsolutePath() + File.separator + WikittyPublicationFileSystem.PROPERTY_DIRECTORY);
                    if (!homeProperty.exists()) {
                        homeProperty.mkdir();
                    }
                    if (!(propertyWikittyService = WikittyPublicationFileSystem.getWikittyPublicationProperties(homeFile, WIKITTY_FILE_SERVICE)).containsKey(LABEL_KEY)) {
                        log.debug((Object)("Writing home property label" + propertyWikittyService.getOrigin()));
                        propertyWikittyService.setProperty(LABEL_KEY, label);
                    }
                    if ((uriService = applicationConfig.getOption(WIKITTY_SERVICE_INTERLOCUTEUR)) != null) {
                        log.debug((Object)("Writing home property service on:" + propertyWikittyService.getOrigin() + " uri" + uriService));
                        propertyWikittyService.setProperty(WIKITTY_SERVICE_INTERLOCUTEUR, uriService);
                    }
                    propertyWikittyService.store();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)"Error while writing properties for commit update", (Throwable)e);
                }
            }
        }
    }

    public static File searchWikittyPublicationHomePropertie(File start) throws IOException {
        log.info((Object)("Search for home propertie from :" + start));
        if (start != null && start.exists() && start.isDirectory()) {
            File propertie;
            File propertyDirectory = new File(start.getCanonicalPath() + File.separator + WikittyPublicationFileSystem.PROPERTY_DIRECTORY);
            if (propertyDirectory.exists() && (propertie = new File(propertyDirectory.getCanonicalPath() + File.separator + WIKITTY_FILE_SERVICE)).exists()) {
                return start;
            }
            return WikittyPublicationSynchronize.searchWikittyPublicationHomePropertie(start.getParentFile());
        }
        if (start == null) {
            throw new IOException("Start cannot be null");
        }
        if (!start.exists()) {
            throw new IOException(start + " doen't exist");
        }
        throw new IOException(start + " is not a directory");
    }

    static {
        IS_RECURSION_OPTION = "isRecur";
        IS_DELETE_OPTION = "delete";
        IS_EXISTING_OPTION = "existing";
        LABEL_KEY = "working.label";
        LABEL_DELIM = "#";
        LABEL_REGEX = "\\#.*";
        FILE_URI_PREFIX = "file";
        CAJO_URI_PREFIX = "cajo";
        HESSIAN_URI_PREFIX = "hessian";
        WIKITTY_FILE_SERVICE = "ws.properties";
        MAIN_ENABLE = false;
        FLAG_COMMIT_UPDATE = false;
        applicationConfig = new ApplicationConfig();
        FileUtil.ENCODING = "UTF-8";
        applicationConfig.setDefaultOption(IS_DELETE_OPTION, "false");
        applicationConfig.setDefaultOption(IS_EXISTING_OPTION, "false");
        applicationConfig.setDefaultOption(IS_RECURSION_OPTION, "true");
        applicationConfig.addAlias("--norecursion", new String[]{"--option", IS_RECURSION_OPTION, "false"});
        applicationConfig.addAlias("--delete", new String[]{"--option", IS_DELETE_OPTION, "true"});
        applicationConfig.addAlias("--existing", new String[]{"--option", IS_EXISTING_OPTION, "true"});
        applicationConfig.addAlias("wp sync", new String[]{"--option", "sync"});
        applicationConfig.addAlias("wp commit", new String[]{"--option", "commit"});
        applicationConfig.addAlias("wp update", new String[]{"--option", "update"});
        applicationConfig.addActionAlias("sync", "org.nuiton.wikitty.publication.synchro.WikittyPublication#synchronisation");
        applicationConfig.addActionAlias("commit", "org.nuiton.wikitty.publication.synchro.WikittyPublication#commit");
        applicationConfig.addActionAlias("update", "org.nuiton.wikitty.publication.synchro.WikittyPublication#update");
    }
}

