/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.publication.AbstractAction;
import org.nuiton.wikitty.publication.ActionError;
import org.nuiton.wikitty.publication.WikittyPublicationContext;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;

public class ActionView
extends AbstractAction {
    private static Log log = LogFactory.getLog(ActionError.class);
    protected ApplicationConfig appConfig;

    public ActionView(ApplicationConfig appConfig) {
        this.appConfig = appConfig;
    }

    public Object doAction(WikittyPublicationContext context) {
        WikittyProxy proxy = context.getWikittyProxy();
        String r = (String)context.getArguments().get("r");
        if (r == null || "".equals(r)) {
            r = "*";
        }
        String first = context.getArgument("first", "0");
        String end = context.getArgument("end", "100");
        int firstIndex = StringUtil.toInt((String)first);
        int endIndex = StringUtil.toInt((String)end);
        Criteria criteria = Search.query().keyword(r).criteria();
        criteria.setFirstIndex(firstIndex);
        criteria.setEndIndex(endIndex);
        PagedResult pagedResult = proxy.findAllByCriteria(criteria);
        String id = (String)context.getArguments().get("id");
        Wikitty w = proxy.restore(id);
        context.setContentType("forward/jsp");
        context.getRequest().setAttribute("wpContext", (Object)context);
        context.getRequest().setAttribute("wpWikitty", (Object)w);
        context.getRequest().setAttribute("pagedResult", (Object)pagedResult);
        String result = "/WEB-INF/jsp/view.jsp";
        return result;
    }

    public static String makeUrl(WikittyPublicationContext context, Wikitty w) {
        String url = context.getActionName() + "/" + Element.ELT_ID + "=" + w.getId();
        url = context.makeUrl(url);
        return url;
    }
}

