package org.nuiton.topia.security.entities.user;

import java.util.Collection;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.security.listener.NoSecurityLoad;

@SearchFields (
  txtFields={TopiaUser.LOGIN, TopiaUser.EMAIL, TopiaUser.PASSWORD, TopiaUser.NOTE, TopiaUser.LINK_APPLICATION}
)

public interface TopiaUser extends NoSecurityLoad, TopiaEntity {     String LOGIN = "login";
     String EMAIL = "email";
     String PASSWORD = "password";
     String NOTE = "note";
     String LINK_APPLICATION = "linkApplication";
     String TOPIA_GROUP = "topiaGroup";
    /**
     * setLogin :
     * @param login La valeur de l'attribut login à positionner.
     */

     void setLogin(String login);

    /**
     * getLogin :
     * @return String 
     */

     String getLogin();

    /**
     * setEmail :
     * @param email La valeur de l'attribut email à positionner.
     */

     void setEmail(String email);

    /**
     * getEmail :
     * @return String 
     */

     String getEmail();

    /**
     * setPassword :
     * @param password La valeur de l'attribut password à positionner.
     */

     void setPassword(String password);

    /**
     * getPassword :
     * @return String 
     */

     String getPassword();

    /**
     * setNote :
     * @param note La valeur de l'attribut note à positionner.
     */

     void setNote(String note);

    /**
     * getNote :
     * @return String 
     */

     String getNote();

    /**
     * setLinkApplication :
     * @param linkApplication La valeur de l'attribut linkApplication à positionner.
     */

     void setLinkApplication(String linkApplication);

    /**
     * getLinkApplication :
     * @return String 
     */

     String getLinkApplication();

    /**
     * addTopiaGroup :
     * @param topiaGroup L'instance de topiaGroup à ajouter
     */

     void addTopiaGroup(TopiaGroup topiaGroup);

    /**
     * addAllTopiaGroup :
     * @param topiaGroup Les instances de topiaGroup à ajouter
     */

     void addAllTopiaGroup(Collection<TopiaGroup> topiaGroup);

    /**
     * setTopiaGroup :
     * @param topiaGroup La Collection de topiaGroup à ajouter
     */

     void setTopiaGroup(Collection<TopiaGroup> topiaGroup);

    /**
     * removeTopiaGroup :
     * @param topiaGroup Vide la Collection de topiaGroup
     */

     void removeTopiaGroup(TopiaGroup topiaGroup);

    /**
     * clearTopiaGroup :
     */

     void clearTopiaGroup();

    /**
     * getTopiaGroup :
     * @return Collection<TopiaGroup> 
     */

     Collection<TopiaGroup> getTopiaGroup();

    /**
     * getTopiaGroupByTopiaId :
     * Recupère l'attribut topiaGroup à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return TopiaGroup 
     */

     TopiaGroup getTopiaGroupByTopiaId(String topiaId);

    /**
     * sizeTopiaGroup :
     * Retourne le nombre d'éléments de la collection topiaGroup
     * @return int 
     */

     int sizeTopiaGroup();

    /**
     * isTopiaGroupEmpty :
     * Retourne {@code true} si la collection topiaGroup est vide.
     * @return boolean 
     */

     boolean isTopiaGroupEmpty();

    /**
     * checkPassword :
     * @param password 
     * @return boolean 
     */

     boolean checkPassword(String password);

    /**
     * setPassword :
     * @param oldPassword 
     * @param newPassword 
     */

     void setPassword(String oldPassword, String newPassword);


} //TopiaUser
