/*
 * #%L
 * ToPIA :: Service Replication
 * 
 * $Id: ReplicationOperationDef.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.4.2/topia-service-replication/src/main/java/org/nuiton/topia/replication/model/ReplicationOperationDef.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.replication.model;

import org.nuiton.topia.replication.TopiaReplicationOperation;

import java.util.Arrays;

public class ReplicationOperationDef {

    final ReplicationOperationPhase phase;

    final Class<? extends TopiaReplicationOperation> operationClass;

    final ReplicationNode node;

    final Object[] parameters;

    public ReplicationOperationDef(
            ReplicationOperationPhase phase,
            Class<? extends TopiaReplicationOperation> operation,
            ReplicationNode node,
            Object... parameters) {
        operationClass = operation;
        this.phase = phase;
        this.node = node;
        this.parameters = parameters;
    }

    public ReplicationNode getNode() {
        return node;
    }

    public Object[] getParameters() {
        return parameters;
    }

    public Class<? extends TopiaReplicationOperation> getOperationClass() {
        return operationClass;
    }

    public ReplicationOperationPhase getPhase() {
        return phase;
    }

    @Override
    public String toString() {
        return " <" + operationClass.getSimpleName() + " on " + node +
               (parameters.length == 0 ? "" :
                ", params:" + Arrays.toString(parameters)) + ">";
    }
}
