/*
 * #%L
 * ToPIA :: Service Replication
 * 
 * $Id: TopiaReplicationOperation.java 2089 2010-07-26 14:07:15Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.4.2/topia-service-replication/src/main/java/org/nuiton/topia/replication/TopiaReplicationOperation.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.replication;

import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;

import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

/**
 * Le contrat d'une operation a effectuer lors de la replication.
 * <p/>
 * Le module propose des operations de base dans le paquetage
 * <code>org.nuiton.topia.replication.operation</code>.
 * <p/>
 * <p/>
 * Pour definir une nouvelle implantation d'operation, il faut l'enregister
 * en tant que service (au sens de la classe {@link ServiceLoader},
 * c'est à dire ajouter dans un fichier (du class-path)
 * <code>META-INF/services/org.nuiton.topia.replication.TopiaReplicationOperation</code>
 * <p/>
 * une ligne avec le nom qualifie de votre implantation.
 * <p/>
 * Lors du chargement du service, on detecte toutes les operations disponibles.
 *
 * @author chemit
 * @since 2.2.0
 */
public interface TopiaReplicationOperation {

    /**
     * Creer et enregister une operation utilisateur apres la creation du
     * modele via la methode
     * <p/>
     * {@link TopiaReplicationService#prepare(TopiaEntityEnum[], String...)}.
     *
     * @param model      le modele de replication
     * @param ownerNode  le noeud proprietaire de l'operation
     * @param phase      la phase ou positionner l'operation
     * @param parameters les parametres de l'operation
     * @see ReplicationModel
     * @see ReplicationOperationPhase
     */
    void register(ReplicationModel model,
                  ReplicationNode ownerNode,
                  ReplicationOperationPhase phase,
                  Object... parameters);

    /**
     * Execute l'operation avec le parametrage donnee.
     * <p/>
     * Note : le commit sur le context cible doit etre geree dans la methode.
     *
     * @param operationDef la definition de l'operation a realiser
     * @param srcCtxt      le context source
     * @param dstCtxt      le context destination
     * @param entities     la liste des
     * @param data         le dictionnaire de toutes les donnees a repliquer
     * @throws Exception pour toute erreur
     */
    void run(ReplicationOperationDef operationDef,
             TopiaContextImplementor srcCtxt,
             TopiaContextImplementor dstCtxt,
             List<? extends TopiaEntity> entities,
             Map<Class<? extends TopiaEntity>, List<String>> data) throws Exception;
}
