/*
 * #%L
 * ToPIA :: Service Replication
 * 
 * $Id: LoadLink.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.3/topia-service-replication/src/main/java/org/nuiton/topia/replication/operation/LoadLink.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.replication.operation;

import org.nuiton.topia.replication.*;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.replication.model.Link;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;
import static org.nuiton.i18n.I18n._;

/**
 * Pour charger une association sur le noeud de l'operation.
 * 
 * Note : cette operation est interne, et n'est pas creable par
 * l'utilisateur via la methode
 * {@link #register(ReplicationModel, ReplicationNode, ReplicationOperationPhase, Object...)}.
 * 
 * @author chemit
 */
public class LoadLink implements TopiaReplicationOperation {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(LoadLink.class);

    @Override
    public void register(ReplicationModel model, ReplicationNode ownerNode, ReplicationOperationPhase phase, Object... parameters) {

        throw new UnsupportedOperationException(_("topia.replication.operation.error.uncreatable", getClass()));
    }

    @Override
    public void run(ReplicationOperationDef operationDef,
            TopiaContextImplementor srcCtxt,
            TopiaContextImplementor dstCtxt,
            List<? extends TopiaEntity> nodeEntities,
            Map<Class<? extends TopiaEntity>, List<String>> data) throws TopiaException {

        Link link = (Link) operationDef.getParameters()[0];

        String name = link.getName();

        ReplicationNode ownerNode = link.getSource();

        if (!ownerNode.equals(operationDef.getNode())) {
            throw new IllegalStateException(_("topia.replication.operation.loadLink.illegalSource", operationDef.getNode(), ownerNode));
        }

        if (log.isDebugEnabled()) {
            log.debug("currentNode : " + operationDef.getNode() + " , link to load : " + link);
        }

        EntityOperator<? super TopiaEntity> ownerOperator = ownerNode.getOperator();

        for (TopiaEntity src : nodeEntities) {

            // on se contente de charger l'association
            int size = ownerOperator.sizeChild(name, src);
            if (log.isDebugEnabled()) {
                log.debug("load association '" + name + "' on " + src + " : " + size);
            }
        }
    }
}
