/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.nuiton.topia.AbstractTopiaApplicationContext;
import org.nuiton.topia.AbstractTopiaPersistenceContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaHibernateSupport;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaPersistenceContext;
import org.nuiton.topia.event.TopiaContextAdapter;
import org.nuiton.topia.event.TopiaContextEvent;
import org.nuiton.topia.event.TopiaSchemaListener;
import org.nuiton.topia.event.TopiaTransactionEvent;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.migration.AbstractTopiaMigrationCallback;
import org.nuiton.topia.migration.MigrationServiceException;
import org.nuiton.topia.migration.TopiaMigrationService;
import org.nuiton.topia.migration.mappings.TMSVersion;
import org.nuiton.topia.migration.mappings.TMSVersionDAO;
import org.nuiton.topia.persistence.HibernateProvider;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

public class TopiaMigrationEngine
implements TopiaMigrationService {
    private static final Log log = LogFactory.getLog(TopiaMigrationEngine.class);
    protected Configuration versionConfiguration;
    protected boolean versionTableExist;
    protected Configuration legacyVersionConfiguration;
    protected boolean legacyVersionTableExist;
    protected Version dbVersion;
    protected boolean dbNotVersioned;
    protected boolean dbEmpty;
    protected boolean migrateOnInit;
    protected AbstractTopiaMigrationCallback callback;
    protected AbstractTopiaApplicationContext applicationContext;
    protected boolean init;
    protected boolean versionDetected;
    protected boolean showSql;
    protected boolean showProgression;
    protected final TopiaSchemaListener contextListener;
    protected final TopiaTransactionVetoable transactionVetoable = new TopiaTransactionVetoable(){

        public void beginTransaction(TopiaTransactionEvent event) {
            TopiaPersistenceContext context = event.getSource();
            context.getTopiaFiresSupport().addTopiaSchemaListener(TopiaMigrationEngine.this.contextListener);
        }
    };

    public TopiaMigrationEngine() {
        this.contextListener = new TopiaContextAdapter(){

            public void postCreateSchema(TopiaContextEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"postCreateSchema event called : will save version in database");
                }
                TopiaMigrationEngine.this.saveApplicationVersion();
            }

            public void postUpdateSchema(TopiaContextEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"postUpdateSchema event called : will save version in database");
                }
                TopiaMigrationEngine.this.saveApplicationVersion();
            }

            public void postRestoreSchema(TopiaContextEvent event) {
                block5: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"postRestoreSchema event detected, redo, schema migration");
                    }
                    if (TopiaMigrationEngine.this.migrateOnInit) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Starts Migrate from postRestoreSchema...");
                        }
                        try {
                            TopiaMigrationEngine.this.doMigrateSchema();
                        }
                        catch (Exception e) {
                            if (!log.isErrorEnabled()) break block5;
                            log.error((Object)("postRestoreSchema schema migration failed for reason " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
            }
        };
    }

    public Class<?>[] getPersistenceClasses() {
        return new Class[]{TMSVersion.class};
    }

    public String getServiceName() {
        return "migration";
    }

    public boolean preInit(AbstractTopiaApplicationContext context) {
        this.applicationContext = context;
        Properties config = null;
        String callbackStr = this.getSafeParameter(config, "topia.service.migration.callback");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Use callback            - " + callbackStr));
        }
        this.migrateOnInit = Boolean.valueOf(config.getProperty("topia.service.migration.no.migrate.on.init", String.valueOf(Boolean.TRUE)));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Migrate on init         - " + this.migrateOnInit));
        }
        this.showSql = Boolean.valueOf(config.getProperty("topia.service.migration.showSql", String.valueOf(Boolean.FALSE)));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Show sql                - " + this.showSql));
        }
        this.showProgression = Boolean.valueOf(config.getProperty("topia.service.migration.showProgression", String.valueOf(Boolean.FALSE)));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Show progression        - " + this.showProgression));
        }
        try {
            Class<?> clazz = Class.forName(callbackStr);
            this.callback = (AbstractTopiaMigrationCallback)clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate CallbackHandler [" + callbackStr + "]"), (Throwable)e);
        }
        Configuration configuration = new Configuration();
        for (Class<?> aClass : this.getPersistenceClasses()) {
            configuration.addClass(aClass);
        }
        this.versionConfiguration = this.createHibernateConfiguration(configuration);
        this.init = true;
        context.addTopiaSchemaListener(this.contextListener);
        context.addTopiaTransactionVetoable(this.transactionVetoable);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service [" + this + "] is init."));
        }
        if (this.migrateOnInit) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Starts Migrate from preInit...");
                }
                this.doMigrateSchema();
            }
            catch (MigrationServiceException e) {
                throw new TopiaException("Can't migrate schema for reason " + e.getMessage(), (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Service [" + this + "] skip migration on init as required"));
        }
        return true;
    }

    public boolean postInit(AbstractTopiaApplicationContext context) {
        return true;
    }

    public void doMigrateSchema() throws MigrationServiceException {
        boolean complete = this.migrateSchema();
        if (!complete) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Database migration not succesfully ended!");
            }
            throw new TopiaException("Database migration not succesfully ended!");
        }
    }

    @Override
    public boolean migrateSchema() throws MigrationServiceException {
        this.checkInit();
        this.detectDbVersion();
        Version version = this.callback.getApplicationVersion();
        log.info((Object)String.format("Starting Topia Migration Service  - Application version \\: %1$s, Database version \\: %2$s", version.getVersion(), this.dbVersion.getVersion()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Migrate schema to version = " + this.dbVersion));
            log.debug((Object)("is db not versionned ?    = " + this.dbNotVersioned));
            log.debug((Object)("is db empty ?             = " + this.dbEmpty));
            log.debug((Object)("TMSVersion exists         = " + this.versionTableExist));
        }
        if (this.dbEmpty) {
            return true;
        }
        if (this.versionTableExist && this.dbVersion.equals((Object)version)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Database is up to date, no migration needed.");
            }
            return true;
        }
        if (this.versionTableExist && this.dbNotVersioned && this.migrateOnInit) {
            log.info((Object)"Database is empty, no migration needed.");
            this.saveApplicationVersion();
            return true;
        }
        if (this.legacyVersionTableExist && this.dbVersion.equals((Object)version)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Database is up to date, no migration needed.");
            }
            this.saveApplicationVersion();
            return true;
        }
        TreeSet<Version> allVersions = new TreeSet<Version>((Comparator<Version>)new VersionUtil.VersionComparator());
        allVersions.addAll(Arrays.asList(this.callback.getAvailableVersions()));
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Available versions: %1$s", allVersions));
        }
        boolean needToMigrate = false;
        if (this.dbVersion.before(version)) {
            List versionsToApply = VersionUtil.filterVersions(allVersions, (Version)this.dbVersion, (Version)version, (boolean)false, (boolean)true);
            if (versionsToApply.isEmpty()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No version to apply, no migration needed.");
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Versions to apply: %1$s", versionsToApply));
                }
                needToMigrate = this.callback.doMigration(this.applicationContext, this.dbVersion, this.showSql, this.showProgression, versionsToApply);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handler choose : " + needToMigrate));
                }
                if (!needToMigrate) {
                    return false;
                }
            }
        }
        if (!this.versionTableExist || needToMigrate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set application version in database to " + version));
            }
            this.saveApplicationVersion();
        }
        return true;
    }

    protected void saveApplicationVersion() {
        boolean createTable;
        this.checkInit();
        Version version = this.callback.getApplicationVersion();
        this.detectDbVersion();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save version     = " + version));
            log.debug((Object)("Table exists     = " + this.versionTableExist));
            log.debug((Object)("Detected version = " + this.dbVersion));
        }
        boolean bl = createTable = !this.versionTableExist;
        if (createTable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding tms_version table");
            }
            TMSVersionDAO.createTable(this.versionConfiguration);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Table for " + TMSVersion.class.getSimpleName() + " created"));
            }
        }
        TopiaPersistenceContext tx = this.applicationContext.newPersistenceContext();
        TopiaHibernateSupport hibernateSupport = null;
        if (tx instanceof AbstractTopiaPersistenceContext) {
            hibernateSupport = ((AbstractTopiaPersistenceContext)tx).getHibernateSupport();
        }
        Preconditions.checkState((hibernateSupport != null ? 1 : 0) != 0);
        try {
            TMSVersionDAO.deleteAll(hibernateSupport);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Saving new database version: %1$s", version));
            }
            TMSVersion tmsVersion = TMSVersionDAO.create(hibernateSupport, version.getVersion());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created version: " + tmsVersion.getVersion()));
            }
            tx.commit();
        }
        catch (TopiaException e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (tx != null) {
                tx.closeContext();
            }
        }
        if (this.legacyVersionTableExist) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will drop legacy tmsVersion table");
            }
            TMSVersionDAO.dropTable(this.legacyVersionConfiguration);
        }
        this.versionTableExist = true;
        this.dbVersion = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectDbVersion() {
        Version v;
        block17: {
            block15: {
                block13: {
                    block16: {
                        block14: {
                            if (this.versionDetected) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("version was already detected : " + this.dbVersion));
                                }
                                return;
                            }
                            this.dbEmpty = this.detectDbEmpty();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Db is empty : " + this.dbEmpty));
                            }
                            v = null;
                            try {
                                this.versionTableExist = TopiaUtil.isSchemaExist((Configuration)this.versionConfiguration, (String)TMSVersion.class.getName());
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Table tms_version exist = " + this.versionTableExist));
                                }
                                if (!this.versionTableExist) break block13;
                                v = this.getVersion(this.versionTableExist, "tms_version");
                                if (log.isWarnEnabled() && v == null) {
                                    log.warn((Object)"Version not found on table tms_version");
                                }
                                if (v != null) break block14;
                                v = Version.VZERO;
                                this.dbNotVersioned = true;
                            }
                            catch (Throwable throwable) {
                                if (v == null) {
                                    v = Version.VZERO;
                                    this.dbNotVersioned = true;
                                    log.info((Object)"Database version not found, so database schema is considered as V0");
                                } else {
                                    log.info((Object)String.format("detected database version: %1$s", v));
                                }
                                this.dbVersion = v;
                                this.versionDetected = true;
                                throw throwable;
                            }
                            log.info((Object)"Database version not found, so database schema is considered as V0");
                            break block16;
                        }
                        log.info((Object)String.format("detected database version: %1$s", v));
                    }
                    this.dbVersion = v;
                    this.versionDetected = true;
                    return;
                }
                Configuration conf = new Configuration();
                conf.addXML(TMSVersionDAO.LEGACY_MAPPING);
                this.legacyVersionConfiguration = this.createHibernateConfiguration(conf);
                this.legacyVersionTableExist = TopiaUtil.isSchemaExist((Configuration)this.legacyVersionConfiguration, (String)TMSVersion.class.getName());
                if (this.legacyVersionTableExist) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Legacy : detected tmsVersion table");
                    }
                    if ((v = this.getVersion(this.legacyVersionTableExist, "tmsVersion")) != null && log.isDebugEnabled()) {
                        log.debug((Object)String.format("Legacy : detected database version: %1$s", v));
                    }
                }
                if (v != null) break block15;
                v = Version.VZERO;
                this.dbNotVersioned = true;
                log.info((Object)"Database version not found, so database schema is considered as V0");
                break block17;
            }
            log.info((Object)String.format("detected database version: %1$s", v));
        }
        this.dbVersion = v;
        this.versionDetected = true;
    }

    protected boolean detectDbEmpty() {
        try {
            HibernateProvider hibernateProvider = this.applicationContext.getHibernateProvider();
            boolean result = TopiaUtil.isSchemaEmpty((Configuration)hibernateProvider.getHibernateConfiguration());
            return result;
        }
        catch (TopiaNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Version getVersion(boolean versionTableExist, String tableName) {
        Version version;
        block8: {
            if (!versionTableExist) {
                return null;
            }
            TopiaPersistenceContext tx = this.applicationContext.newPersistenceContext();
            TopiaHibernateSupport hibernateSupport = null;
            if (tx instanceof AbstractTopiaPersistenceContext) {
                hibernateSupport = ((AbstractTopiaPersistenceContext)tx).getHibernateSupport();
            }
            Preconditions.checkState((hibernateSupport != null ? 1 : 0) != 0);
            try {
                Version v;
                version = v = TMSVersionDAO.getVersion(hibernateSupport, tableName);
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        tx.closeContext();
                    }
                    throw throwable;
                }
                catch (TopiaException e) {
                    throw new TopiaException("Can't obtain dbVersion for reason " + e.getMessage(), (Throwable)e);
                }
            }
            tx.closeContext();
        }
        return version;
    }

    protected String getSafeParameter(Properties config, String key) {
        String value = config.getProperty(key, null);
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)value), (Object)("'" + key + "' not set."));
        return value;
    }

    protected void checkInit() {
        Preconditions.checkState((boolean)this.init, (Object)"Service was not initialized!");
    }

    protected Configuration createHibernateConfiguration(Configuration configuration) {
        ImmutableMap config = this.applicationContext.getConfiguration();
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)configuration.getProperties());
        prop.putAll((Map<?, ?>)config);
        configuration.setProperties(prop);
        configuration.buildMappings();
        return configuration;
    }
}

