/*
 * #%L
 * ToPIA :: Service Migration
 * 
 * $Id: MigrationService.java 2010 2010-06-13 18:18:35Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.4/topia-service-migration/src/main/java/org/nuiton/topia/migration/MigrationService.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.migration;

import org.nuiton.topia.migration.callback.MigrationCallbackHandler;
import org.hibernate.cfg.Configuration;

/**
 * MigrationService.java
 *
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 2010 $
 *
 * Last update : $Date: 2010-06-13 20:18:35 +0200 (dim., 13 juin 2010) $
 * @deprecated since 2.3.4, please use now the simplify service {@link TopiaMigrationEngine}
 */
@Deprecated
public interface MigrationService {
    
    /**
     * Renvoie le chemin du ficier de configuration utilise
     * @return Chemin du fichier de configuration
     */
    String getConfigurationFile();

    /**
     * Modifie le fichier de configuration
     * @param configurationFile Chemin du fichier de configuration d'hibernate
     */
    void setConfigurationFile(String configurationFile);

    /**
     * Retourne la configuration
     * @return la configuration
     * @see Configuration
     */
    Configuration getConfiguration();

    /**
     * Renseigne la configuration
     * @param configuration la configuration
     * @see Configuration
     */
    void setConfiguration(Configuration configuration);

    /**
     * Retourne le repertoire des anciens schemas
     * @return Le repertoire des anciens schemas
     */
    String getMappingsDirectory();

    /**
     * Modifie le chemin du dossier des anciens schemas
     * @param mappingsDirectory Le chemin du dossier des anciens schemas
     */
    void setMappingsDirectory(String mappingsDirectory);

    /**
     * Change la version courante
     * @param version la version
     */
    void setApplicationVersion(String version);

    /**
     * Ajoute un callbackhandler pour la migration
     * @param callbackHandler le controleur a ajouter
     */
    void addMigrationCallbackHandler(MigrationCallbackHandler callbackHandler);
    
    /**
     * Migrate the schema
     * 
     * @return <tt>true</tt> si la migration a ete effectuee et s'est bien passee, <tt>false</tt> sinon
     * @throws MigrationServiceException dans le cas ou le schema ne peut pas etre mis a jour
     */
    boolean migrateSchema() throws MigrationServiceException;
}
