/*
 * #%L
 * ToPIA :: Service Migration
 * 
 * $Id: MigrationClass.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.3/topia-service-migration/src/main/java/org/nuiton/topia/migration/transformation/MigrationClass.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.migration.transformation;

import org.nuiton.topia.migration.common.ProxyClass;
import org.nuiton.topia.migration.common.SimpleProxyClass;
import org.nuiton.util.Version;

/**
 * MigrationClass.java
 * 
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 1894 $
 *
 * Last update : $Date: 2010-04-15 17:44:51 +0200 (jeu., 15 avril 2010) $
 */
public class MigrationClass implements Comparable<MigrationClass> {

    //private static transient Log log = LogFactory.getLog(MigrationClass.class);
    private String nameMigrationClass;
    private ProxyClass nameClass;
    private Version begin;
    private Version end;

    public MigrationClass() {
    }

    /**
     * @param nameMigrationClass
     * @param nameClass
     * @param begin
     * @param end
     */
    public MigrationClass(String nameMigrationClass, ProxyClass nameClass, Version begin, Version end) {
        this.nameMigrationClass = nameMigrationClass;
        this.nameClass = nameClass;
        this.begin = begin;
        this.end = end;
    }

    public MigrationClass(String nameMigrationClass, String nameClass, Version begin, Version end) {
        this(nameMigrationClass, new SimpleProxyClass(nameClass), begin, end);
    }

    /**
     * @return the begin
     */
    public Version getBegin() {
        return begin;
    }

    /**
     * @param begin the begin to set
     */
    public void setBegin(Version begin) {
        this.begin = begin;
    }

    /**
     * @return the end
     */
    public Version getEnd() {
        return end;
    }

    /**
     * @param end the end to set
     */
    public void setEnd(Version end) {
        this.end = end;
    }

    /**
     * @return the nameClass
     */
    public ProxyClass getNameClass() {
        return nameClass;
    }

    /**
     * @param nameClass the nameClass to set
     */
    public void setNameClass(ProxyClass nameClass) {
        this.nameClass = nameClass;
    }

    /**
     * @return the nameMigrationClass
     */
    public String getNameMigrationClass() {
        return nameMigrationClass;
    }

    /**
     * @param nameMigrationClass the nameMigrationClass to set
     */
    public void setNameMigrationClass(String nameMigrationClass) {
        this.nameMigrationClass = nameMigrationClass;
    }

    //DONE ? on compare sur les numero de version de departs
    //posera peut etre un probleme quand on devra passer a quelque chose de plus complique
    @Override
    public int compareTo(MigrationClass o) {
        return begin.compareTo(o.begin);
    }

    /**
     *
     * @return le nom de la classe d'origine
     * e.g. si la migration décrite est la migration de A vers B grace a la class MigrateBV1V2, alors cette methode renvoie A
     */
    @SuppressWarnings("unchecked")
    public ProxyClass getParentClassName() {
        ProxyClass result = null;
        try {
            //on charge la classe de migration
            Class<Migration> classOfMigration;
            classOfMigration = (Class<Migration>) ClassLoader.getSystemClassLoader().loadClass(nameMigrationClass);
            //on si le nom de la classe n'est pas preciser, on l'invente;
            result = classOfMigration.newInstance().migrateFrom();
            if (result == null) {
                result = nameClass;
            }
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        //log.debug("parent Classe : "+result);
        return result;
    }

    @Override
    public String toString() {
        return nameMigrationClass + "[" + nameClass + ":" + begin + "->" + end + "]";
    }
}
