/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.event.TopiaContextEvent;
import org.nuiton.topia.event.TopiaContextListener;
import org.nuiton.topia.event.TopiaTransactionEvent;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.migration.ManualMigrationCallback;
import org.nuiton.topia.migration.MigrationServiceDAOHelper;
import org.nuiton.topia.migration.MigrationServiceException;
import org.nuiton.topia.migration.TMSVersion;
import org.nuiton.topia.migration.TMSVersionDAO;
import org.nuiton.topia.migration.TMSVersionImpl;
import org.nuiton.topia.migration.TopiaMigrationService;
import org.nuiton.util.Resource;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

public class ManualMigrationEngine
implements TopiaMigrationService {
    private static final Log log = LogFactory.getLog(ManualMigrationEngine.class);
    public static final String MIGRATION_APPLICATION_VERSION = "topia.service.migration.version";
    public static final String MIGRATION_MAPPING_DIRECTORY = "topia.service.migration.mappingdir";
    public static final String MIGRATION_MODEL_NAME = "topia.service.migration.modelname";
    public static final String MIGRATION_CALLBACK = "topia.service.migration.callback";
    public static final String MIGRATION_NO_MIGRATE_ON_INIT = "topia.service.migration.no.migrate.on.init";
    protected Configuration versionConfiguration;
    protected String mappingsDirectory;
    protected SortedSet<Version> versions;
    protected Version applicationVersion;
    protected boolean versionTableExist;
    protected Version dbVersion;
    protected boolean noMigrateOnInit;
    protected ManualMigrationCallback callback;
    protected TopiaContextImplementor rootContext;
    protected boolean init = false;

    public Class<?>[] getPersistenceClasses() {
        return new Class[]{TMSVersionImpl.class};
    }

    public String getServiceName() {
        return "migration";
    }

    public boolean preInit(TopiaContextImplementor context) {
        this.rootContext = context;
        Properties config = context.getConfig();
        String mappingDirectory = config.getProperty(MIGRATION_MAPPING_DIRECTORY, null);
        String version = config.getProperty(MIGRATION_APPLICATION_VERSION, null);
        String callbackStr = config.getProperty(MIGRATION_CALLBACK, "");
        String[] dirs = config.getProperty("topia.persistence.directories", "").split(",");
        this.noMigrateOnInit = Boolean.valueOf(config.getProperty(MIGRATION_NO_MIGRATE_ON_INIT, "true"));
        String modelName = config.getProperty(MIGRATION_MODEL_NAME, null);
        if (version == null || version.trim().isEmpty()) {
            throw new IllegalStateException("'topia.service.migration.version' not set.");
        }
        if (modelName == null || modelName.trim().isEmpty()) {
            throw new IllegalStateException("'topia.service.migration.modelname' not set.");
        }
        if (callbackStr == null || callbackStr.trim().isEmpty()) {
            throw new IllegalStateException("'topia.service.migration.callback' not set.");
        }
        if (mappingDirectory == null || mappingDirectory.trim().isEmpty()) {
            throw new IllegalStateException("'topia.service.migration.mappingdir' not set.");
        }
        this.applicationVersion = VersionUtil.valueOf((String)version.trim());
        this.mappingsDirectory = mappingDirectory.trim() + "/" + modelName.trim();
        try {
            Class<?> clazz = Class.forName(callbackStr);
            this.callback = (ManualMigrationCallback)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("CallbackHandler Class " + callbackStr + " not found"), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)("CallbackHandler class " + callbackStr + " cannot be instanciated"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("CallbackHandler class " + callbackStr + " cannot be accessed"), (Throwable)e);
        }
        this.versionConfiguration = new Configuration();
        for (String dir : dirs) {
            if ((dir = dir.trim()).isEmpty()) continue;
            log.debug((Object)("addDirectory " + dir));
            this.versionConfiguration.addDirectory(new File(dir));
        }
        for (Class<?> clazz : this.getPersistenceClasses()) {
            log.debug((Object)("addClass " + clazz));
            this.versionConfiguration.addClass((Class)clazz);
        }
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)this.versionConfiguration.getProperties());
        prop.putAll((Map<?, ?>)config);
        this.versionConfiguration.setProperties(prop);
        this.versionTableExist = TopiaUtil.isSchemaExist((Configuration)this.versionConfiguration, (String)TMSVersionImpl.class.getName());
        try {
            this.dbVersion = this.detectDbVersion();
        }
        catch (MigrationServiceException e) {
            throw new TopiaRuntimeException("Can't obtain dbVersion for reason " + e.getMessage(), (Throwable)e);
        }
        this.init = true;
        context.addTopiaContextListener((TopiaContextListener)this);
        context.addTopiaTransactionVetoable((TopiaTransactionVetoable)this);
        if (!this.noMigrateOnInit) {
            try {
                this.doMigrateSchema();
            }
            catch (MigrationServiceException e) {
                throw new TopiaRuntimeException("Can't migrate schema for reason " + e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    public boolean postInit(TopiaContextImplementor context) {
        return true;
    }

    public void preCreateSchema(TopiaContextEvent event) {
    }

    public void preRestoreSchema(TopiaContextEvent event) {
    }

    public void preUpdateSchema(TopiaContextEvent event) {
    }

    public void postCreateSchema(TopiaContextEvent event) {
        if (log.isInfoEnabled()) {
            log.info((Object)"postCreateSchema event called : put version in database");
        }
        this.saveVersion(this.applicationVersion);
    }

    public void postUpdateSchema(TopiaContextEvent event) {
        if (log.isInfoEnabled()) {
            log.info((Object)"postUpdateSchema event called : put version in database");
        }
        this.saveVersion(this.applicationVersion);
    }

    public void postRestoreSchema(TopiaContextEvent event) {
        block3: {
            if (log.isInfoEnabled()) {
                log.info((Object)"postRestoreSchema event detected, redo, schema migration");
            }
            try {
                this.doMigrateSchema();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("postRestoreSchema schema migration failed for reason " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void beginTransaction(TopiaTransactionEvent event) {
        TopiaContextImplementor context = (TopiaContextImplementor)event.getSource();
        context.addTopiaContextListener((TopiaContextListener)this);
    }

    public void doMigrateSchema() throws MigrationServiceException {
        boolean complete = this.migrateSchema();
        if (!complete) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Database migration not complete");
            }
            throw new TopiaRuntimeException("Database migration not succesfully ended !");
        }
    }

    @Override
    public boolean migrateSchema() throws MigrationServiceException {
        this.checkInit();
        log.info((Object)("Starting Topia Migration Service  - Application version : " + this.applicationVersion.getVersion() + ", database version : " + this.dbVersion.getVersion()));
        boolean bMigrationNeeded = false;
        if (this.versionTableExist && this.dbVersion.equals((Object)this.applicationVersion)) {
            log.info((Object)"Database is up to date, no migration needed.");
            return true;
        }
        if (this.dbVersion.before(this.applicationVersion)) {
            SortedSet<Version> allVersions = this.getVersions();
            log.info((Object)("Database need update, available versions : " + allVersions));
            List<Version> versionsToApply = this.detectVersions(allVersions, this.dbVersion, this.applicationVersion);
            if (versionsToApply.isEmpty()) {
                log.info((Object)"no version to apply, no migration needed.");
            } else {
                bMigrationNeeded = true;
                log.info((Object)("will migrate versions " + versionsToApply));
                ManualMigrationCallback.MigrationChoice bMigrationWanted = this.callback.doMigration((TopiaContext)this.rootContext, this.dbVersion, this.applicationVersion, versionsToApply);
                log.info((Object)("Handler choose : " + (Object)((Object)bMigrationWanted)));
                if (bMigrationWanted == ManualMigrationCallback.MigrationChoice.NO_MIGRATION) {
                    return false;
                }
            }
        }
        if (!this.versionTableExist || bMigrationNeeded) {
            log.info((Object)("Set application version in database to " + this.applicationVersion));
            this.saveVersion(this.applicationVersion);
        }
        return true;
    }

    public void saveVersion(Version version) {
        this.checkInit();
        try {
            boolean createTable;
            boolean bl = createTable = !this.versionTableExist;
            if (createTable) {
                log.debug((Object)"Adding table to put version");
                SchemaExport schemaExport = new SchemaExport(this.versionConfiguration);
                schemaExport.create(log.isDebugEnabled(), true);
                log.debug((Object)("Table for " + TMSVersion.class.getSimpleName() + " created"));
            }
            TopiaContext tx = null;
            try {
                tx = this.rootContext.beginTransaction();
                TMSVersionDAO dao = MigrationServiceDAOHelper.getTMSVersionDAO(tx);
                List toDelete = dao.findAll();
                for (TMSVersion v : toDelete) {
                    v.delete();
                }
                log.info((Object)("Database version : " + version));
                dao.create(new Object[]{"version", version.getVersion()});
                tx.commitTransaction();
            }
            catch (TopiaException e) {
                if (tx != null) {
                    tx.rollbackTransaction();
                }
                throw e;
            }
            finally {
                if (tx != null) {
                    tx.closeContext();
                }
            }
        }
        catch (TopiaException e) {
            throw new TopiaRuntimeException((Throwable)e);
        }
        this.versionTableExist = true;
        this.dbVersion = version;
    }

    protected SortedSet<Version> getVersions() throws MigrationServiceException {
        if (this.versions == null) {
            this.checkInit();
            Pattern MAPPING_PATTERN = Pattern.compile(this.mappingsDirectory + File.separator + "([0-9]+(\\.[0-9]+)*)");
            ClassLoader classLoader = this.getClass().getClassLoader();
            List urls = Resource.getURLs((String)(".*" + this.mappingsDirectory + "/.*"), (URLClassLoader)(classLoader instanceof URLClassLoader ? (URLClassLoader)classLoader : null));
            this.versions = new TreeSet<Version>();
            if (urls != null && !urls.isEmpty()) {
                for (URL url : urls) {
                    Matcher matcher;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("url to scan " + url));
                    }
                    if (!(matcher = MAPPING_PATTERN.matcher(url.getFile())).find()) continue;
                    String sVersion = matcher.group(1);
                    this.versions.add(VersionUtil.valueOf((String)sVersion));
                }
            }
        }
        return this.versions;
    }

    protected List<Version> detectVersions(SortedSet<Version> versions, Version dbVersion, Version applicationVersion) {
        ArrayList<Version> toApply = new ArrayList<Version>();
        for (Version v : versions) {
            log.debug((Object)("detected version " + v));
            if (v.compareTo(dbVersion) <= 0 || v.compareTo(applicationVersion) > 0) continue;
            log.info((Object)("version to migrate : " + v));
            toApply.add(v);
        }
        return toApply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Version detectDbVersion() throws MigrationServiceException {
        Version v;
        block9: {
            v = null;
            try {
                if (!this.versionTableExist) break block9;
                TopiaContext tx = null;
                try {
                    tx = this.rootContext.beginTransaction();
                    TMSVersionDAO dao = MigrationServiceDAOHelper.getTMSVersionDAO(tx);
                    List versionsInDB = dao.findAll();
                    if (!versionsInDB.isEmpty()) {
                        v = VersionUtil.valueOf((String)((TMSVersion)versionsInDB.get(0)).getVersion());
                    }
                }
                finally {
                    if (tx != null) {
                        tx.closeContext();
                    }
                }
            }
            catch (TopiaException e) {
                throw new MigrationServiceException(e);
            }
        }
        if (v == null) {
            v = Version.VZERO;
            log.info((Object)"Database version not found, so database schema is considered as V0");
        } else {
            log.info((Object)("Database version : " + v));
        }
        return v;
    }

    protected void checkInit() {
        if (!this.init) {
            throw new IllegalStateException("le service n'est pas initialis\u00e9!");
        }
    }
}

