/* *##% ToPIA - Migration service
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/
package org.nuiton.topia.migration.common;

import java.io.Serializable;

import org.nuiton.topia.migration.transformation.Migration;

/**
 * SimpleProxyClassMapped.java
 *
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 1459 $
 *
 * Last update : $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 */
public class SimpleProxyClassMapped implements ProxyClassMapped {

    private ProxyClass pc;
    private Serializable nameIdAttribute;
    private Migration m;

    /**
     * @param pc
     * @param nameIdAttribute
     */
    public SimpleProxyClassMapped(ProxyClass pc, Serializable nameIdAttribute) {
        super();
        this.pc = pc;
        this.nameIdAttribute = nameIdAttribute;
    }

    public SimpleProxyClassMapped(ProxyClass pc, Serializable nameIdAttribute, Migration migration) {
        super();
        this.pc = pc;
        this.nameIdAttribute = nameIdAttribute;
        this.m = migration;
    }

    public SimpleProxyClassMapped(ProxyClass class1) {
        super();
        this.pc = class1;
    }

    /* (non-Javadoc)
     * @see org.nuiton.topia.migration.common.ProxyClassMapped#getIdAttribute()
     */
    @Override
    public Serializable getIdAttribute() {
        return nameIdAttribute;
    }

    /* (non-Javadoc)
     * @see org.nuiton.topia.migration.common.ProxyClassMapped#getProxyClass()
     */
    @Override
    public ProxyClass getProxyClass() {
        return pc;
    }

    /**
     * @param nameIdAttribute the nameIdAttribute to set
     */
    public void setNameIdAttribute(Serializable nameIdAttribute) {
        this.nameIdAttribute = nameIdAttribute;
    }

    @Override
    public int hashCode() {
        return this.pc.getCanonicalName().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ProxyClassMapped) {
            ProxyClassMapped o = (ProxyClassMapped) other;
            return o.getProxyClass().equals(this.pc);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.toString() + "(" + nameIdAttribute + ")";
    }

    @Override
    public Migration getMigrationClass() {
        return m;
    }
}
