/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.flyway;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.internal.util.Location;
import org.nuiton.topia.flyway.TopiaFlywayService;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaMigrationServiceException;

public class TopiaFlywayServiceImpl
implements TopiaFlywayService {
    private static final Log log = LogFactory.getLog(TopiaFlywayServiceImpl.class);
    protected String flywayBaselineVersion = null;
    protected boolean useModelVersion = true;
    protected Flyway flyway;
    protected String modelVersion;

    public void initTopiaService(TopiaApplicationContext topiaApplicationContext, Map<String, String> serviceConfiguration) {
        this.modelVersion = topiaApplicationContext.getModelVersion();
        if (serviceConfiguration.containsKey("flyway.baselineVersion")) {
            this.flywayBaselineVersion = serviceConfiguration.get("flyway.baselineVersion");
            if (StringUtils.isBlank((CharSequence)this.flywayBaselineVersion)) {
                throw new IllegalArgumentException("'flyway.baselineVersion' must not be empty");
            }
        } else if (serviceConfiguration.containsKey("flyway.initVersion")) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"flyway.initVersion is deprecated, use flyway.baselineVersion instead");
            }
            this.flywayBaselineVersion = serviceConfiguration.get("flyway.initVersion");
            if (StringUtils.isBlank((CharSequence)this.flywayBaselineVersion)) {
                throw new IllegalArgumentException("'flyway.initVersion' must not be empty");
            }
        }
        if (serviceConfiguration.containsKey("useModelVersion")) {
            String useModelVersionString = serviceConfiguration.get("useModelVersion");
            if (StringUtils.isBlank((CharSequence)useModelVersionString)) {
                throw new IllegalArgumentException("'useModelVersion' must not be empty");
            }
            this.useModelVersion = Boolean.valueOf(useModelVersionString);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"init flyway service");
        }
        this.flyway = new Flyway();
        this.setDataSource(this.flyway, topiaApplicationContext);
        this.setLocations(this.flyway, topiaApplicationContext);
        this.doExtraConfiguration(this.flyway, topiaApplicationContext);
    }

    protected void setDataSource(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
        TopiaConfiguration configuration = topiaApplicationContext.getConfiguration();
        String url = configuration.getJdbcConnectionUrl();
        String user = configuration.getJdbcConnectionUser();
        String password = configuration.getJdbcConnectionPassword();
        flyway.setDataSource(url, user, password, new String[0]);
    }

    protected void setLocations(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
        String classpathMigrationPackage = topiaApplicationContext.getClass().getPackage().getName() + ".migration";
        ImmutableSet defaultLocations = ImmutableSet.of((Object)"db/migration", (Object)classpathMigrationPackage);
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        for (String defaultLocation : defaultLocations) {
            if (log.isInfoEnabled()) {
                log.info((Object)("will search for migration in location " + defaultLocation));
            }
            try {
                Location location = new Location(defaultLocation);
                Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(location.getPath());
                if (resources.hasMoreElements()) {
                    locations.add(defaultLocation);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("migrations found in " + defaultLocation));
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("no migration found in " + defaultLocation));
            }
            catch (IOException e) {
                throw new TopiaException((Throwable)e);
            }
        }
        String[] locationsArray = locations.toArray(new String[locations.size()]);
        flyway.setLocations(locationsArray);
    }

    protected void doExtraConfiguration(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
    }

    public String getSchemaVersion() throws TopiaMigrationServiceException {
        MigrationInfo currentOrNull = this.flyway.info().current();
        if (currentOrNull == null) {
            throw new TopiaMigrationServiceException("schema version is unknown");
        }
        String schemaVersion = currentOrNull.getVersion().getVersion();
        return schemaVersion;
    }

    public void initOnCreateSchema() {
        String baselineVersion;
        if (this.useModelVersion) {
            Preconditions.checkState((boolean)Strings.isNullOrEmpty((String)this.flywayBaselineVersion), (Object)"flyway.initVersion is not not compatible with useModelVersion=true");
            if (log.isInfoEnabled()) {
                log.info((Object)("Using model version: " + this.modelVersion));
            }
            baselineVersion = this.modelVersion;
        } else {
            Object[] allMigrations = this.flyway.info().all();
            if (ArrayUtils.isEmpty((Object[])allMigrations)) {
                Preconditions.checkState((!Strings.isNullOrEmpty((String)this.flywayBaselineVersion) ? 1 : 0) != 0, (Object)"No migration found and useModelVersion=false. You need to declare a flyway.baselineVersion");
                if (log.isInfoEnabled()) {
                    log.info((Object)("Using flyway.baselineVersion version: " + this.flywayBaselineVersion));
                }
                baselineVersion = this.flywayBaselineVersion;
            } else {
                Preconditions.checkState((boolean)Strings.isNullOrEmpty((String)this.flywayBaselineVersion), (Object)"Migrations found with useModelVersion=false. flyway.baselineVersion shouldn't be set");
                TreeSet treeSet = Sets.newTreeSet(Arrays.asList(allMigrations));
                MigrationInfo last = (MigrationInfo)Iterables.getLast((Iterable)treeSet);
                String version = last.getVersion().getVersion();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Using highest migration version found: " + version));
                }
                baselineVersion = version;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("baseline flyway to version " + baselineVersion));
        }
        this.flyway.setBaselineVersion(MigrationVersion.fromVersion((String)baselineVersion));
        this.flyway.setBaselineDescription("schema creation called on application context by topia flyway service");
        this.flyway.baseline();
    }

    public void runSchemaMigration() {
        if (this.flywayBaselineVersion == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"schema exists, no flywayInitVersion found, let suppose flyway is already initialized");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("schema exists, will ask flyway to init if necessary to version " + this.flywayBaselineVersion));
            }
            this.flyway.setBaselineOnMigrate(true);
            this.flyway.setBaselineVersion(MigrationVersion.fromVersion((String)this.flywayBaselineVersion));
        }
        if (this.useModelVersion) {
            String targetVersion = this.modelVersion;
            if (log.isInfoEnabled()) {
                log.info((Object)("schema exists, will run flyway migration up to target version " + targetVersion));
            }
            this.flyway.setTarget(MigrationVersion.fromVersion((String)targetVersion));
        } else if (log.isInfoEnabled()) {
            log.info((Object)"schema exists, no target version specified, will run flyway migration for all existing versions");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"run flyway migration");
        }
        this.flyway.migrate();
    }

    public void close() {
    }
}

