/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.HqlAndParametersBuilder;
import org.nuiton.topia.persistence.QueryMissingOrderException;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaDaoSupplier;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaNoResultException;
import org.nuiton.topia.persistence.TopiaNonUniqueResultException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryStep;
import org.nuiton.topia.persistence.event.TopiaEntityListener;
import org.nuiton.topia.persistence.event.TopiaEntityVetoable;
import org.nuiton.topia.persistence.internal.support.TopiaFiresSupport;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.support.TopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaListenableSupport;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.topia.persistence.util.TopiaUtil;
import org.nuiton.util.PagerBean;
import org.nuiton.util.PagerBeanUtil;

public abstract class AbstractTopiaDao<E extends TopiaEntity>
implements TopiaDao<E> {
    private static Log log = LogFactory.getLog(AbstractTopiaDao.class);
    protected int batchSize = 1000;
    protected TopiaJpaSupport topiaJpaSupport;
    protected TopiaHibernateSupport topiaHibernateSupport;
    protected TopiaSqlSupport topiaSqlSupport;
    protected TopiaListenableSupport topiaListenableSupport;
    protected TopiaIdFactory topiaIdFactory;
    protected TopiaFiresSupport topiaFiresSupport;
    protected TopiaDaoSupplier topiaDaoSupplier;

    public abstract TopiaEntityEnum getTopiaEntityEnum();

    @Override
    public abstract Class<E> getEntityClass();

    public void init(TopiaJpaSupport topiaJpaSupport, TopiaHibernateSupport topiaHibernateSupport, TopiaSqlSupport topiaSqlSupport, TopiaListenableSupport topiaListenableSupport, TopiaIdFactory topiaIdFactory, TopiaFiresSupport topiaFiresSupport, TopiaDaoSupplier topiaDaoSupplier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init dao for " + this.getEntityClass()));
        }
        this.topiaJpaSupport = topiaJpaSupport;
        this.topiaHibernateSupport = topiaHibernateSupport;
        this.topiaSqlSupport = topiaSqlSupport;
        this.topiaListenableSupport = topiaListenableSupport;
        this.topiaIdFactory = topiaIdFactory;
        this.topiaFiresSupport = topiaFiresSupport;
        this.topiaDaoSupplier = topiaDaoSupplier;
    }

    public TopiaFiresSupport getTopiaFiresSupport() {
        return this.topiaFiresSupport;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    protected String newFromClause() {
        return this.newFromClause(null);
    }

    protected String newFromClause(String alias) {
        String hql = "from " + this.getTopiaEntityEnum().getImplementationFQN();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            hql = hql + " " + alias;
        }
        return hql;
    }

    @Override
    public E newInstance() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("entityClass = " + this.getEntityClass()));
        }
        Class<? extends TopiaEntity> implementation = this.getTopiaEntityEnum().getImplementation();
        try {
            TopiaEntity newInstance = implementation.newInstance();
            return (E)newInstance;
        }
        catch (InstantiationException e) {
            throw new TopiaException("Impossible de trouver ou d'instancier la classe " + implementation);
        }
        catch (IllegalAccessException e) {
            throw new TopiaException("Impossible de trouver ou d'instancier la classe " + implementation);
        }
    }

    @Override
    public TopiaPagerBean newPager(int pageSize) {
        TopiaPagerBean pager = this.newPager(this.newFromClause(), null, pageSize);
        return pager;
    }

    @Override
    public TopiaPagerBean newPager(String hql, Map<String, Object> params, int pageSize) {
        TopiaPagerBean pager = new TopiaPagerBean();
        if (this.hqlContainsOrderBy(hql)) {
            hql = hql.substring(0, hql.toLowerCase().indexOf("order by"));
        }
        long count = this.count("SELECT COUNT(*) " + hql, params);
        pager.setRecords(count);
        pager.setPageSize(pageSize);
        PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)pager);
        return pager;
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.topiaListenableSupport.addTopiaEntityListener(this.getEntityClass(), listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.topiaListenableSupport.addTopiaEntityVetoable(this.getEntityClass(), vetoable);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.topiaListenableSupport.removeTopiaEntityListener(this.getEntityClass(), listener);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.topiaListenableSupport.removeTopiaEntityVetoable(this.getEntityClass(), vetoable);
    }

    @Override
    public E create(E entity) {
        if (StringUtils.isBlank((CharSequence)entity.getTopiaId())) {
            String topiaId = this.topiaIdFactory.newTopiaId(this.getEntityClass(), (TopiaEntity)entity);
            entity.setTopiaId(topiaId);
        }
        if (entity instanceof TopiaEntityContextable) {
            TopiaEntityContextable contextable = (TopiaEntityContextable)entity;
            contextable.setTopiaDaoSupplier(this.topiaDaoSupplier);
        }
        this.topiaJpaSupport.save(entity);
        this.topiaFiresSupport.warnOnCreateEntity((TopiaEntity)entity);
        return entity;
    }

    @Override
    public E create(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        Map<String, Object> properties = TopiaUtil.convertPropertiesArrayToMap(propertyName, propertyValue, otherPropertyNamesAndValues);
        E result = this.create(properties);
        return result;
    }

    @Override
    public E create(Map<String, Object> properties) {
        E result = this.newInstance();
        try {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                String propertyName = e.getKey();
                Object value = e.getValue();
                PropertyUtils.setProperty(result, (String)propertyName, (Object)value);
            }
        }
        catch (IllegalAccessException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (InvocationTargetException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (NoSuchMethodException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        this.create(result);
        return result;
    }

    @Override
    public E create() {
        E result = this.newInstance();
        this.create(result);
        return result;
    }

    @Override
    public Iterable<E> createAll(Iterable<E> entities) {
        for (TopiaEntity entity : entities) {
            this.create(entity);
        }
        return entities;
    }

    @Override
    public E update(E entity) {
        this.topiaJpaSupport.saveOrUpdate(entity);
        this.topiaFiresSupport.warnOnUpdateEntity((TopiaEntity)entity);
        return entity;
    }

    @Override
    public Iterable<E> updateAll(Iterable<E> entities) {
        for (TopiaEntity entity : entities) {
            this.update(entity);
        }
        return entities;
    }

    @Override
    public void delete(E entity) {
        this.topiaJpaSupport.delete(entity);
        entity.notifyDeleted();
        this.topiaFiresSupport.warnOnDeleteEntity((TopiaEntity)entity);
    }

    @Override
    public void deleteAll(Iterable<E> entities) {
        for (TopiaEntity entity : entities) {
            this.delete(entity);
        }
    }

    protected HqlAndParametersBuilder<E> newHqlAndParametersBuilder() {
        HqlAndParametersBuilder<E> result = new HqlAndParametersBuilder<E>(this.getEntityClass());
        return result;
    }

    protected HqlAndParametersBuilder<E> getHqlForProperties(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        Map<String, Object> properties = TopiaUtil.convertPropertiesArrayToMap(propertyName, propertyValue, otherPropertyNamesAndValues);
        HqlAndParametersBuilder<E> result = this.getHqlForProperties(properties);
        return result;
    }

    protected HqlAndParametersBuilder<E> getHqlForNoConstraint() {
        Map<String, Object> properties = Collections.emptyMap();
        HqlAndParametersBuilder<E> result = this.getHqlForProperties(properties);
        return result;
    }

    protected HqlAndParametersBuilder<E> getHqlForProperties(Map<String, Object> properties) {
        HqlAndParametersBuilder<E> result = this.newHqlAndParametersBuilder();
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            result.addEquals(property.getKey(), property.getValue());
        }
        return result;
    }

    protected InnerTopiaQueryBuilderRunQueryStep<E> forHql(String hql) {
        Map<String, Object> properties = Collections.emptyMap();
        InnerTopiaQueryBuilderRunQueryStep<E> result = this.forHql(hql, properties);
        return result;
    }

    protected InnerTopiaQueryBuilderRunQueryStep<E> forHql(String hql, Map<String, Object> hqlParameters) {
        InnerTopiaQueryBuilderRunQueryStep result = new InnerTopiaQueryBuilderRunQueryStep(this, true, hql, hqlParameters);
        return result;
    }

    protected InnerTopiaQueryBuilderRunQueryStep<E> forHql(String hql, String parameterName, Object parameterValue, Object ... otherParameterNamesAndValues) {
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(parameterName, parameterValue, otherParameterNamesAndValues);
        InnerTopiaQueryBuilderRunQueryStep<E> result = this.forHql(hql, hqlParameters);
        return result;
    }

    @Override
    public InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAll() {
        TopiaQueryBuilderAddCriteriaStep result = this.newQueryBuilder();
        return result;
    }

    @Override
    public InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProperties(Map<String, Object> properties) {
        HqlAndParametersBuilder<E> hqlAndParametersBuilder = this.getHqlForProperties(properties);
        InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = new InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E>(this, hqlAndParametersBuilder);
        return result;
    }

    @Override
    public InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProperties(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        HqlAndParametersBuilder<E> hqlAndParametersBuilder = this.getHqlForProperties(propertyName, propertyValue, otherPropertyNamesAndValues);
        InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = new InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E>(this, hqlAndParametersBuilder);
        return result;
    }

    @Override
    public InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> newQueryBuilder() {
        HqlAndParametersBuilder<E> hqlAndParametersBuilder = this.newHqlAndParametersBuilder();
        InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = new InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E>(this, hqlAndParametersBuilder);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContains(String propertyName, Object propertyValue) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).addContains(propertyName, propertyValue);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEquals(String propertyName, Object propertyValue) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).addEquals(propertyName, propertyValue);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIn(String propertyName, Collection<?> propertyValues) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).addIn(propertyName, propertyValues);
        return result;
    }

    protected boolean exists(String hql, Map<String, Object> hqlParameters) {
        List entities = this.topiaJpaSupport.find(hql, 0, 0, hqlParameters);
        boolean result = !entities.isEmpty();
        return result;
    }

    protected long count(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkArgument((boolean)hql.toLowerCase().trim().startsWith("select count("));
        Long result = (Long)this.findUnique(hql, hqlParameters);
        return result;
    }

    protected <K> K findUnique(String hql, Map<String, Object> hqlParameters) throws TopiaNoResultException, TopiaNonUniqueResultException {
        K result = this.findUniqueOrNull(hql, hqlParameters);
        if (result == null) {
            throw new TopiaNoResultException(hql, hqlParameters);
        }
        return result;
    }

    protected <K> Optional<K> tryFindUnique(String hql, Map<String, Object> hqlParameters) throws TopiaNonUniqueResultException {
        K uniqueOrNull = this.findUniqueOrNull(hql, hqlParameters);
        Optional result = Optional.fromNullable(uniqueOrNull);
        return result;
    }

    protected <K> K findUniqueOrNull(String hql, Map<String, Object> hqlParameters) throws TopiaNonUniqueResultException {
        List<K> results = this.find(hql, hqlParameters, 0, 1);
        if (results.size() > 1) {
            throw new TopiaNonUniqueResultException(hql, hqlParameters);
        }
        Object result = Iterables.getOnlyElement(results, null);
        return (K)result;
    }

    protected <K> K findFirst(String hql, Map<String, Object> hqlParameters) throws QueryMissingOrderException {
        K result = this.findFirstOrNull(hql, hqlParameters);
        if (result == null) {
            throw new TopiaNoResultException(hql, hqlParameters);
        }
        return result;
    }

    protected <K> Optional<K> tryFindFirst(String hql, Map<String, Object> hqlParameters) throws QueryMissingOrderException {
        K firstOrNull = this.findFirstOrNull(hql, hqlParameters);
        Optional result = Optional.fromNullable(firstOrNull);
        return result;
    }

    protected <K> K findFirstOrNull(String hql, Map<String, Object> hqlParameters) throws QueryMissingOrderException {
        if (!this.hqlContainsOrderBy(hql)) {
            throw new QueryMissingOrderException(hql, hqlParameters);
        }
        K result = this.findAnyOrNull(hql, hqlParameters);
        return result;
    }

    protected <K> K findAny(String hql, Map<String, Object> hqlParameters) throws TopiaNoResultException {
        K result = this.findAnyOrNull(hql, hqlParameters);
        if (result == null) {
            throw new TopiaNoResultException(hql, hqlParameters);
        }
        return result;
    }

    protected <K> Optional<K> tryFindAny(String hql, Map<String, Object> hqlParameters) {
        K anyOrNull = this.findAnyOrNull(hql, hqlParameters);
        Optional result = Optional.fromNullable(anyOrNull);
        return result;
    }

    protected <K> K findAnyOrNull(String hql) {
        Preconditions.checkNotNull((Object)hql);
        Map<String, Object> hqlParameters = Collections.emptyMap();
        K result = this.findAnyOrNull(hql, hqlParameters);
        return result;
    }

    protected <K> K findAnyOrNull(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        List<K> results = this.find(hql, hqlParameters, 0, 0);
        Object result = Iterables.getOnlyElement(results, null);
        return (K)result;
    }

    protected <K> List<K> findAll(String hql) {
        Preconditions.checkNotNull((Object)hql);
        Map<String, Object> hqlParameters = Collections.emptyMap();
        List<K> result = this.findAll(hql, hqlParameters);
        return result;
    }

    protected <K> List<K> findAll(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        List result = this.topiaJpaSupport.findAll(hql, hqlParameters);
        return result;
    }

    protected <K> List<K> find(String hql, int startIndex, int endIndex) {
        Preconditions.checkNotNull((Object)hql);
        Map<String, Object> hqlParameters = Collections.emptyMap();
        List<K> result = this.find(hql, hqlParameters, startIndex, endIndex);
        return result;
    }

    protected <K> List<K> find(String hql, Map<String, Object> hqlParameters, int startIndex, int endIndex) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        List result = this.topiaJpaSupport.find(hql, startIndex, endIndex, hqlParameters);
        return result;
    }

    protected <K> List<K> find(String hql, Map<String, Object> hqlParameters, TopiaPagerBean pager) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        Preconditions.checkNotNull((Object)((Object)pager));
        if (StringUtils.isNotBlank((CharSequence)pager.getSortColumn())) {
            Preconditions.checkState((!this.hqlContainsOrderBy(hql) ? 1 : 0) != 0, (Object)"An 'order by' clause was already found in hql, can't use the order of the pager");
            hql = hql + " order by " + pager.getSortColumn();
            if (!pager.isSortAscendant()) {
                hql = hql + " desc";
            }
        }
        List result = this.topiaJpaSupport.find(hql, (int)pager.getRecordStartIndex(), (int)pager.getRecordEndIndex() - 1, hqlParameters);
        return result;
    }

    protected <K> Iterable<K> findAllLazy(String hql) {
        Map<String, Object> hqlParameters = Collections.emptyMap();
        Iterable<K> result = this.findAllLazy(hql, hqlParameters);
        return result;
    }

    protected <K> Iterable<K> findAllLazy(String hql, Map<String, Object> hqlParameters) {
        Iterable<K> result = this.findAllLazy(hql, hqlParameters, this.batchSize);
        return result;
    }

    protected <K> Iterable<K> findAllLazy(String hql, int batchSize) {
        Map<String, Object> hqlParameters = Collections.emptyMap();
        Iterable<K> result = this.findAllLazy(hql, hqlParameters, batchSize);
        return result;
    }

    protected <K> Iterable<K> findAllLazy(String hql, Map<String, Object> hqlParameters, int batchSize) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        final FindAllIterator iterator = new FindAllIterator(this, batchSize, hql, hqlParameters);
        Iterable result = new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                return iterator;
            }
        };
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTopiaIdEquals(String topiaId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topiaId), (Object)"given topiaId is blank");
        TopiaQueryBuilderRunQueryStep result = this.forEquals("topiaId", topiaId);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTopiaIdIn(Collection<String> topiaIds) {
        Preconditions.checkNotNull(topiaIds, (Object)"given topiaIds is null");
        TopiaQueryBuilderRunQueryStep result = this.forIn("topiaId", (Collection)topiaIds);
        return result;
    }

    @Override
    public E findByTopiaId(String topiaId) throws TopiaNoResultException {
        try {
            Object result = this.forTopiaIdEquals(topiaId).findAny();
            return result;
        }
        catch (TopiaNoResultException tnre) {
            if (log.isWarnEnabled()) {
                String message = String.format("Unexpected behavior : entity '%s' not found with topiaId='%s'", this.getEntityClass().getName(), topiaId);
                log.warn((Object)message);
            }
            throw tnre;
        }
    }

    @Override
    public Optional<E> tryFindByTopiaId(String topiaId) {
        Optional result = this.forTopiaIdEquals(topiaId).tryFindAny();
        return result;
    }

    @Override
    public List<String> findAllIds() {
        List<String> result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).findAllIds();
        return result;
    }

    @Override
    public List<E> findAll() {
        List result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).findAll();
        return result;
    }

    @Override
    public Iterable<E> findAllLazy() {
        String hql = "from " + this.getTopiaEntityEnum().getImplementationFQN() + " order by id";
        Map<String, Object> hqlParameters = Collections.emptyMap();
        Iterable result = this.findAllLazy(hql, hqlParameters);
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        Iterator<E> result = this.findAllLazy().iterator();
        return result;
    }

    @Override
    public long count() {
        long result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).count();
        return result;
    }

    protected boolean hqlContainsOrderBy(String hql) {
        return hql.toLowerCase().contains("order by");
    }

    protected boolean hqlContainsCount(String hql) {
        return hql.toLowerCase().contains("count(");
    }

    public static class InnerTopiaQueryBuilderRunQueryStep<E extends TopiaEntity>
    implements TopiaQueryBuilderRunQueryStep<E> {
        protected final String hql;
        protected final Map<String, Object> hqlParameters;
        protected final AbstractTopiaDao<E> topiaDAO;
        protected final boolean fromHql;

        protected InnerTopiaQueryBuilderRunQueryStep(AbstractTopiaDao<E> topiaDAO, boolean fromHql, String hql, Map<String, Object> hqlParameters) {
            this.fromHql = fromHql;
            this.hql = hql;
            this.hqlParameters = hqlParameters;
            this.topiaDAO = topiaDAO;
        }

        @Override
        public boolean exists() {
            return this.topiaDAO.exists(this.hql, this.hqlParameters);
        }

        @Override
        public long count() {
            String hqlWithSelectClause = "select count(topiaId) " + this.hql;
            return this.topiaDAO.count(hqlWithSelectClause, this.hqlParameters);
        }

        @Override
        public E findUnique() throws TopiaNoResultException, TopiaNonUniqueResultException {
            return (E)((TopiaEntity)this.topiaDAO.findUnique(this.hql, this.hqlParameters));
        }

        @Override
        public E findUniqueOrNull() throws TopiaNonUniqueResultException {
            return (E)((TopiaEntity)this.topiaDAO.findUniqueOrNull(this.hql, this.hqlParameters));
        }

        @Override
        public Optional<E> tryFindUnique() throws TopiaNonUniqueResultException {
            return this.topiaDAO.tryFindUnique(this.hql, this.hqlParameters);
        }

        @Override
        public E findFirst() throws QueryMissingOrderException, TopiaNoResultException {
            return (E)((TopiaEntity)this.topiaDAO.findFirst(this.hql, this.hqlParameters));
        }

        @Override
        public E findFirstOrNull() throws QueryMissingOrderException {
            return (E)((TopiaEntity)this.topiaDAO.findFirstOrNull(this.hql, this.hqlParameters));
        }

        @Override
        public Optional<E> tryFindFirst() throws QueryMissingOrderException {
            return this.topiaDAO.tryFindFirst(this.hql, this.hqlParameters);
        }

        @Override
        public E findAny() throws TopiaNoResultException {
            return (E)((TopiaEntity)this.topiaDAO.findAny(this.hql, this.hqlParameters));
        }

        @Override
        public E findAnyOrNull() {
            return (E)((TopiaEntity)this.topiaDAO.findAnyOrNull(this.hql, this.hqlParameters));
        }

        @Override
        public Optional<E> tryFindAny() {
            return this.topiaDAO.tryFindAny(this.hql, this.hqlParameters);
        }

        @Override
        public List<E> findAll() {
            return this.topiaDAO.findAll(this.hql, this.hqlParameters);
        }

        @Override
        public Iterable<E> findAllLazy() {
            return this.topiaDAO.findAllLazy(this.hql + (this.fromHql ? "" : " ORDER BY id"), this.hqlParameters);
        }

        @Override
        public Iterable<E> findAllLazy(int batchSize) {
            return this.topiaDAO.findAllLazy(this.hql + (this.fromHql ? "" : " ORDER BY id"), this.hqlParameters, batchSize);
        }

        @Override
        public List<E> find(int startIndex, int endIndex) {
            return this.topiaDAO.find(this.hql, this.hqlParameters, startIndex, endIndex);
        }

        @Override
        public List<E> find(TopiaPagerBean pager) {
            return this.topiaDAO.find(this.hql, this.hqlParameters, pager);
        }

        @Override
        public List<String> findAllIds() {
            String hqlWithSelectClause = "select topiaId " + this.hql;
            return this.topiaDAO.findAll(hqlWithSelectClause, this.hqlParameters);
        }

        @Override
        public List<String> findIds(int startIndex, int endIndex) {
            String hqlWithSelectClause = "select topiaId " + this.hql;
            return this.topiaDAO.find(hqlWithSelectClause, this.hqlParameters, startIndex, endIndex);
        }

        @Override
        public List<String> findIds(TopiaPagerBean pager) {
            String hqlWithSelectClause = "select topiaId " + this.hql;
            return this.topiaDAO.find(hqlWithSelectClause, this.hqlParameters, pager);
        }
    }

    public static class InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E extends TopiaEntity>
    implements TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> {
        protected AbstractTopiaDao<E> topiaDAO;
        protected HqlAndParametersBuilder<E> hqlAndParametersBuilder;

        protected InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep(AbstractTopiaDao<E> topiaDAO, HqlAndParametersBuilder<E> hqlAndParametersBuilder) {
            this.topiaDAO = topiaDAO;
            this.hqlAndParametersBuilder = hqlAndParametersBuilder;
        }

        @Override
        public InnerTopiaQueryBuilderRunQueryStep<E> setOrderByArguments(Set<String> orderByArguments) {
            this.hqlAndParametersBuilder.setOrderByArguments(orderByArguments);
            return this.getNextStep();
        }

        @Override
        public InnerTopiaQueryBuilderRunQueryStep<E> setOrderByArguments(String ... orderByArguments) {
            this.hqlAndParametersBuilder.setOrderByArguments(orderByArguments);
            return this.getNextStep();
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addEquals(String property, Object value) {
            this.hqlAndParametersBuilder.addEquals(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotEquals(String property, Object value) {
            this.hqlAndParametersBuilder.addNotEquals(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addIn(String property, Collection<?> values) {
            this.hqlAndParametersBuilder.addIn(property, values);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotIn(String property, Collection<?> values) {
            this.hqlAndParametersBuilder.addNotIn(property, values);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addContains(String property, Object value) {
            this.hqlAndParametersBuilder.addContains(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotContains(String property, Object value) {
            this.hqlAndParametersBuilder.addNotContains(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNull(String property) {
            this.hqlAndParametersBuilder.addNull(property);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotNull(String property) {
            this.hqlAndParametersBuilder.addNotNull(property);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdEquals(String property, String topiaId) {
            this.hqlAndParametersBuilder.addTopiaIdEquals(property, topiaId);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdIn(String property, Collection<String> topiaIds) {
            this.hqlAndParametersBuilder.addTopiaIdIn(property, topiaIds);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdNotEquals(String property, String topiaId) {
            this.hqlAndParametersBuilder.addTopiaIdNotEquals(property, topiaId);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdNotIn(String property, Collection<String> topiaIds) {
            this.hqlAndParametersBuilder.addTopiaIdNotIn(property, topiaIds);
            return this;
        }

        @Override
        public boolean exists() {
            return this.getNextStep().exists();
        }

        @Override
        public E findAnyOrNull() {
            return this.getNextStep().findAnyOrNull();
        }

        @Override
        public E findUniqueOrNull() {
            return this.getNextStep().findUniqueOrNull();
        }

        @Override
        public E findAny() {
            return this.getNextStep().findAny();
        }

        @Override
        public E findUnique() {
            return this.getNextStep().findUnique();
        }

        @Override
        public E findFirst() {
            return this.getNextStep().findFirst();
        }

        @Override
        public E findFirstOrNull() {
            return this.getNextStep().findFirstOrNull();
        }

        @Override
        public Optional<E> tryFindAny() {
            return this.getNextStep().tryFindAny();
        }

        @Override
        public Optional<E> tryFindFirst() {
            return this.getNextStep().tryFindFirst();
        }

        @Override
        public Optional<E> tryFindUnique() {
            return this.getNextStep().tryFindUnique();
        }

        @Override
        public List<E> findAll() {
            return this.getNextStep().findAll();
        }

        @Override
        public List<E> find(int startIndex, int endIndex) {
            return this.getNextStep().find(startIndex, endIndex);
        }

        @Override
        public List<E> find(TopiaPagerBean pager) {
            return this.getNextStep().find(pager);
        }

        @Override
        public Iterable<E> findAllLazy() {
            return this.getNextStep().findAllLazy();
        }

        @Override
        public Iterable<E> findAllLazy(int batchSize) {
            return this.getNextStep().findAllLazy(batchSize);
        }

        @Override
        public long count() {
            return this.getNextStep().count();
        }

        @Override
        public List<String> findIds(int startIndex, int endIndex) {
            return this.getNextStep().findIds(startIndex, endIndex);
        }

        @Override
        public List<String> findIds(TopiaPagerBean pager) {
            return this.getNextStep().findIds(pager);
        }

        @Override
        public List<String> findAllIds() {
            return this.getNextStep().findAllIds();
        }

        protected InnerTopiaQueryBuilderRunQueryStep<E> getNextStep() {
            String hql = this.hqlAndParametersBuilder.getHql();
            Map<String, Object> hqlParameters = this.hqlAndParametersBuilder.getHqlParameters();
            InnerTopiaQueryBuilderRunQueryStep<E> nextStep = new InnerTopiaQueryBuilderRunQueryStep<E>(this.topiaDAO, false, hql, hqlParameters);
            return nextStep;
        }
    }

    public static class FindAllIterator<E extends TopiaEntity, K>
    implements Iterator<K> {
        protected Iterator<K> data;
        protected final AbstractTopiaDao<E> dao;
        protected final String hql;
        protected final Map<String, Object> params;
        protected final TopiaPagerBean pager;

        public FindAllIterator(AbstractTopiaDao<E> dao, int batchSize, String hql, Map<String, Object> params) {
            if (!dao.hqlContainsOrderBy(hql)) {
                throw new QueryMissingOrderException(hql, params);
            }
            this.dao = dao;
            this.hql = hql;
            this.params = params;
            this.pager = dao.newPager(hql, params, batchSize);
            this.data = Iterators.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            boolean result = this.data.hasNext() || (long)this.pager.getPageIndex() < this.pager.getPagesNumber();
            return result;
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.data.hasNext()) {
                this.pager.setPageIndex(this.pager.getPageIndex() + 1);
                PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)this.pager);
                List values = this.dao.find(this.hql, this.params, this.pager);
                this.data = values.iterator();
            }
            K next = this.data.next();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support remove operation.");
        }
    }
}

