package org.nuiton.topia.persistence.support;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaServiceSupport.java 2981 2014-01-17 17:38:55Z athimel $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-3/topia-persistence/src/main/java/org/nuiton/topia/persistence/support/TopiaServiceSupport.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Map;

import org.nuiton.topia.persistence.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaService;

/**
 * This API provides methods to manipulate services
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 * @since 3.0
 */
public interface TopiaServiceSupport {

    /**
     * Return true if specific service is available.
     *
     * @param interfaceService fqn of the service
     * @return the service
     */
    <E extends TopiaService> boolean serviceEnabled(Class<E> interfaceService);

    /**
     * Return the service. This service must be valid with public static final
     * SERVICE_NAME property.
     *
     * @param interfaceService class of the service
     * @return the service
     * @throws TopiaNotFoundException if service can't be retrieved
     */
    <E extends TopiaService> E getService(Class<E> interfaceService) throws TopiaNotFoundException;

    /**
     * The list of registered services. The map key is the service name, and the value is the service instance.
     *
     * @return a map with {serviceName, serviceInstance} values
     */
    Map<String, TopiaService> getServices();

}
