/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.HashMap;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.PrintCodeVisitor;

public class TraceCodeVisitor
extends PrintCodeVisitor {
    protected final CodeVisitor cv;
    private final HashMap labelNames;

    public TraceCodeVisitor(CodeVisitor codeVisitor) {
        this.cv = codeVisitor;
        this.labelNames = new HashMap();
    }

    public void printInsn(int n) {
        this.buf.append("    ").append(OPCODES[n]).append("\n");
        if (this.cv != null) {
            this.cv.visitInsn(n);
        }
    }

    public void printIntInsn(int n, int n2) {
        this.buf.append("    ").append(OPCODES[n]).append(" ").append(n2).append("\n");
        if (this.cv != null) {
            this.cv.visitIntInsn(n, n2);
        }
    }

    public void printVarInsn(int n, int n2) {
        this.buf.append("    ").append(OPCODES[n]).append(" ").append(n2).append("\n");
        if (this.cv != null) {
            this.cv.visitVarInsn(n, n2);
        }
    }

    public void printTypeInsn(int n, String string) {
        this.buf.append("    ").append(OPCODES[n]).append(" ").append(string).append("\n");
        if (this.cv != null) {
            this.cv.visitTypeInsn(n, string);
        }
    }

    public void printFieldInsn(int n, String string, String string2, String string3) {
        this.buf.append("    ").append(OPCODES[n]).append(" ").append(string).append(" ").append(string2).append(" ").append(string3).append("\n");
        if (this.cv != null) {
            this.cv.visitFieldInsn(n, string, string2, string3);
        }
    }

    public void printMethodInsn(int n, String string, String string2, String string3) {
        this.buf.append("    ").append(OPCODES[n]).append(" ").append(string).append(" ").append(string2).append(" ").append(string3).append("\n");
        if (this.cv != null) {
            this.cv.visitMethodInsn(n, string, string2, string3);
        }
    }

    public void printJumpInsn(int n, Label label) {
        this.buf.append("    ").append(OPCODES[n]).append(" ");
        this.appendLabel(label);
        this.buf.append("\n");
        if (this.cv != null) {
            this.cv.visitJumpInsn(n, label);
        }
    }

    public void printLabel(Label label) {
        this.buf.append("   ");
        this.appendLabel(label);
        this.buf.append("\n");
        if (this.cv != null) {
            this.cv.visitLabel(label);
        }
    }

    public void printLdcInsn(Object object) {
        this.buf.append("    LDC ");
        if (object instanceof String) {
            this.buf.append("\"").append(object).append("\"");
        } else if (object instanceof Type) {
            this.buf.append(((Type)object).getDescriptor() + ".class");
        } else {
            this.buf.append(object);
        }
        this.buf.append("\n");
        if (this.cv != null) {
            this.cv.visitLdcInsn(object);
        }
    }

    public void printIincInsn(int n, int n2) {
        this.buf.append("    IINC ").append(n).append(" ").append(n2).append("\n");
        if (this.cv != null) {
            this.cv.visitIincInsn(n, n2);
        }
    }

    public void printTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        this.buf.append("    TABLESWITCH\n");
        for (int i = 0; i < labelArray.length; ++i) {
            this.buf.append("      ").append(n + i).append(": ");
            this.appendLabel(labelArray[i]);
            this.buf.append("\n");
        }
        this.buf.append("      default: ");
        this.appendLabel(label);
        this.buf.append("\n");
        if (this.cv != null) {
            this.cv.visitTableSwitchInsn(n, n2, label, labelArray);
        }
    }

    public void printLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.buf.append("    LOOKUPSWITCH\n");
        for (int i = 0; i < labelArray.length; ++i) {
            this.buf.append("      ").append(nArray[i]).append(": ");
            this.appendLabel(labelArray[i]);
            this.buf.append("\n");
        }
        this.buf.append("      default: ");
        this.appendLabel(label);
        this.buf.append("\n");
        if (this.cv != null) {
            this.cv.visitLookupSwitchInsn(label, nArray, labelArray);
        }
    }

    public void printMultiANewArrayInsn(String string, int n) {
        this.buf.append("    MULTIANEWARRAY ").append(string).append(" ").append(n).append("\n");
        if (this.cv != null) {
            this.cv.visitMultiANewArrayInsn(string, n);
        }
    }

    public void printTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.buf.append("    TRYCATCHBLOCK ");
        this.appendLabel(label);
        this.buf.append(" ");
        this.appendLabel(label2);
        this.buf.append(" ");
        this.appendLabel(label3);
        this.buf.append(" ").append(string).append("\n");
        if (this.cv != null) {
            this.cv.visitTryCatchBlock(label, label2, label3, string);
        }
    }

    public void printMaxs(int n, int n2) {
        this.buf.append("    MAXSTACK = ").append(n).append("\n    MAXLOCALS = ").append(n2).append("\n\n");
        if (this.cv != null) {
            this.cv.visitMaxs(n, n2);
        }
    }

    public void printLocalVariable(String string, String string2, Label label, Label label2, int n) {
        this.buf.append("    LOCALVARIABLE ").append(string).append(" ").append(string2).append(" ");
        this.appendLabel(label);
        this.buf.append(" ");
        this.appendLabel(label2);
        this.buf.append(" ").append(n).append("\n");
        if (this.cv != null) {
            this.cv.visitLocalVariable(string, string2, label, label2, n);
        }
    }

    public void printLineNumber(int n, Label label) {
        this.buf.append("    LINENUMBER ").append(n).append(" ");
        this.appendLabel(label);
        this.buf.append("\n");
        if (this.cv != null) {
            this.cv.visitLineNumber(n, label);
        }
    }

    public void printAttribute(Attribute attribute) {
        this.buf.append("    CODE ATTRIBUTE ").append(attribute.type).append(" : ").append(attribute.toString()).append("\n");
        if (this.cv != null) {
            this.cv.visitAttribute(attribute);
        }
    }

    private void appendLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = "L" + this.labelNames.size();
            this.labelNames.put(label, string);
        }
        this.buf.append(string);
    }
}

