/*
 * #%L
 * Nuiton Processor :: Api
 * 
 * $Id: ActiveLogsCodeFilter.java 377 2011-02-03 10:40:42Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/processor/tags/processor-1.2.1/nuiton-processor/src/main/java/org/nuiton/processor/filters/ActiveLogsCodeFilter.java $
 * %%
 * Copyright (C) 2002 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */


/* x*
* ActiveLogsCodeFilter.java
*
* Created: Wed Jan 14 2004
*
* @author  <poussin@codelutin.com>
* Copyright Code Lutin
* @version $Revision: 377 $
*
* Mise a jour: $Date: 2011-02-03 11:40:42 +0100 (Thu, 03 Feb 2011) $
* par : $Author: tchemit $
*/

package org.nuiton.processor.filters;

/*
* This class deals with the
*/
public class ActiveLogsCodeFilter extends LogsFilter {

    /**
     * methode appele lorsqu'on a la chaine entiere entre le header
     * et le footer.
     *
     * @param ch la chaine trouve
     * @return ce qu'il faut ecrire dans le fichier de sortie
     */
    @Override
    protected String performInFilter(String ch) {
        // Logs must be performed within a try{...}catch{} bloc
        return
                "try {\n" +
                ch +
                "} catch (Exception logsE) {\n" +
                "    System.err.println(\"Error in Logging instructions\");\n" +
                "    logsE.printStackTrace();\n" +
                "}";
    }

    /**
     * methode appele lorsqu'on a la chaine entiere a l'exterieur du
     * header/footer
     *
     * @param ch la chaine trouve
     * @return ce qu'il faut ecrire dans le fichier de sortie
     */
    @Override
    protected String performOutFilter(String ch) {
        return ch;
    }

}
