/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

public class BinderFactory {
    private static final Log log = LogFactory.getLog(BinderFactory.class);
    protected static BindelModelEntryMap binderModels;

    public static <S> Binder<S, S> newBinder(Class<S> sourceType) {
        return BinderFactory.newBinder0(sourceType, sourceType, null, Binder.class);
    }

    public static <S> Binder<S, S> newBinder(Class<S> sourceType, String contextName) {
        return BinderFactory.newBinder0(sourceType, sourceType, contextName, Binder.class);
    }

    public static <S, T> Binder<S, T> newBinder(Class<S> sourceType, Class<T> targetType) {
        return BinderFactory.newBinder0(sourceType, targetType, null, Binder.class);
    }

    public static <S, T> Binder<S, T> newBinder(Class<S> sourceType, Class<T> targetType, String contextName) {
        return BinderFactory.newBinder0(sourceType, targetType, contextName, Binder.class);
    }

    public static <S, T, B extends Binder<S, T>> B newBinder(Class<S> sourceType, Class<T> targetType, String contextName, Class<B> binderType) {
        Binder<S, T> binder = BinderFactory.newBinder0(sourceType, targetType, contextName, binderType);
        return (B)binder;
    }

    public static <S, T> Binder.BinderModel<S, T> registerBinderModel(BinderModelBuilder<S, T> binderModelBuilder) throws IllegalArgumentException {
        Binder.BinderModel<S, T> model = BinderFactory.registerBinderModel(binderModelBuilder, null);
        return model;
    }

    public static <S, T> Binder.BinderModel<S, T> registerBinderModel(Binder<S, T> binder) throws IllegalArgumentException {
        Binder.BinderModel<S, T> model = BinderFactory.registerBinderModel(binder, null);
        return model;
    }

    public static <S, T> Binder.BinderModel<S, T> registerBinderModel(Binder.BinderModel<S, T> model) throws IllegalArgumentException {
        BinderFactory.registerBinderModel(model, null);
        return model;
    }

    public static <S, T> Binder.BinderModel<S, T> registerBinderModel(BinderModelBuilder<S, T> binderModelBuilder, String contextName) throws IllegalArgumentException {
        Binder.BinderModel<S, T> model = binderModelBuilder.getModel();
        BinderFactory.registerBinderModel(model, contextName);
        return model;
    }

    public static <S, T> Binder.BinderModel<S, T> registerBinderModel(Binder<S, T> binder, String contextName) throws IllegalArgumentException {
        Binder.BinderModel<S, T> model = binder.getModel();
        BinderFactory.registerBinderModel(model, contextName);
        return model;
    }

    public static <S, T> Binder.BinderModel<S, T> registerBinderModel(Binder.BinderModel<S, T> model, String contextName) throws IllegalArgumentException {
        Binder.BinderModel<S, T> registredModel = BinderFactory.getBinderModels().get(model, contextName);
        BinderModelEntry key = new BinderModelEntry(model, contextName);
        if (registredModel != null && log.isWarnEnabled()) {
            log.warn("Remove existing binder model from cache : " + BinderFactory.toString(registredModel, contextName));
        }
        BinderFactory.getBinderModels().put(key, model);
        return model;
    }

    public static <S, T, B extends Binder<S, T>> B newBinder(Binder.BinderModel<S, T> model, Class<B> binderType) {
        Binder binder;
        try {
            binder = (Binder)binderType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instanciate binder of type " + binderType, e);
        }
        binder.setModel(model);
        return (B)binder;
    }

    public static void clear() {
        if (binderModels != null) {
            binderModels.clear();
            binderModels = null;
        }
    }

    public static <S, T> boolean isBinderModelExists(Class<S> sourceType, Class<T> targetType, String contextName) {
        Binder.BinderModel<S, T> model = BinderFactory.getBinderModels().get(sourceType, targetType, contextName);
        return model != null;
    }

    public static <S, T> Binder.BinderModel<S, T> getCachedBinderModel(Class<S> sourceType, Class<T> targetType, String contextName) {
        Binder.BinderModel<S, T> model = BinderFactory.getBinderModels().get(sourceType, targetType, contextName);
        return model;
    }

    protected static BindelModelEntryMap getBinderModels() {
        if (binderModels == null) {
            binderModels = new BindelModelEntryMap();
        }
        return binderModels;
    }

    protected static String toString(Binder.BinderModel<?, ?> model, String contextName) {
        return BinderFactory.toString(model.getSourceType(), model.getTargetType(), contextName);
    }

    protected static String toString(Class<?> sourceType, Class<?> targetType, String contextName) {
        return "<" + sourceType.getName() + " - " + targetType.getName() + " > [" + contextName + "] ";
    }

    protected static <S, T, B extends Binder<S, T>> Binder<S, T> newBinder0(Class<S> sourceType, Class<T> targetType, String contextName, Class<B> binderType) {
        Binder.BinderModel<S, T> model = BinderFactory.getBinderModels().get(sourceType, targetType, contextName);
        if (model == null) {
            if (log.isInfoEnabled()) {
                log.info("No binder model found for " + BinderFactory.toString(sourceType, targetType, contextName) + ", will create a new default one.");
            }
            BinderModelBuilder<S, T> builder = BinderModelBuilder.newDefaultBuilder(sourceType, targetType);
            model = BinderFactory.registerBinderModel(builder, contextName);
        }
        B binder = BinderFactory.newBinder(model, binderType);
        return binder;
    }

    public static class BinderModelEntry {
        protected final Class<?> sourceType;
        protected final Class<?> targetType;
        protected final String name;

        public BinderModelEntry(Class<?> sourceType, Class<?> targetType, String name) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.name = name;
        }

        public BinderModelEntry(Binder.BinderModel<?, ?> model, String contextName) {
            this(model.getSourceType(), model.getTargetType(), contextName);
        }

        public Class<?> getSourceType() {
            return this.sourceType;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BinderModelEntry that = (BinderModelEntry)o;
            return (this.name == null ? that.name == null : this.name.equals(that.name)) && this.sourceType.equals(that.sourceType) && this.targetType.equals(that.targetType);
        }

        public int hashCode() {
            int result = this.sourceType.hashCode();
            result = 31 * result + this.targetType.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("<");
            buffer.append(super.toString());
            buffer.append(", sourceType: ").append(this.getSourceType()).append(',');
            buffer.append(" targetType: ").append(this.getTargetType()).append(',');
            buffer.append(" name: ").append(this.getName()).append('>');
            return buffer.toString();
        }
    }

    public static class BindelModelEntryMap
    implements Map<BinderModelEntry, Binder.BinderModel<?, ?>> {
        protected final Map<BinderModelEntry, Binder.BinderModel<?, ?>> delegate = new HashMap();

        public <S, T> Binder.BinderModel<S, T> get(Class<S> source, Class<T> target, String contextName) {
            Object result = null;
            for (BinderModelEntry key : binderModels.keySet()) {
                if (!key.getSourceType().equals(source) || !key.getTargetType().equals(target) || (key.getName() == null ? contextName != null : !key.getName().equals(contextName))) continue;
                result = binderModels.get(key);
                break;
            }
            return result;
        }

        public <S, T> Binder.BinderModel<S, T> get(Binder.BinderModel<S, T> model, String contextName) {
            Class<S> source = model.getSourceType();
            Class<T> target = model.getTargetType();
            Binder.BinderModel<S, T> result = this.get(source, target, contextName);
            return result;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public Binder.BinderModel<?, ?> get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public Binder.BinderModel<?, ?> put(BinderModelEntry key, Binder.BinderModel<?, ?> value) {
            return this.delegate.put(key, value);
        }

        @Override
        public Binder.BinderModel<?, ?> remove(Object key) {
            return this.delegate.remove(key);
        }

        @Override
        public void putAll(Map<? extends BinderModelEntry, ? extends Binder.BinderModel<?, ?>> m3) {
            this.delegate.putAll(m3);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<BinderModelEntry> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<Binder.BinderModel<?, ?>> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<BinderModelEntry, Binder.BinderModel<?, ?>>> entrySet() {
            return this.delegate.entrySet();
        }
    }
}

