/*
 * #%L
 * Maven Nuiton Skin
 * 
 * $Id: ScmwebeditorUtils.java 646 2011-08-19 16:26:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-nuiton-skin/tags/maven-nuiton-skin-1.1.2/src/main/java/org/nuiton/maven/skin/ScmwebeditorUtils.java $
 * %%
 * Copyright (C) 2006 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.maven.skin;

import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.codehaus.plexus.logging.Logger;

import java.io.File;
import java.util.List;
import java.util.Locale;

/**
 * A tool to be used in the velocity template.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.6
 */
public class ScmwebeditorUtils {

    private Logger logger;

    private VelocityContext context;

    private List<Locale> locales;

    private Locale locale;

    private String scmwebeditorPrefixURL;

    private String siteXmlScmwebeditorURL;

    private String siteSourcesType;

    private MavenProject mavenProject;

    private String currentFileName;

    private File file;

    private String scmwebeditorFileURL;

    public ScmwebeditorUtils(VelocityContext context, Logger logger) {
        this.context = context;
        this.logger = logger;

        currentFileName = (String) context.get("currentFileName");
    }

    public void buildStates() {

        File file = getFile(currentFileName);
        boolean exist = file.exists();
        boolean withVm = false;
        if (!exist) {

            // perharps the file have .vm extension
            file = new File(file.getAbsolutePath() + ".vm");
            if (file.exists()) {

                // this is velocity file!
                exist = true;
                withVm = true;
            }
        }

        if (exist) {

            // file exists (so can be edited)
            getLogger().debug("[" + currentFileName + "] on filesystem = " + file);
            this.file = file;

            // compute here the scmwebeditor link
            String relativePath = getRelativePath(currentFileName, '/');
            if (withVm) {

                // on a velocity file
                relativePath += ".vm";
            }

            scmwebeditorFileURL = scmwebeditorPrefixURL + relativePath;
            getLogger().debug("[" + currentFileName + "] scmwebeditor url = " + scmwebeditorFileURL);
        }
    }

    public void setContext(VelocityContext context) {
        this.context = context;
    }

    public void setLocales(List<Locale> locales) {
        this.locales = locales;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setScmwebeditorPrefixURL(String scmwebeditorPrefixURL) {
        this.scmwebeditorPrefixURL = scmwebeditorPrefixURL;
    }

    public void setSiteSourcesType(String siteSourcesType) {
        this.siteSourcesType = siteSourcesType;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public void setSiteXmlScmwebeditorURL(String siteXmlScmwebeditorURL) {
        this.siteXmlScmwebeditorURL = siteXmlScmwebeditorURL;
    }

    public String getSiteXmlScmwebeditorURL() {
        return siteXmlScmwebeditorURL;
    }

    public boolean isCurrentFileEditable() {
        boolean exist = file != null;
        return exist;
    }

    public String getCurrentFileScmwebeditorURL() {
        return scmwebeditorFileURL;
    }

    protected VelocityContext getContext() {
        return context;
    }

    protected Logger getLogger() {
        return logger;
    }

    protected MavenProject getProject() {
        return mavenProject;
    }

    protected String getCurrentFileName() {
        return currentFileName;
    }

    protected boolean isFirstLocale() {
        return locale.equals(locales.get(0));
    }

    protected String getRelativePath(String editFile,
                                     char separator) {

        int lastIndex = editFile.lastIndexOf(".") + 1;
        if (lastIndex > 0) {
            editFile = editFile.substring(0, lastIndex);
        }

        String result = "src" + separator + "site" + separator;
        if (!isFirstLocale()) {
            result += locale.toString() + separator;
        }

        result += siteSourcesType + separator;
        result += editFile + siteSourcesType;
        return result;
    }

    protected File getFile(String editFile) {
        File basedir = getProject().getBasedir();

        String relativePath = getRelativePath(editFile, File.separatorChar);

        File result = new File(basedir, relativePath);
        return result;
    }

}
