/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.announcement;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.jredmine.plugin.announcement.AnnouncementGenerator;
import org.nuiton.plugin.PluginHelper;

public abstract class AbstractAnnouncementMojo
extends AbstractRedmineMojo {
    protected File templateOutputDirectory;
    protected File xmlPath;
    protected String templateDirectory;
    protected String templateEncoding;
    protected Map<String, Object> announceParameters;
    protected String groupId;
    protected String artifactId;
    protected String projectUrl;
    protected String packaging;
    protected String finalName;
    protected String basedir;
    protected String urlDownload;
    protected String developmentTeam;
    protected String introduction;
    protected boolean runOnce;
    protected VelocityComponent velocity;

    protected abstract String getAnnouncementTemplate();

    protected AbstractAnnouncementMojo() {
        super(true, false, true);
    }

    @Override
    protected boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    protected boolean checkRunOnceDone() {
        String template = this.getAnnouncementTemplate();
        File out = new File(this.templateOutputDirectory, template);
        Date buildStartTime = this.session == null ? null : this.session.getStartTime();
        Date newStartTime = out.exists() ? new Date(out.lastModified()) : null;
        boolean checkRunOnceDone = this.checkRunOnceDone(this.runOnce, true, buildStartTime, newStartTime);
        return checkRunOnceDone;
    }

    @Override
    protected void init() throws Exception {
        this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return;
            }
        }
        if (!this.xmlPath.exists()) {
            throw new MojoExecutionException("can not find redmine-template at " + this.xmlPath);
        }
        if (StringUtils.isEmpty((String)this.templateEncoding)) {
            this.templateEncoding = ReaderFactory.FILE_ENCODING;
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + this.templateEncoding + ", i.e. build is platform dependent!"));
        }
        if (StringUtils.isEmpty((String)this.introduction)) {
            this.introduction = this.project.getUrl();
        }
        super.init();
    }

    @Override
    protected void doAction() throws Exception {
        ChangesXML changesXml = new ChangesXML(this.xmlPath, this.getLog());
        List releases = changesXml.getReleaseList();
        String template = this.getAnnouncementTemplate();
        File out = new File(this.templateOutputDirectory, template);
        this.getLog().info((CharSequence)("Apply template [" + template + "]"));
        this.getLog().info((CharSequence)(" from : " + this.xmlPath));
        this.getLog().info((CharSequence)(" to   : " + out));
        VelocityEngine engine = this.velocity.getEngine();
        engine.setApplicationAttribute((Object)"baseDirectory", (Object)this.basedir);
        AnnouncementGenerator generator = new AnnouncementGenerator(this.getLog(), this.projectUrl, "");
        Context context = this.createVelocityContext(generator, releases);
        generator.doGenerate(engine, context, out, this.templateDirectory + "/" + template, this.templateEncoding);
        this.getLog().debug((CharSequence)("Created  announcement [" + template + "] in  " + out));
    }

    public Context createVelocityContext(AnnouncementGenerator generator, List<?> releases) throws MojoExecutionException {
        VelocityContext context = new VelocityContext();
        context.put("releases", releases);
        context.put("groupId", (Object)this.groupId);
        context.put("artifactId", (Object)this.artifactId);
        context.put("version", (Object)this.versionId);
        context.put("packaging", (Object)this.packaging);
        context.put("url", (Object)this.projectUrl);
        Release release = generator.getLatestRelease(releases, this.versionId);
        context.put("release", (Object)release);
        context.put("introduction", (Object)this.introduction);
        context.put("developmentTeam", (Object)this.developmentTeam);
        context.put("finalName", (Object)this.finalName);
        context.put("urlDownload", (Object)this.urlDownload);
        context.put("project", (Object)this.project);
        if (this.announceParameters == null) {
            context.put("announceParameters", (Object)Collections.EMPTY_MAP);
        } else {
            context.put("announceParameters", this.announceParameters);
        }
        return context;
    }
}

