/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.model.I18nAble;
import org.nuiton.jredmine.model.IdAble;
import org.nuiton.jredmine.model.RedmineModelEnum;
import org.nuiton.jredmine.model.RedmineModelScope;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;

public class DisplayDataMojo
extends AbstractRedmineMojo {
    protected String types;
    protected List<RedmineModelEnum> actions;

    public DisplayDataMojo() {
        super(false, false, false);
        this.setAnonymous(true);
    }

    @Override
    protected boolean checkRunOnceDone() {
        return false;
    }

    @Override
    protected boolean isGoalSkip() {
        return false;
    }

    @Override
    protected boolean isRunOnce() {
        return false;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (!this.safe && !this.initOk) {
            return;
        }
        this.actions = this.getDownloadActions(this.types, RedmineModelEnum.project, RedmineModelEnum.version, RedmineModelEnum.issueStatus, RedmineModelEnum.issuePriority, RedmineModelEnum.issueCategory, RedmineModelEnum.tracker, RedmineModelEnum.user);
    }

    @Override
    protected boolean checkSkip() {
        boolean b = super.checkSkip();
        if (!b) {
            return false;
        }
        if (this.actions == null || this.actions.isEmpty()) {
            this.getLog().warn((CharSequence)"no data types detected, you must fill the required parameter dataTypes, will skip goal");
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        StringBuilder buffer = new StringBuilder("\n");
        for (RedmineModelEnum entry : this.actions) {
            RedmineModelScope scope = entry.getScope();
            String requestName = entry.getRequestAll();
            Object[] datas = ((RedmineServiceImplementor)this.service).getDatas(requestName, entry.getModelType(), new Object[]{this.projectId, this.versionId});
            buffer.append("\nValues of '").append(entry).append('\'');
            if (scope == RedmineModelScope.project || scope == RedmineModelScope.version) {
                buffer.append(" for project ").append(this.projectId);
            }
            buffer.append('\n');
            for (Object data : datas) {
                buffer.append("  - ").append(((IdAble)data).getId()).append(" = ").append(((I18nAble)data).getName()).append('\n');
            }
        }
        System.out.println(buffer.toString());
    }

    protected List<RedmineModelEnum> getDownloadActions(String dataTypes, RedmineModelEnum ... universe) throws MojoFailureException {
        ArrayList<RedmineModelEnum> results = new ArrayList<RedmineModelEnum>();
        ArrayList<RedmineModelEnum> universeList = new ArrayList<RedmineModelEnum>(Arrays.asList(universe));
        for (String dataType : dataTypes.split(",")) {
            RedmineModelEnum result;
            try {
                result = RedmineModelEnum.valueOf((String)dataType.trim());
            }
            catch (Exception e) {
                throw new MojoFailureException("could not obtain data type " + dataType + " in " + Arrays.toString(RedmineModelEnum.values()));
            }
            RedmineModelScope scope = result.getScope();
            if (!(scope != RedmineModelScope.project && scope != RedmineModelScope.version || this.projectId != null && !this.projectId.isEmpty())) {
                throw new MojoFailureException("could not use the data type " + result + " since it is not a project requires and projectId was not filled");
            }
            if (scope == RedmineModelScope.version && (this.versionId == null || this.versionId.isEmpty())) {
                throw new MojoFailureException("could not use the data type " + result + " since it a version requires and versionId was not filled");
            }
            if (!universeList.isEmpty() && !universeList.contains(result)) {
                this.getLog().warn((CharSequence)("the type " + result + " is not authorized, universe : " + universeList));
                continue;
            }
            results.add(result);
        }
        return results;
    }
}

