/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.io.File;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.plugin.PluginHelper;

public class PublishNewsMojo
extends AbstractRedmineMojo {
    private File newsContentFile;
    private String newsSummary;
    private String newsTitle;
    private boolean skipPublishNews;
    protected boolean dryRun;
    private boolean runOnce;

    public PublishNewsMojo() {
        super(true, false, true);
    }

    @Override
    protected boolean isGoalSkip() {
        return this.skipPublishNews;
    }

    @Override
    protected boolean checkRunOnceDone() {
        return this.isRunOnce() && !this.isExecutionRoot();
    }

    @Override
    protected boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    protected boolean init() throws Exception {
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return true;
            }
        }
        if (!super.init()) {
            return false;
        }
        if (this.newsSummary == null || this.newsSummary.trim().isEmpty()) {
            this.newsSummary = this.project.getUrl();
        }
        if (!this.newsContentFile.exists()) {
            this.getLog().warn((CharSequence)("could not find the template " + this.newsContentFile));
            return false;
        }
        this.newsTitle = this.newsTitle.trim();
        if (this.newsTitle.length() > 60) {
            this.getLog().warn((CharSequence)("News title can not be longer than 60 cars, but was " + this.newsTitle.length()));
            this.newsTitle = this.newsTitle = this.newsTitle.substring(0, 59);
            this.getLog().warn((CharSequence)("will use the restricted title : " + this.newsTitle));
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        if (this.isRunOnceDone()) {
            this.getLog().info((CharSequence)"skip goal, runOnce flag is on, and was already executed.");
            return;
        }
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no data will be send!\n");
        }
        News news = new News();
        news.setAuthorId(this.releaseUser.getId());
        news.setProjectId(this.releaseProject.getId());
        news.setTitle(this.newsTitle);
        news.setSummary(this.newsSummary);
        String newsContent = PluginHelper.readAsString((File)this.newsContentFile, (String)this.encoding);
        news.setDescription(newsContent);
        if (this.dryRun) {
            this.getLog().info((CharSequence)("news title   : " + news.getTitle()));
            this.getLog().info((CharSequence)("news summary : " + news.getSummary()));
            this.getLog().info((CharSequence)("news content :\n" + newsContent));
            return;
        }
        this.getLog().info((CharSequence)("publish news " + news.getTitle()));
        if (this.verbose) {
            this.getLog().info((CharSequence)("redmine announcement :\n" + newsContent));
        }
        news = this.service.addNews(this.releaseProject.getName(), news);
        if (this.verbose) {
            this.getLog().info((CharSequence)("done. news id : " + news.getId()));
        }
    }
}

