/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.nuiton.helper.plugin.CollectFilesMojo;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.plugin.PluginHelper;

public class PublishAttachmentsMojo
extends AbstractRedmineMojo {
    protected File filesFromProperties;
    protected File[] files;
    protected boolean skipPublishAttachments;
    protected boolean dryRun;
    protected boolean runOnce;
    protected List<File> allFiles;

    public PublishAttachmentsMojo() {
        super(true, true, true);
    }

    @Override
    protected boolean isGoalSkip() {
        return this.skipPublishAttachments;
    }

    @Override
    protected boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    protected boolean checkRunOnceDone() {
        return this.isRunOnce() && !this.isExecutionRoot();
    }

    @Override
    protected boolean init() throws Exception {
        this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return true;
            }
        }
        if (!super.init()) {
            return false;
        }
        if (this.filesFromProperties != null && !this.filesFromProperties.exists()) {
            this.getLog().warn((CharSequence)("could not find the properties file " + this.filesFromProperties));
            this.getLog().warn((CharSequence)"will not use this source");
            this.filesFromProperties = null;
        }
        if (this.filesFromProperties != null && this.files != null && this.files.length > 0) {
            this.getLog().warn((CharSequence)"can not use both sources files and filesFromProperties");
            return false;
        }
        this.allFiles = this.filesFromProperties != null ? this.getFilesToDeploy() : Arrays.asList(this.files);
        if (this.allFiles.isEmpty()) {
            this.getLog().warn((CharSequence)"No files to send.");
            this.getLog().warn((CharSequence)"will skip publish news to redmine...");
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        if (this.isRunOnceDone()) {
            this.getLog().info((CharSequence)"Skipping goal, runOnce flag is on and goal was already executed.");
            return;
        }
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no data will be send!\n");
        }
        String basedir = this.project.getBasedir().getAbsolutePath();
        int basedirLength = basedir.length() + 1;
        for (File f : this.allFiles) {
            if (!f.exists()) {
                this.getLog().warn((CharSequence)("can not upload a non existing file " + f));
                continue;
            }
            if (f.getAbsolutePath().startsWith(basedir)) {
                this.getLog().info((CharSequence)("upload " + f.getAbsolutePath().substring(basedirLength)));
            } else {
                this.getLog().info((CharSequence)("upload " + f.getAbsolutePath()));
            }
            if (this.dryRun) continue;
            long t0 = System.nanoTime();
            Attachment a = new Attachment();
            a.setFilename(f.getName());
            a.setAuthorId(this.releaseUser.getId());
            a.setContainerId(this.releaseVersion.getId());
            a.setToUpload(f);
            Attachment result = this.service.addAttachment(this.projectId, this.releaseVersion.getName(), a);
            long t1 = System.nanoTime();
            if (!this.verbose) continue;
            this.getLog().info((CharSequence)("done in  " + PluginHelper.convertTime((long)(t1 - t0)) + ". attachment id : " + result.getId() + ", size : " + PluginHelper.convertMemory((long)result.getFilesize())));
        }
    }

    protected List<File> getFilesToDeploy() throws MojoExecutionException {
        List incoming = null;
        try {
            incoming = new CollectFilesMojo().getFiles(this.filesFromProperties);
            this.getLog().info((CharSequence)("Loaded " + this.filesFromProperties));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not load file " + this.filesFromProperties, (Exception)ex);
        }
        Collections.sort(incoming, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return incoming;
    }
}

