/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.Artifact;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;

public class I18nArtifact {
    static final Log log = LogFactory.getLog(I18nArtifact.class);
    protected final Artifact artifact;
    protected final URL url;
    protected I18nBundle[] bundles;

    public I18nArtifact(Artifact artifact) throws MalformedURLException {
        this.artifact = artifact;
        this.url = artifact.getFile().toURI().toURL();
    }

    public I18nArtifact(Artifact artifact, File file) throws MalformedURLException {
        this.artifact = artifact;
        this.url = file.toURI().toURL();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public URL getUrl() {
        return this.url;
    }

    public I18nBundleEntry[] getBundleEntries(Locale l, Locale defaultLocale) {
        if (this.bundles == null) {
            throw new NullPointerException("le bundleManager n'a pas ete initialise!");
        }
        return I18nBundleUtil.getBundleEntries((Locale)l, (Locale)defaultLocale, (I18nBundle[])this.bundles);
    }

    public boolean detectBundles() throws IOException {
        URL[] i18nUrls = I18nBundleUtil.getURLs((URL[])new URL[]{this.url});
        if (i18nUrls == null || i18nUrls.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("no i18n url for artifact " + this.artifact));
            }
            return false;
        }
        List listBundles = I18nBundleUtil.detectBundles((URL[])i18nUrls);
        if (listBundles.isEmpty()) {
            return false;
        }
        this.bundles = listBundles.toArray(new I18nBundle[listBundles.size()]);
        return true;
    }

    public String toString() {
        return this.artifact.getGroupId() + ":" + this.artifact.getArtifactId() + ":" + this.artifact.getVersion();
    }
}

