/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle.csv;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.i18n.plugin.I18nUtil;
import org.nuiton.i18n.plugin.bundle.csv.AbstractCsvBundleMojo;
import org.nuiton.i18n.plugin.bundle.csv.I18nBundleModel;
import org.nuiton.i18n.plugin.bundle.csv.I18nBundleModelRow;
import org.nuiton.io.SortedProperties;

@Mojo(name="merge-back-csv-bundle", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class MergeBackCsvBundleMojo
extends AbstractCsvBundleMojo {
    @Parameter(property="i18n.mergeNewKeys", defaultValue="false")
    protected boolean mergeNewKeys;
    @Parameter(property="i18n.src", defaultValue="${project.basedir}/src/main/resources/i18n", required=true)
    protected File src;
    @Parameter(property="i18n.artifactId", defaultValue="${project.artifactId}", readonly=true)
    protected String artifactId;
    @Parameter(property="i18n.bundleCsvFile", required=true)
    protected File bundleCsvFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        LinkedList rows;
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - locales         : " + Arrays.toString(this.locales)));
            this.getLog().info((CharSequence)("config - csv separator   : " + this.bundleCsvSeparator));
            this.getLog().info((CharSequence)("config - csv file        : " + this.bundleCsvFile));
            this.getLog().info((CharSequence)("config - merge directory : " + this.src));
        }
        I18nBundleModel importModel = new I18nBundleModel(this.bundleCsvSeparator, this.locales);
        FileInputStream inputStream = FileUtils.openInputStream((File)this.bundleCsvFile);
        try {
            Import newImport = Import.newImport((ImportModel)importModel, (InputStream)inputStream);
            rows = Lists.newLinkedList((Iterable)newImport);
            inputStream.close();
            newImport.close();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        for (Locale locale : this.locales) {
            File bundleFile = I18nUtil.getI18nFile(this.src, this.artifactId, locale, false);
            SortedProperties properties = new SortedProperties(this.encoding);
            properties.load(bundleFile, this.encoding);
            for (I18nBundleModelRow row : rows) {
                String key = row.getKey();
                boolean keyIsPresent = properties.containsKey((Object)key);
                if (!this.mergeNewKeys && !keyIsPresent) continue;
                properties.put((Object)key, (Object)row.getLocaleValue(locale));
            }
            if (!this.isSilent()) {
                this.getLog().info((CharSequence)String.format("Merge locale bundle %s in %s", locale, bundleFile));
            }
            properties.store(bundleFile);
        }
    }
}

