/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.AbstractI18nParserMojo;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.i18n.plugin.parser.impl.ProcessorHelper;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.MirroredFileUpdater;
import org.nuiton.io.SortedProperties;
import org.nuiton.processor.ProcessorUtil;

@Mojo(name="parserGWTJava", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ParserGWTJavaMojo
extends AbstractI18nParserMojo {
    public static final String DEFAULT_INCLUDES = "**/*.java";
    @Parameter(property="i18n.defaultBasedir", defaultValue="${basedir}/src/main/java")
    protected File defaultBasedir;
    @Parameter(property="i18n.defaultIncludes", defaultValue="**/*.java", required=true)
    protected String defaultIncludes;
    @Parameter(property="i18n.outputGetter", defaultValue="gwt-java.getter")
    protected String outputGetter;
    @Parameter(property="i18n.workdir", defaultValue="${basedir}/target/i18n-workdir")
    protected File workdir;
    protected MirroredFileUpdater entryUpdater;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    protected boolean onEnterEntry(I18nSourceEntry entry) {
        boolean b = super.onEnterEntry(entry);
        if (!b) {
            this.entryUpdater = (MirroredFileUpdater)entry.getUpdater();
        }
        return b;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return new MirroredFileUpdater("", "", entry.getBasedir(), this.workdir){

            public File getMirrorFile(File f) {
                String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
                return new File(this.destinationDirectory + File.separator + file);
            }
        };
    }

    @Override
    protected String getOutGetter() {
        return this.outputGetter;
    }

    @Override
    public FileParser newFileParser(Pattern acceptPattern) {
        return new GWTJavaFileParser(this.getLog(), this.encoding, this.oldParser, acceptPattern, this.isShowTouchedFiles());
    }

    public static class GWTJavaProcessor
    extends ProcessorHelper.AbstractParserProcessor {
        protected ProcessorUtil.FragmentExtractor filter1 = new ProcessorUtil.FragmentExtractor("@Key(\"", "\")");
        protected ProcessorUtil.FragmentExtractor filter2 = new ProcessorUtil.FragmentExtractor("@LocalizableResource.Key(\"", "\")");
        protected ProcessorUtil.FragmentExtractor filter3 = new ProcessorUtil.FragmentExtractor("@com.google.gwt.i18n.client.LocalizableResource.Key(\"", "\")");

        @Override
        public void process(File filein, File fileout, String encoding) throws IOException {
            HashSet<String> keys = new HashSet<String>();
            this.extractKeys(this.filter1, filein, encoding, this.verbose, keys);
            this.extractKeys(this.filter2, filein, encoding, this.verbose, keys);
            this.extractKeys(this.filter3, filein, encoding, this.verbose, keys);
            this.saveKeysToFile(fileout, keys);
        }
    }

    protected class GWTJavaFileParser
    extends AbstractFileParser {
        public GWTJavaFileParser(Log log, String encoding, SortedProperties oldParser, Pattern acceptKeyPattern, boolean showTouchedFiles) {
            super(log, encoding, oldParser, acceptKeyPattern, showTouchedFiles);
        }

        @Override
        protected File prepareFile(File file) throws IOException {
            File result = ParserGWTJavaMojo.this.entryUpdater.getMirrorFile(file);
            if (ParserGWTJavaMojo.this.isVerbose()) {
                this.getLog().info((CharSequence)("Will process [" + file + "] to " + result));
            }
            try {
                ParserGWTJavaMojo.this.createDirectoryIfNecessary(result.getParentFile());
            }
            catch (IOException e) {
                // empty catch block
            }
            GWTJavaProcessor processor = new GWTJavaProcessor();
            processor.setVerbose(ParserGWTJavaMojo.this.isVerbose());
            processor.process(file, result, this.getEncoding());
            return result;
        }

        @Override
        public void parseFile(File file) throws IOException {
            File processedFile = this.prepareFile(file);
            String line = null;
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(processedFile), this.getEncoding()));
            try {
                while ((line = lnr.readLine()) != null) {
                    this.parseLine(processedFile, line);
                }
            }
            catch (Exception e) {
                if (line != null) {
                    this.getLog().error((CharSequence)("could not parse line (" + lnr.getLineNumber() + ") '" + line + "' of file " + file));
                }
                throw new ParserException(e);
            }
            finally {
                lnr.close();
            }
        }

        @Override
        public void parseLine(File file, String line) throws IOException {
            String key = line.trim();
            if (key.isEmpty()) {
                return;
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(file.getName() + " detected key = " + key));
            }
            this.registerKey(key);
        }
    }
}

