/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.bundle.AbstractI18nBundleMojo;

public abstract class AbstractMakeI18nBundleMojo
extends AbstractI18nBundleMojo {
    @Parameter(property="i18n.bundleInputEncoding")
    protected String bundleInputEncoding;
    @Parameter(property="i18n.bundleOutputEncoding")
    protected String bundleOutputEncoding;
    @Parameter(property="i18n.bundleOutputDir", defaultValue="${basedir}/target/generated-sources/resources", required=true)
    protected File bundleOutputDir;
    @Parameter(property="i18n.bundleOutputPackage", defaultValue="META-INF", required=true)
    protected String bundleOutputPackage;
    @Parameter(property="i18n.bundleOutputName", defaultValue="${project.artifactId}-i18n", required=true)
    protected String bundleOutputName;
    @Parameter(property="i18n.generateDefaultLocale", defaultValue="false")
    protected boolean generateDefaultLocale;
    @Parameter(property="i18n.checkBundle", defaultValue="true")
    protected boolean checkBundle;
    @Parameter(property="i18n.showEmpty", defaultValue="false")
    protected boolean showEmpty;
    @Parameter(property="i18n.failsIfWarning", defaultValue="false")
    protected boolean failsIfWarning;
    protected Map<Locale, SortedSet<String>> unsafeMapping;
    protected File outputFolder;

    @Override
    public void init() throws Exception {
        super.init();
        if (this.failsIfWarning) {
            this.checkBundle = true;
            this.unsafeMapping = new HashMap<Locale, SortedSet<String>>();
        } else {
            this.unsafeMapping = null;
        }
        this.outputFolder = this.getBundleOutputFolder();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will generates bundles in " + this.outputFolder));
        }
        this.createDirectoryIfNecessary(this.outputFolder);
        if (StringUtils.isEmpty((CharSequence)this.bundleInputEncoding)) {
            this.bundleInputEncoding = this.getEncoding();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Use as input encoding the default one : " + this.bundleInputEncoding));
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.bundleOutputEncoding)) {
            this.bundleOutputEncoding = this.getEncoding();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Use as output encoding the default one : " + this.bundleOutputEncoding));
            }
        }
    }

    protected void failsIfWarning() throws MojoFailureException {
        if (!this.failsIfWarning) {
            return;
        }
        if (this.unsafeMapping != null && !this.unsafeMapping.isEmpty()) {
            throw new MojoFailureException("Bundles for locale(s) " + this.unsafeMapping.keySet() + " are not complete. Use the -Di18n.showEmpty to see " + "missing translations.");
        }
    }

    protected abstract File getBundleFile(File var1, String var2, Locale var3, boolean var4) throws IOException;

    protected void generateDefaultBundle() throws IOException {
        File bundleFirstLocale = this.getBundleFile(this.outputFolder, this.bundleOutputName, this.locales[0], false);
        File bundleWithoutLocale = this.getBundleFile(this.outputFolder, this.bundleOutputName, null, false);
        if (!this.isSilent()) {
            this.getLog().info((CharSequence)("Generate default bundle at " + bundleWithoutLocale));
        }
        FileUtils.copyFile((File)bundleFirstLocale, (File)bundleWithoutLocale);
    }

    protected File getBundleOutputFolder() {
        File result = this.bundleOutputDir;
        if (StringUtils.isNotEmpty((CharSequence)this.bundleOutputPackage)) {
            String[] paths;
            for (String path : paths = this.bundleOutputPackage.split("\\.")) {
                result = new File(result, path);
            }
        }
        return result;
    }

    public String getBundleOutputEncoding() {
        return this.bundleOutputEncoding;
    }

    public String getBundleInputEncoding() {
        return this.bundleInputEncoding;
    }
}

