/*
 * #%L
 * I18n :: Maven Plugin
 * 
 * $Id: GenerateMojo.java 1961 2012-07-09 13:12:35Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/i18n/tags/i18n-2.5.2/i18n-maven-plugin/src/main/java/org/nuiton/i18n/plugin/GenerateMojo.java $
 * %%
 * Copyright (C) 2007 - 2010 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.i18n.plugin;

import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.io.SortedProperties;

import java.io.File;
import java.util.Arrays;
import java.util.Locale;

/**
 * Merge new generated i18n bundles with older existing ones.
 *
 * @author jruchaud <ruchaud@codelutin.com>
 * @author chemit <chemit@codelutin.com>
 */
@Mojo(name = "gen", defaultPhase = LifecyclePhase.GENERATE_RESOURCES)
@Execute(goal = "get")
public class GenerateMojo extends AbstractI18nMojo {

    /**
     * A flag to check that bundles are complete (no missing i18n translations).
     *
     * @since 1.0.0
     */
    @Parameter(property = "i18n.checkBundle", defaultValue = "true", required = true)
    protected boolean checkBundle;

    /**
     * A flag to show missing i18n translation.
     * <p/>
     * <b>Note :</b> Need the {@link #checkBundle} to be activated).
     *
     * @since 1.0.0
     */
    @Parameter(property = "i18n.showEmpty", defaultValue = "false", required = true)
    protected boolean showEmpty;

    /**
     * To keep a backup of old i18n bundles (suffiex by a {@code ~}).
     * <p/>
     * <b>Note: </b> By default, this property is not active.
     */
    @Parameter(property = "i18n.keepBackup", defaultValue = "false")
    protected boolean keepBackup;

    /**
     * To keep generated getter files.
     * <p/>
     * <b>Note: </b> By default, this property is not active.
     */
    @Parameter(property = "i18n.keepGetters", defaultValue = "false")
    protected boolean keepGetters;

    @Override
    protected boolean checkSkip() {
        if (!needGeneration()) {
            getLog().info("No getter detected - all files are up to date.");
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        if (!silent) {
            getLog().info("config - src basedir : " + src.getAbsolutePath());
            getLog().info("config - out basedir : " + out.getAbsolutePath());
            getLog().info("config - locales     : " + Arrays.toString(locales));
        }
        for (Locale locale : locales) {
            if (!silent) {
                getLog().info("prepare bundle for locale " + locale);
            }
            // Merge
            File bundleSrc = getI18nFile(src, artifactId, locale, false);
            File bundleOut = getI18nFile(out, artifactId, locale, false);
            File bundleGetterOut = getI18nFile(
                    out, artifactId + GetterMojo.FROM_GETTERS, locale, false);

            SortedProperties propertiesSrc = new SortedProperties(encoding);

            if (bundleSrc.exists()) {
                propertiesSrc.load(bundleSrc);
            }

            SortedProperties propertiesOut = new SortedProperties(encoding);

            if (!strictMode) {
                // si on n'est pas en mode strict, on doit push back in
                // bundle out, all the bundle src keys
                propertiesOut.putAll(propertiesSrc);
            }

            propertiesOut.load(bundleGetterOut);

            // Parcours des clés
            for (Object key : propertiesOut.keySet()) {
                Object oldKey = propertiesOut.get(key);
                Object value = propertiesSrc.get(oldKey);

                // Récupération de la clé si elle a été renommée
                if (!key.equals(oldKey) && value == null) {
                    value = propertiesSrc.get(key);
                }

                if (value != null) {
                    propertiesOut.put(key, value);
                } else {
                    propertiesOut.put(key, "");
                }
            }

            propertiesOut.store(bundleOut);

            // Sauvegarde avant copie
            if (genSrc && keepBackup) {
                backupFile(bundleSrc);
            }
            if (!silent) {
                getLog().info("merge bundle " + locale + " to out");
            }

            if (checkBundle) {
                checkBundle(locale, propertiesOut, showEmpty, null);
            }

            if (genSrc) {
                // Copie des fichiers dans les sources
//                copyFile(bundleOut, bundleSrc);

                propertiesOut.store(bundleSrc);

                if (!silent) {
                    getLog().info("copy bundle " + locale + " to src");
                }
            }

            if (!keepGetters) {
                if (isVerbose()) {
                    getLog().info("Will delete getter " + bundleGetterOut);
                }
                deleteFile(bundleGetterOut);
            }
        }
    }
}
